/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMedoidsFastPAM1;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.LABInitialMeans;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Priority(value=102)
@Reference(authors="Erich Schubert, Peter J. Rousseeuw", title="Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms", booktitle="preprint, to appear", url="https://arxiv.org/abs/1810.05691", bibkey="DBLP:journals/corr/abs-1810-05691")
public class KMedoidsFastPAM<V>
extends KMedoidsFastPAM1<V> {
    private static final Logging LOG = Logging.getLogger(KMedoidsFastPAM.class);
    private static final String KEY = KMedoidsFastPAM.class.getName();
    protected double fasttol = 0.0;

    public KMedoidsFastPAM(DistanceFunction<? super V> distanceFunction, int k, int maxiter, KMedoidsInitialization<V> initializer) {
        this(distanceFunction, k, maxiter, initializer, 1.0);
    }

    public KMedoidsFastPAM(DistanceFunction<? super V> distanceFunction, int k, int maxiter, KMedoidsInitialization<V> initializer, double fasttol) {
        super(distanceFunction, k, maxiter, initializer);
        this.fasttol = fasttol;
    }

    @Override
    protected void run(DistanceQuery<V> distQ, DBIDs ids, ArrayModifiableDBIDs medoids, WritableIntegerDataStore assignment) {
        new Instance(distQ, ids, assignment, this.fasttol).run(medoids, this.maxiter);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends KMedoidsFastPAM1.Parameterizer<V> {
        public static final OptionID FASTTOL_ID = new OptionID("pam.fasttol", "Tolerance for optimistically performing additional swaps, where 1 executes all fast swaps, 0 only those that are unaffected by the primary swaps.");
        protected double fasttol = 0.0;

        @Override
        protected Class<? extends KMedoidsInitialization> defaultInitializer() {
            return LABInitialMeans.class;
        }

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter fasttolP = (DoubleParameter)((DoubleParameter)new DoubleParameter(FASTTOL_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (config.grab(fasttolP)) {
                this.fasttol = fasttolP.doubleValue();
            }
        }

        @Override
        protected KMedoidsFastPAM<V> makeInstance() {
            return new KMedoidsFastPAM(this.distanceFunction, this.k, this.maxiter, this.initializer, this.fasttol);
        }
    }

    protected static class Instance
    extends KMedoidsFastPAM1.Instance {
        protected double fastswap = 0.0;

        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment, double fasttol) {
            super(distQ, ids, assignment);
            this.fastswap = 1.0 - fasttol;
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int iteration;
            int k = medoids.size();
            double tc = this.assignToNearestCluster(medoids);
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
            }
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            int fastswaps = 0;
            DBIDArrayMIter m = medoids.iter();
            ArrayModifiableDBIDs bestids = DBIDUtil.newArray(k);
            DBIDVar bestid = DBIDUtil.newVar();
            double[] best = new double[k];
            double[] cost = new double[k];
            for (iteration = 1; maxiter <= 0 || iteration <= maxiter; ++iteration) {
                LOG.incrementProcessed(prog);
                this.findBestSwaps(m, bestids, best, cost);
                int min = Instance.argmin(best);
                if (!(best[min] < -1.0E-12 * tc)) break;
                block1: while (min >= 0 && best[min] < -1.0E-12 * tc) {
                    this.updateAssignment(medoids, m, bestids.assignVar(min, bestid), min);
                    tc += best[min];
                    best[min] = Double.POSITIVE_INFINITY;
                    while ((min = Instance.argmin(best)) >= 0 && best[min] < -1.0E-12 * tc) {
                        bestids.assignVar(min, bestid);
                        if (DBIDUtil.equal(m.seek(this.assignment.intValue(bestid) & Short.MAX_VALUE), bestid)) {
                            best[min] = Double.POSITIVE_INFINITY;
                            continue;
                        }
                        double hdist = this.nearest.doubleValue(bestid);
                        double c = this.computeReassignmentCost((DBIDRef)bestid, min) - hdist;
                        if (c <= best[min] * this.fastswap) {
                            best[min] = c;
                            ++fastswaps;
                            continue block1;
                        }
                        best[min] = Double.POSITIVE_INFINITY;
                    }
                }
                if (!LOG.isStatistics()) continue;
                LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", tc));
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics(new LongStatistic(KEY + ".iterations", iteration));
                LOG.statistics(new LongStatistic(KEY + ".fast-swaps", fastswaps));
            }
            DBIDIter it = this.ids.iter();
            while (it.valid()) {
                this.assignment.putInt(it, this.assignment.intValue(it) & Short.MAX_VALUE);
                it.advance();
            }
            return tc;
        }

        protected void findBestSwaps(DBIDArrayIter m, ArrayModifiableDBIDs bestids, double[] best, double[] cost) {
            Arrays.fill(best, Double.POSITIVE_INFINITY);
            DBIDIter h = this.ids.iter();
            while (h.valid()) {
                if (!DBIDUtil.equal(m.seek(this.assignment.intValue(h) & Short.MAX_VALUE), h)) {
                    Arrays.fill(cost, -this.nearest.doubleValue(h));
                    this.computeReassignmentCost((DBIDRef)h, cost);
                    for (int i = 0; i < cost.length; ++i) {
                        double costi = cost[i];
                        if (!(costi < best[i])) continue;
                        best[i] = costi;
                        bestids.set(i, h);
                    }
                }
                h.advance();
            }
        }

        protected static int argmin(double[] best) {
            double min = Double.POSITIVE_INFINITY;
            int ret = -1;
            for (int i = 0; i < best.length; ++i) {
                double v = best[i];
                if (!(v < min)) continue;
                min = v;
                ret = i;
            }
            return ret;
        }

        @Override
        protected double computeReassignmentCost(DBIDRef h, int mnum) {
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (!DBIDUtil.equal(h, j)) {
                    double distcur = this.nearest.doubleValue(j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    if ((this.assignment.intValue(j) & Short.MAX_VALUE) == mnum) {
                        cost += Math.min(dist_h, this.second.doubleValue(j)) - distcur;
                    } else if (dist_h < distcur) {
                        cost += dist_h - distcur;
                    }
                }
                j.advance();
            }
            return cost;
        }
    }
}

