/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMedoidsPAM;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.Arrays;

@Reference(authors="Erich Schubert, Peter J. Rousseeuw", title="Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms", booktitle="preprint, to appear", url="https://arxiv.org/abs/1810.05691", bibkey="DBLP:journals/corr/abs-1810-05691")
@Priority(value=-100)
public class KMedoidsFastPAM1<V>
extends KMedoidsPAM<V> {
    private static final Logging LOG = Logging.getLogger(KMedoidsFastPAM1.class);
    private static final String KEY = KMedoidsFastPAM1.class.getName();

    public KMedoidsFastPAM1(DistanceFunction<? super V> distanceFunction, int k, int maxiter, KMedoidsInitialization<V> initializer) {
        super(distanceFunction, k, maxiter, initializer);
    }

    @Override
    protected void run(DistanceQuery<V> distQ, DBIDs ids, ArrayModifiableDBIDs medoids, WritableIntegerDataStore assignment) {
        new Instance(distQ, ids, assignment).run(medoids, this.maxiter);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends KMedoidsPAM.Parameterizer<V> {
        @Override
        protected KMedoidsFastPAM1<V> makeInstance() {
            return new KMedoidsFastPAM1(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends KMedoidsPAM.Instance {
        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int iteration;
            int k = medoids.size();
            double tc = this.assignToNearestCluster(medoids);
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
            }
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            DBIDVar bestid = DBIDUtil.newVar();
            DBIDArrayMIter m = medoids.iter();
            double[] cost = new double[k];
            for (iteration = 1; maxiter <= 0 || iteration <= maxiter; ++iteration) {
                LOG.incrementProcessed(prog);
                double best = Double.POSITIVE_INFINITY;
                int bestcluster = -1;
                DBIDIter h = this.ids.iter();
                while (h.valid()) {
                    if (!DBIDUtil.equal(m.seek(this.assignment.intValue(h) & Short.MAX_VALUE), h)) {
                        Arrays.fill(cost, -this.nearest.doubleValue(h));
                        this.computeReassignmentCost((DBIDRef)h, cost);
                        for (int i = 0; i < k; ++i) {
                            double costi = cost[i];
                            if (!(costi < best)) continue;
                            best = costi;
                            bestid.set(h);
                            bestcluster = i;
                        }
                    }
                    h.advance();
                }
                if (!(best < -1.0E-12 * tc)) break;
                this.updateAssignment(medoids, m, bestid, bestcluster);
                tc += best;
                if (!LOG.isStatistics()) continue;
                LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", tc));
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics(new LongStatistic(KEY + ".iterations", iteration));
            }
            DBIDIter it = this.ids.iter();
            while (it.valid()) {
                this.assignment.putInt(it, this.assignment.intValue(it) & Short.MAX_VALUE);
                it.advance();
            }
            return tc;
        }

        @Override
        protected double assignToNearestCluster(ArrayDBIDs means) {
            DBIDArrayIter miter = means.iter();
            double cost = 0.0;
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                double mindist = Double.POSITIVE_INFINITY;
                double mindist2 = Double.POSITIVE_INFINITY;
                int minindx = -1;
                int minindx2 = -1;
                miter.seek(0);
                while (miter.valid()) {
                    double dist = this.distQ.distance((DBIDRef)iditer, (DBIDRef)miter);
                    if (dist < mindist) {
                        minindx2 = minindx;
                        mindist2 = mindist;
                        minindx = miter.getOffset();
                        mindist = dist;
                    } else if (dist < mindist2) {
                        minindx2 = miter.getOffset();
                        mindist2 = dist;
                    }
                    miter.advance();
                }
                if (minindx < 0) {
                    throw new AbortException("Too many infinite distances. Cannot assign objects.");
                }
                this.assignment.put((DBIDRef)iditer, minindx | minindx2 << 16);
                this.nearest.put((DBIDRef)iditer, mindist);
                this.second.put((DBIDRef)iditer, mindist2);
                cost += mindist;
                iditer.advance();
            }
            return cost;
        }

        protected void computeReassignmentCost(DBIDRef h, double[] cost) {
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (!DBIDUtil.equal(h, j)) {
                    int pj;
                    double distcur = this.nearest.doubleValue(j);
                    double distsec = this.second.doubleValue(j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    int n = pj = this.assignment.intValue(j) & Short.MAX_VALUE;
                    cost[n] = cost[n] + (Math.min(dist_h, distsec) - distcur);
                    if (dist_h < distcur) {
                        double delta = dist_h - distcur;
                        int pi = 0;
                        while (pi < pj) {
                            int n2 = pi++;
                            cost[n2] = cost[n2] + delta;
                        }
                        pi = pj + 1;
                        while (pi < cost.length) {
                            int n3 = pi++;
                            cost[n3] = cost[n3] + delta;
                        }
                    }
                }
                j.advance();
            }
        }

        protected void updateAssignment(ArrayModifiableDBIDs medoids, DBIDArrayIter miter, DBIDRef h, int m) {
            medoids.set(m, h);
            double hdist = this.nearest.putDouble(h, 0.0);
            int olda = this.assignment.intValue(h);
            if ((olda & Short.MAX_VALUE) != m) {
                this.assignment.putInt(h, m | (olda & Short.MAX_VALUE) << 16);
                this.second.putDouble(h, hdist);
            } else {
                this.assignment.putInt(h, m | olda & 0x7FFF0000);
            }
            assert (DBIDUtil.equal(h, miter.seek(m)));
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (!DBIDUtil.equal(h, j)) {
                    double distcur = this.nearest.doubleValue(j);
                    double distsec = this.second.doubleValue(j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    int pj = this.assignment.intValue(j);
                    int po = pj >>> 16;
                    if ((pj &= Short.MAX_VALUE) == m) {
                        if (dist_h < distsec) {
                            this.nearest.putDouble(j, dist_h);
                            this.assignment.putInt(j, m | po << 16);
                        } else {
                            this.nearest.putDouble(j, distsec);
                            this.assignment.putInt(j, po | this.updateSecondNearest(j, miter, m, dist_h, po) << 16);
                        }
                    } else if (dist_h < distcur) {
                        this.nearest.putDouble(j, dist_h);
                        this.second.putDouble(j, distcur);
                        this.assignment.putInt(j, m | pj << 16);
                    } else if (po == m) {
                        this.assignment.putInt(j, pj | this.updateSecondNearest(j, miter, m, dist_h, pj) << 16);
                    } else if (dist_h < distsec) {
                        this.second.putDouble(j, dist_h);
                        this.assignment.putInt(j, pj | m << 16);
                    }
                }
                j.advance();
            }
        }

        private int updateSecondNearest(DBIDRef j, DBIDArrayIter medoids, int h, double dist_h, int n) {
            double sdist = dist_h;
            int sbest = h;
            medoids.seek(0);
            while (medoids.valid()) {
                double d;
                if (medoids.getOffset() != h && medoids.getOffset() != n && (d = this.distQ.distance(j, (DBIDRef)medoids)) < sdist) {
                    sdist = d;
                    sbest = medoids.getOffset();
                }
                medoids.advance();
            }
            this.second.putDouble(j, sdist);
            return sbest;
        }
    }
}

