/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithmUtil;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.PAMInitialMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Partioning Around Medoids")
@Priority(value=100)
@References(value={@Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Clustering by means of Medoids", booktitle="Statistical Data Analysis Based on the L1-Norm and Related Methods", bibkey="books/misc/KauRou87"), @Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Partitioning Around Medoids (Program PAM)", booktitle="Finding Groups in Data: An Introduction to Cluster Analysis", url="https://doi.org/10.1002/9780470316801.ch2", bibkey="doi:10.1002/9780470316801.ch2")})
public class KMedoidsPAM<V>
extends AbstractDistanceBasedAlgorithm<V, Clustering<MedoidModel>>
implements ClusteringAlgorithm<Clustering<MedoidModel>> {
    private static final Logging LOG = Logging.getLogger(KMedoidsPAM.class);
    protected int k;
    protected int maxiter;
    protected KMedoidsInitialization<V> initializer;

    public KMedoidsPAM(DistanceFunction<? super V> distanceFunction, int k, int maxiter, KMedoidsInitialization<V> initializer) {
        super(distanceFunction);
        this.k = k;
        this.maxiter = maxiter;
        this.initializer = initializer;
    }

    public Clustering<MedoidModel> run(Database database, Relation<V> relation) {
        if (this.k > Short.MAX_VALUE) {
            throw new NotImplementedException("PAM supports at most 32767 clusters.");
        }
        DistanceQuery<V> distQ = DatabaseUtil.precomputedDistanceQuery(database, relation, this.getDistanceFunction(), LOG);
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage(ids, 3, -1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        this.run(distQ, ids, medoids, assignment);
        this.getLogger().statistics(optd.end());
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, assignment, this.k);
        Clustering<MedoidModel> result = new Clustering<MedoidModel>("PAM Clustering", "pam-clustering");
        DBIDArrayMIter it = medoids.iter();
        while (it.valid()) {
            result.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)clusters[it.getOffset()], new MedoidModel(DBIDUtil.deref(it))));
            it.advance();
        }
        return result;
    }

    protected ArrayModifiableDBIDs initialMedoids(DistanceQuery<V> distQ, DBIDs ids) {
        if (this.getLogger().isStatistics()) {
            this.getLogger().statistics(new StringStatistic(this.getClass().getName() + ".initialization", this.initializer.toString()));
        }
        Duration initd = this.getLogger().newDuration(this.getClass().getName() + ".initialization-time").begin();
        ArrayModifiableDBIDs medoids = DBIDUtil.newArray(this.initializer.chooseInitialMedoids(this.k, ids, distQ));
        this.getLogger().statistics(initd.end());
        if (medoids.size() != this.k) {
            throw new AbortException("Initializer " + this.initializer.toString() + " did not return " + this.k + " means, but " + medoids.size());
        }
        return medoids;
    }

    protected void run(DistanceQuery<V> distQ, DBIDs ids, ArrayModifiableDBIDs medoids, WritableIntegerDataStore assignment) {
        new Instance(distQ, ids, assignment).run(medoids, this.maxiter);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        protected int k;
        protected int maxiter;
        protected KMedoidsInitialization<V> initializer;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter maxiterP;
            ObjectParameter initialP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(initialP = new ObjectParameter(KMeans.INIT_ID, (Class<?>)KMedoidsInitialization.class, this.defaultInitializer()))) {
                this.initializer = (KMedoidsInitialization)initialP.instantiateClass(config);
            }
            if (config.grab(maxiterP = (IntParameter)new IntParameter(KMeans.MAXITER_ID, 0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT))) {
                this.maxiter = maxiterP.intValue();
            }
        }

        protected Class<? extends KMedoidsInitialization> defaultInitializer() {
            return PAMInitialMeans.class;
        }

        @Override
        protected KMedoidsPAM<V> makeInstance() {
            return new KMedoidsPAM<V>(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance {
        DBIDs ids;
        DistanceQuery<?> distQ;
        WritableDoubleDataStore nearest;
        WritableDoubleDataStore second;
        WritableIntegerDataStore assignment;

        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            this.distQ = distQ;
            this.ids = ids;
            this.assignment = assignment;
            this.nearest = DataStoreUtil.makeDoubleStorage(ids, 3);
            this.second = DataStoreUtil.makeDoubleStorage(ids, 3);
        }

        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int iteration;
            int k = medoids.size();
            double tc = this.assignToNearestCluster(medoids);
            String key = this.getClass().getName();
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(key + ".iteration-" + 0 + ".cost", tc));
            }
            boolean metric = this.distQ.getDistanceFunction().isMetric();
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            DBIDVar bestid = DBIDUtil.newVar();
            DBIDArrayMIter m = medoids.iter();
            for (iteration = 1; maxiter <= 0 || iteration <= maxiter; ++iteration) {
                LOG.incrementProcessed(prog);
                double best = Double.POSITIVE_INFINITY;
                int bestcluster = -1;
                DBIDIter h = this.ids.iter();
                while (h.valid()) {
                    if (!DBIDUtil.equal(m.seek(this.assignment.intValue(h)), h)) {
                        double hdist = this.nearest.doubleValue(h);
                        if (!metric || !(hdist <= 0.0)) {
                            for (int pi = 0; pi < k; ++pi) {
                                double cpi = this.computeReassignmentCost(h, pi) - hdist;
                                if (!(cpi < best)) continue;
                                best = cpi;
                                bestid.set(h);
                                bestcluster = pi;
                            }
                        }
                    }
                    h.advance();
                }
                if (!(best < -1.0E-12 * tc)) break;
                medoids.set(bestcluster, bestid);
                double nc = this.assignToNearestCluster(medoids);
                if (LOG.isStatistics()) {
                    LOG.statistics(new DoubleStatistic(key + ".iteration-" + iteration + ".cost", nc));
                }
                if (nc > tc) {
                    if (nc - tc < 1.0E-7 * tc) {
                        LOG.warning("PAM failed to converge (numerical instability?)");
                        break;
                    }
                    LOG.warning("PAM failed to converge: costs increased by: " + (nc - tc) + " exepected a decrease by " + best);
                    break;
                }
                tc = nc;
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics(new LongStatistic(key + ".iterations", iteration));
            }
            return tc;
        }

        protected double computeReassignmentCost(DBIDRef h, int mnum) {
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (!DBIDUtil.equal(h, j)) {
                    double distcur = this.nearest.doubleValue(j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    if (this.assignment.intValue(j) == mnum) {
                        double distsec = this.second.doubleValue(j);
                        cost += Math.min(dist_h, distsec) - distcur;
                    } else if (dist_h < distcur) {
                        cost += dist_h - distcur;
                    }
                }
                j.advance();
            }
            return cost;
        }

        protected double assignToNearestCluster(ArrayDBIDs means) {
            DBIDArrayIter miter = means.iter();
            double cost = 0.0;
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                double mindist = Double.POSITIVE_INFINITY;
                double mindist2 = Double.POSITIVE_INFINITY;
                int minindx = -1;
                miter.seek(0);
                while (miter.valid()) {
                    double dist = this.distQ.distance((DBIDRef)iditer, (DBIDRef)miter);
                    if (dist < mindist) {
                        mindist2 = mindist;
                        minindx = miter.getOffset();
                        mindist = dist;
                    } else if (dist < mindist2) {
                        mindist2 = dist;
                    }
                    miter.advance();
                }
                if (minindx < 0) {
                    throw new AbortException("Too many infinite distances. Cannot assign objects.");
                }
                this.assignment.put((DBIDRef)iditer, minindx);
                this.nearest.put((DBIDRef)iditer, mindist);
                this.second.put((DBIDRef)iditer, mindist2);
                cost += mindist;
                iditer.advance();
            }
            return cost;
        }
    }
}

