/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMedoidsPAM;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="A. P. Reynolds, G. Richards, B. de la Iglesia, V. J. Rayward-Smith", title="Clustering Rules: A Comparison of Partitioning and Hierarchical Clustering Algorithms", booktitle="J. Math. Model. Algorithms 5(4)", url="https://doi.org/10.1007/s10852-005-9022-1", bibkey="DBLP:journals/jmma/ReynoldsRIR06")
public class KMedoidsPAMReynolds<V>
extends KMedoidsPAM<V> {
    private static final Logging LOG = Logging.getLogger(KMedoidsPAMReynolds.class);
    private static final String KEY = KMedoidsPAMReynolds.class.getName();

    public KMedoidsPAMReynolds(DistanceFunction<? super V> distanceFunction, int k, int maxiter, KMedoidsInitialization<V> initializer) {
        super(distanceFunction, k, maxiter, initializer);
    }

    @Override
    protected void run(DistanceQuery<V> distQ, DBIDs ids, ArrayModifiableDBIDs medoids, WritableIntegerDataStore assignment) {
        new Instance(distQ, ids, assignment).run(medoids, this.maxiter);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends KMedoidsPAM.Parameterizer<V> {
        @Override
        protected KMedoidsPAMReynolds<V> makeInstance() {
            return new KMedoidsPAMReynolds(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends KMedoidsPAM.Instance {
        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int iteration;
            int k = medoids.size();
            double tc = this.assignToNearestCluster(medoids);
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
            }
            WritableDoubleDataStore tnearest = DataStoreUtil.makeDoubleStorage(this.ids, 3);
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            DBIDVar bestid = DBIDUtil.newVar();
            for (iteration = 1; maxiter <= 0 || iteration <= maxiter; ++iteration) {
                LOG.incrementProcessed(prog);
                double best = Double.POSITIVE_INFINITY;
                int bestcluster = -1;
                for (int pi = 0; pi < k; ++pi) {
                    double basecost = this.computeRemovalCost(pi, tnearest);
                    DBIDIter h = this.ids.iter();
                    while (h.valid()) {
                        double cpi = basecost + this.computeReassignmentCost((DBIDRef)h, tnearest);
                        if (cpi < best) {
                            best = cpi;
                            bestid.set(h);
                            bestcluster = pi;
                        }
                        h.advance();
                    }
                }
                if (!(best < -1.0E-12 * tc)) break;
                medoids.set(bestcluster, bestid);
                double nc = this.assignToNearestCluster(medoids);
                if (LOG.isStatistics()) {
                    LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", nc));
                }
                if (nc > tc) {
                    if (nc - tc < 1.0E-7 * tc) {
                        LOG.warning("PAM failed to converge (numerical instability?)");
                        break;
                    }
                    LOG.warning("PAM failed to converge: costs increased by: " + (nc - tc) + " exepected a decrease by " + best);
                    break;
                }
                tc = nc;
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics(new LongStatistic(KEY + ".iterations", iteration));
            }
            return tc;
        }

        protected double computeRemovalCost(int i, WritableDoubleDataStore tnearest) {
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                double n = this.nearest.doubleValue(j);
                if (this.assignment.intValue(j) == i) {
                    double s = this.second.doubleValue(j);
                    cost += s - n;
                    tnearest.put((DBIDRef)j, s);
                } else {
                    tnearest.put((DBIDRef)j, n);
                }
                j.advance();
            }
            return cost;
        }

        protected double computeReassignmentCost(DBIDRef h, WritableDoubleDataStore tnearest) {
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                double cur;
                double dist = this.distQ.distance(h, (DBIDRef)j);
                if (dist < (cur = tnearest.doubleValue(j))) {
                    cost += dist - cur;
                }
                j.advance();
            }
            return cost;
        }
    }
}

