/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.ParkInitialMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

@References(value={@Reference(authors="H.-S. Park, C.-H. Jun", title="A simple and fast algorithm for K-medoids clustering", booktitle="Expert Systems with Applications 36(2)", url="https://doi.org/10.1016/j.eswa.2008.01.039", bibkey="DBLP:journals/eswa/ParkJ09"), @Reference(authors="A. P. Reynolds, G. Richards, B. de la Iglesia, V. J. Rayward-Smith", title="Clustering Rules: A Comparison of Partitioning and Hierarchical Clustering Algorithms", booktitle="J. Math. Model. Algorithms 5(4)", url="https://doi.org/10.1007/s10852-005-9022-1", bibkey="DBLP:journals/jmma/ReynoldsRIR06")})
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMedoidsEM"})
public class KMedoidsPark<V>
extends AbstractDistanceBasedAlgorithm<V, Clustering<MedoidModel>>
implements ClusteringAlgorithm<Clustering<MedoidModel>> {
    private static final Logging LOG = Logging.getLogger(KMedoidsPark.class);
    private static final String KEY = KMedoidsPark.class.getName();
    protected int k;
    protected int maxiter;
    protected KMedoidsInitialization<V> initializer;

    public KMedoidsPark(DistanceFunction<? super V> distanceFunction, int k, int maxiter, KMedoidsInitialization<V> initializer) {
        super(distanceFunction);
        this.k = k;
        this.maxiter = maxiter;
        this.initializer = initializer;
    }

    public Clustering<MedoidModel> run(Database database, Relation<V> relation) {
        DistanceQuery<V> distQ = DatabaseUtil.precomputedDistanceQuery(database, relation, this.getDistanceFunction(), LOG);
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        ArrayModifiableDBIDs medoids = DBIDUtil.newArray(this.initializer.chooseInitialMedoids(this.k, relation.getDBIDs(), distQ));
        DBIDArrayMIter miter = medoids.iter();
        double[] mdists = new double[this.k];
        ArrayList<HashSetModifiableDBIDs> clusters = new ArrayList<HashSetModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            HashSetModifiableDBIDs set = DBIDUtil.newHashSet(relation.size() / this.k);
            set.add(miter.seek(i));
            clusters.add(set);
        }
        double tc = this.assignToNearestCluster(miter, mdists, clusters, distQ);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
        }
        IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("K-Medoids EM iteration", LOG) : null;
        int iteration = 0;
        DBIDVar best = DBIDUtil.newVar();
        while (true) {
            boolean changed = false;
            int i = 0;
            miter.seek(0);
            while (miter.valid()) {
                best.unset();
                double bestm = mdists[i];
                DBIDMIter iter = ((ModifiableDBIDs)clusters.get(i)).iter();
                while (iter.valid()) {
                    if (!DBIDUtil.equal(miter, iter)) {
                        double sum = 0.0;
                        DBIDMIter iter2 = ((ModifiableDBIDs)clusters.get(i)).iter();
                        while (iter2.valid()) {
                            if (!DBIDUtil.equal(iter, iter2)) {
                                sum += distQ.distance((DBIDRef)iter, (DBIDRef)iter2);
                            }
                            iter2.advance();
                        }
                        if (sum < bestm) {
                            best.set(iter);
                            bestm = sum;
                        }
                    }
                    iter.advance();
                }
                if (best.isSet() && !DBIDUtil.equal(miter, best)) {
                    changed = true;
                    assert (((ModifiableDBIDs)clusters.get(i)).contains(best));
                    medoids.set(i, best);
                    mdists[i] = bestm;
                }
                miter.advance();
                ++i;
            }
            if (!changed) break;
            double nc = this.assignToNearestCluster(miter, mdists, clusters, distQ);
            ++iteration;
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", nc));
            }
            LOG.incrementProcessed(prog);
        }
        LOG.setCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", iteration));
        }
        Clustering<MedoidModel> result = new Clustering<MedoidModel>("k-Medoids Clustering", "kmedoids-clustering");
        DBIDArrayMIter it = medoids.iter();
        while (it.valid()) {
            result.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)clusters.get(it.getOffset()), new MedoidModel(DBIDUtil.deref(it))));
            it.advance();
        }
        return result;
    }

    protected double assignToNearestCluster(DBIDArrayIter miter, double[] dsum, List<? extends ModifiableDBIDs> clusters, DistanceQuery<V> distQ) {
        double cost = 0.0;
        double[] dists = new double[this.k];
        DBIDIter iditer = distQ.getRelation().iterDBIDs();
        while (iditer.valid()) {
            int current = this.currentCluster(clusters, iditer);
            int minindex = -1;
            double mindist = Double.POSITIVE_INFINITY;
            if (current >= 0) {
                minindex = current;
                mindist = dists[current] = distQ.distance((DBIDRef)iditer, (DBIDRef)miter.seek(current));
            }
            miter.seek(0);
            while (miter.valid()) {
                if (miter.getOffset() != current) {
                    double d = dists[miter.getOffset()] = distQ.distance((DBIDRef)iditer, (DBIDRef)miter);
                    double d2 = d;
                    if (d2 < mindist) {
                        minindex = miter.getOffset();
                        mindist = d2;
                    }
                }
                miter.advance();
            }
            cost += mindist;
            if (minindex != current) {
                if (!clusters.get(minindex).add(iditer)) {
                    throw new IllegalStateException("Reassigning to the same cluster. " + current + " -> " + minindex);
                }
                int n = minindex;
                dsum[n] = dsum[n] + mindist;
                if (current >= 0) {
                    if (!clusters.get(current).remove(iditer)) {
                        throw new IllegalStateException("Removing from the wrong cluster.");
                    }
                    int n2 = current;
                    dsum[n2] = dsum[n2] - dists[current];
                }
            }
            iditer.advance();
        }
        return cost;
    }

    protected int currentCluster(List<? extends ModifiableDBIDs> clusters, DBIDRef id) {
        for (int i = 0; i < this.k; ++i) {
            if (!clusters.get(i).contains(id)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        protected int k;
        protected int maxiter;
        protected KMedoidsInitialization<V> initializer;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter maxiterP;
            ObjectParameter initialP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(initialP = new ObjectParameter(KMeans.INIT_ID, (Class<?>)KMedoidsInitialization.class, ParkInitialMeans.class))) {
                this.initializer = (KMedoidsInitialization)initialP.instantiateClass(config);
            }
            if (config.grab(maxiterP = (IntParameter)new IntParameter(KMeans.MAXITER_ID, 0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT))) {
                this.maxiter = maxiterP.intValue();
            }
        }

        @Override
        protected KMedoidsPark<V> makeInstance() {
            return new KMedoidsPark<V>(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }
}

