/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

public class SingleAssignmentKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(SingleAssignmentKMeans.class);

    public SingleAssignmentKMeans(NumberVectorDistanceFunction<? super V> distanceFunction, int k, KMeansInitialization initializer) {
        super(distanceFunction, k, 1, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(1);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected void makeOptions(Parameterization config) {
            this.getParameterDistanceFunction(config);
            this.getParameterK(config);
            this.getParameterInitialization(config);
        }

        @Override
        protected SingleAssignmentKMeans<V> makeInstance() {
            return new SingleAssignmentKMeans(this.distanceFunction, this.k, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int iterate(int iteration) {
            assert (iteration == 1);
            return -this.assignToNearestCluster();
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

