/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.FarthestPointsInitialMeans"})
public class FarthestPointsInitialMeans<O>
extends AbstractKMeansInitialization
implements KMedoidsInitialization<O> {
    boolean dropfirst = true;

    public FarthestPointsInitialMeans(RandomFactory rnd, boolean dropfirst) {
        super(rnd);
        this.dropfirst = dropfirst;
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        int i;
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore store = DataStoreUtil.makeDoubleStorage(ids, 3, Double.POSITIVE_INFINITY);
        double[][] means = new double[k][];
        DBIDVar first = DBIDUtil.randomSample(ids, this.rnd);
        NumberVector prevmean = relation.get(first);
        means[0] = prevmean.toArray();
        DBIDVar best = DBIDUtil.newVar(first);
        int n = i = this.dropfirst ? 0 : 1;
        while (i < k) {
            double maxdist = Double.NEGATIVE_INFINITY;
            DBIDIter it = ids.iter();
            while (it.valid()) {
                double prev = store.doubleValue(it);
                if (prev == prev) {
                    double val = Math.min(prev, distanceFunction.distance(prevmean, relation.get(it)));
                    if (i > 0) {
                        store.putDouble(it, val);
                    }
                    if (val > maxdist) {
                        maxdist = val;
                        best.set(it);
                    }
                }
                it.advance();
            }
            store.putDouble(best, Double.NaN);
            prevmean = relation.get(best);
            means[i] = prevmean.toArray();
            ++i;
        }
        store.destroy();
        return means;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        int i;
        Relation<O> relation = distQ.getRelation();
        WritableDoubleDataStore store = DataStoreUtil.makeDoubleStorage(ids, 3, Double.POSITIVE_INFINITY);
        ArrayModifiableDBIDs means = DBIDUtil.newArray(k);
        DBIDVar first = DBIDUtil.randomSample(ids, this.rnd);
        DBIDVar prevmean = DBIDUtil.newVar(first);
        means.add(first);
        DBIDVar best = DBIDUtil.newVar(first);
        int n = i = this.dropfirst ? 0 : 1;
        while (i < k) {
            double maxdist = Double.NEGATIVE_INFINITY;
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                double prev = store.doubleValue(it);
                if (prev == prev) {
                    double val = Math.min(prev, distQ.distance((DBIDRef)prevmean, (DBIDRef)it));
                    if (i > 0) {
                        store.putDouble(it, val);
                    }
                    if (val > maxdist) {
                        maxdist = val;
                        best.set(it);
                    }
                }
                it.advance();
            }
            if (i == 0) {
                means.clear();
            }
            store.putDouble(best, Double.NaN);
            prevmean.set(best);
            means.add(best);
            ++i;
        }
        return means;
    }

    public static class Parameterizer<O>
    extends AbstractKMeansInitialization.Parameterizer {
        public static final OptionID KEEPFIRST_ID = new OptionID("farthest.keepfirst", "Keep the first object chosen (which is chosen randomly) for the farthest points heuristic.");
        protected boolean keepfirst = false;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Flag dropfirstP = new Flag(KEEPFIRST_ID);
            if (config.grab(dropfirstP)) {
                this.keepfirst = dropfirstP.isTrue();
            }
        }

        @Override
        protected FarthestPointsInitialMeans<O> makeInstance() {
            return new FarthestPointsInitialMeans(this.rnd, !this.keepfirst);
        }
    }
}

