/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.FarthestPointsInitialMeans;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;

public class FarthestSumPointsInitialMeans<O>
extends FarthestPointsInitialMeans<O> {
    public FarthestSumPointsInitialMeans(RandomFactory rnd, boolean dropfirst) {
        super(rnd, dropfirst);
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        int i;
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore store = DataStoreUtil.makeDoubleStorage(ids, 3, 0.0);
        ArrayList<NumberVector> means = new ArrayList<NumberVector>(k);
        DBIDVar first = DBIDUtil.randomSample(ids, this.rnd);
        NumberVector prevmean = relation.get(first);
        means.add(prevmean);
        DBIDVar best = DBIDUtil.newVar(first);
        int n = i = this.dropfirst ? 0 : 1;
        while (i < k) {
            double maxdist = Double.NEGATIVE_INFINITY;
            DBIDIter it = ids.iter();
            while (it.valid()) {
                double prev = store.doubleValue(it);
                if (prev == prev) {
                    double dsum = prev + distanceFunction.distance(prevmean, relation.get(it));
                    if (i > 0) {
                        store.putDouble(it, dsum);
                    }
                    if (dsum > maxdist) {
                        maxdist = dsum;
                        best.set(it);
                    }
                }
                it.advance();
            }
            if (i == 0) {
                means.clear();
            }
            store.putDouble(best, Double.NaN);
            prevmean = relation.get(best);
            means.add(prevmean);
            ++i;
        }
        store.destroy();
        return FarthestSumPointsInitialMeans.unboxVectors(means);
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        int i;
        Relation<O> relation = distQ.getRelation();
        WritableDoubleDataStore store = DataStoreUtil.makeDoubleStorage(ids, 3, 0.0);
        ArrayModifiableDBIDs means = DBIDUtil.newArray(k);
        DBIDVar first = DBIDUtil.randomSample(ids, this.rnd);
        means.add(first);
        DBIDVar prevmean = DBIDUtil.newVar(first);
        DBIDVar best = DBIDUtil.newVar(first);
        int n = i = this.dropfirst ? 0 : 1;
        while (i < k) {
            double maxdist = Double.NEGATIVE_INFINITY;
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                double prev = store.doubleValue(it);
                if (prev == prev) {
                    double dsum = prev + distQ.distance((DBIDRef)prevmean, (DBIDRef)it);
                    if (i > 0) {
                        store.putDouble(it, dsum);
                    }
                    if (dsum > maxdist) {
                        maxdist = dsum;
                        best.set(it);
                    }
                }
                it.advance();
            }
            if (i == 0) {
                means.clear();
            }
            store.putDouble(best, Double.NaN);
            prevmean.set(best);
            means.add(best);
            ++i;
        }
        store.destroy();
        return means;
    }

    public static class Parameterizer<V>
    extends FarthestPointsInitialMeans.Parameterizer<V> {
        protected boolean keepfirst = false;

        @Override
        protected FarthestSumPointsInitialMeans<V> makeInstance() {
            return new FarthestSumPointsInitialMeans(this.rnd, !this.keepfirst);
        }
    }
}

