/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.FirstKInitialMeans"})
@Reference(authors="J. MacQueen", title="Some Methods for Classification and Analysis of Multivariate Observations", booktitle="5th Berkeley Symp. Math. Statist. Prob.", url="http://projecteuclid.org/euclid.bsmsp/1200512992", bibkey="conf/bsmsp/MacQueen67")
public class FirstKInitialMeans<O>
implements KMeansInitialization,
KMedoidsInitialization<O> {
    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        DBIDIter iter = relation.iterDBIDs();
        double[][] means = new double[k][];
        for (int i = 0; i < k && iter.valid(); ++i) {
            means[i] = relation.get(iter).toArray();
            iter.advance();
        }
        return means;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distanceFunction) {
        DBIDIter iter = ids.iter();
        ArrayModifiableDBIDs means = DBIDUtil.newArray(k);
        for (int i = 0; i < k && iter.valid(); ++i) {
            means.add(iter);
            iter.advance();
        }
        return means;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        @Override
        protected FirstKInitialMeans<V> makeInstance() {
            return new FirstKInitialMeans();
        }
    }
}

