/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Reference(authors="D. Arthur, S. Vassilvitskii", title="k-means++: the advantages of careful seeding", booktitle="Proc. 18th Annual ACM-SIAM Symposium on Discrete Algorithms (SODA 2007)", url="http://dl.acm.org/citation.cfm?id=1283383.1283494", bibkey="DBLP:conf/soda/ArthurV07")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansPlusPlusInitialMeans"})
public class KMeansPlusPlusInitialMeans<O>
extends AbstractKMeansInitialization
implements KMedoidsInitialization<O> {
    public KMeansPlusPlusInitialMeans(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        DBIDs ids = relation.getDBIDs();
        DistanceQuery<NumberVector> distQ = database.getDistanceQuery(relation, distanceFunction, new Object[0]);
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDVar first = DBIDUtil.randomSample(ids, random);
        NumberVector firstvec = relation.get(first);
        ArrayList<NumberVector> means = new ArrayList<NumberVector>(k);
        means.add(firstvec);
        WritableDoubleDataStore weights = DataStoreUtil.makeDoubleStorage(ids, 3, 0.0);
        double weightsum = KMeansPlusPlusInitialMeans.initialWeights(weights, ids, firstvec, distQ);
        KMeansPlusPlusInitialMeans.chooseRemaining(relation, ids, distQ, k, means, weights, weightsum, random);
        weights.destroy();
        return KMeansPlusPlusInitialMeans.unboxVectors(means);
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDVar first = DBIDUtil.randomSample(ids, random);
        ArrayModifiableDBIDs means = DBIDUtil.newArray(k);
        means.add(first);
        WritableDoubleDataStore weights = DataStoreUtil.makeDoubleStorage(ids, 3, 0.0);
        double weightsum = KMeansPlusPlusInitialMeans.initialWeights(weights, ids, first, distQ);
        KMeansPlusPlusInitialMeans.chooseRemaining(ids, distQ, k, means, weights, weightsum, random);
        weights.destroy();
        return means;
    }

    static double initialWeights(WritableDoubleDataStore weights, DBIDs ids, NumberVector first, DistanceQuery<? super NumberVector> distQ) {
        double weightsum = 0.0;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            double weight = distQ.distance(first, (NumberVector)((Object)it));
            weights.putDouble(it, weight);
            weightsum += weight;
            it.advance();
        }
        return weightsum;
    }

    static double initialWeights(WritableDoubleDataStore weights, DBIDs ids, DBIDRef latest, DistanceQuery<?> distQ) {
        double weightsum = 0.0;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            double weight = distQ.distance(latest, (DBIDRef)it);
            weights.putDouble(it, weight);
            weightsum += weight;
            it.advance();
        }
        return weightsum;
    }

    static void chooseRemaining(Relation<? extends NumberVector> relation, DBIDs ids, DistanceQuery<NumberVector> distQ, int k, List<NumberVector> means, WritableDoubleDataStore weights, double weightsum, Random random) {
        while (true) {
            if (weightsum > Double.MAX_VALUE) {
                throw new IllegalStateException("Could not choose a reasonable mean - too many data points, too large distance sum?");
            }
            if (weightsum < Double.MIN_NORMAL) {
                LoggingUtil.warning("Could not choose a reasonable mean - to few data points?");
            }
            double r = random.nextDouble() * weightsum;
            while (r <= 0.0 && weightsum > Double.MIN_NORMAL) {
                r = random.nextDouble() * weightsum;
            }
            DBIDIter it = ids.iter();
            while (it.valid()) {
                double d;
                r -= weights.doubleValue(it);
                if (d < 0.0) break;
                it.advance();
            }
            if (!it.valid()) {
                weightsum -= r;
                continue;
            }
            NumberVector newmean = relation.get(it);
            means.add(newmean);
            if (means.size() >= k) break;
            weights.putDouble(it, 0.0);
            weightsum = KMeansPlusPlusInitialMeans.updateWeights(weights, ids, newmean, distQ);
        }
    }

    static void chooseRemaining(DBIDs ids, DistanceQuery<?> distQ, int k, ArrayModifiableDBIDs means, WritableDoubleDataStore weights, double weightsum, Random random) {
        while (true) {
            if (weightsum > Double.MAX_VALUE) {
                throw new IllegalStateException("Could not choose a reasonable mean - too many data points, too large distance sum?");
            }
            if (weightsum < Double.MIN_NORMAL) {
                LoggingUtil.warning("Could not choose a reasonable mean - to few data points?");
            }
            double r = random.nextDouble() * weightsum;
            while (r <= 0.0 && weightsum > Double.MIN_NORMAL) {
                r = random.nextDouble() * weightsum;
            }
            DBIDIter it = ids.iter();
            while (it.valid()) {
                double d;
                r -= weights.doubleValue(it);
                if (d <= 0.0) break;
                it.advance();
            }
            if (!it.valid()) {
                weightsum -= r;
                continue;
            }
            means.add(it);
            if (means.size() >= k) break;
            weights.putDouble(it, 0.0);
            weightsum = KMeansPlusPlusInitialMeans.updateWeights(weights, ids, it, distQ);
        }
    }

    private static double updateWeights(WritableDoubleDataStore weights, DBIDs ids, DBIDRef latest, DistanceQuery<?> distQ) {
        double weightsum = 0.0;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            double weight = weights.doubleValue(it);
            if (!(weight <= 0.0)) {
                double newweight = distQ.distance(latest, (DBIDRef)it);
                if (newweight < weight) {
                    weights.putDouble(it, newweight);
                    weight = newweight;
                }
                weightsum += weight;
            }
            it.advance();
        }
        return weightsum;
    }

    private static double updateWeights(WritableDoubleDataStore weights, DBIDs ids, NumberVector latest, DistanceQuery<? super NumberVector> distQ) {
        double weightsum = 0.0;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            double weight = weights.doubleValue(it);
            if (!(weight <= 0.0)) {
                double newweight = distQ.distance(latest, (NumberVector)((Object)it));
                if (newweight < weight) {
                    weights.putDouble(it, newweight);
                    weight = newweight;
                }
                weightsum += weight;
            }
            it.advance();
        }
        return weightsum;
    }

    public static class Parameterizer<V>
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected KMeansPlusPlusInitialMeans<V> makeInstance() {
            return new KMeansPlusPlusInitialMeans(this.rnd);
        }
    }
}

