/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="Erich Schubert, Peter J. Rousseeuw", title="Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms", booktitle="preprint, to appear", url="https://arxiv.org/abs/1810.05691", bibkey="DBLP:journals/corr/abs-1810-05691")
public class LABInitialMeans<O>
implements KMeansInitialization,
KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(LABInitialMeans.class);
    private RandomFactory rnd;

    public LABInitialMeans(RandomFactory rnd) {
        this.rnd = rnd;
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        if (relation.size() < k) {
            throw new AbortException("Database has less than k objects.");
        }
        Relation<? extends NumberVector> rel = relation;
        NumberVectorDistanceFunction<?> distF = distanceFunction;
        DistanceQuery<? extends NumberVector> distQ = database.getDistanceQuery(rel, distF, new Object[0]);
        DBIDs medids = this.chooseInitialMedoids(k, rel.getDBIDs(), (DistanceQuery<? super O>)distQ);
        double[][] medoids = new double[k][];
        DBIDIter iter = medids.iter();
        for (int i = 0; i < k; ++i) {
            medoids[i] = relation.get(iter).toArray();
            iter.advance();
        }
        return medoids;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        ArrayModifiableDBIDs medids = DBIDUtil.newArray(k);
        DBIDArrayMIter mi = medids.iter();
        Random rand = this.rnd.getSingleThreadedRandom();
        int ssize = Math.min(ids.size(), 10 + (int)Math.ceil(Math.sqrt(ids.size())));
        WritableDoubleDataStore mindist = DataStoreUtil.makeDoubleStorage(ids, 3, Double.NaN);
        WritableDoubleDataStore bestd = DataStoreUtil.makeDoubleStorage(ids, 3, Double.NaN);
        WritableDoubleDataStore tempd = DataStoreUtil.makeDoubleStorage(ids, 3, Double.NaN);
        ArrayModifiableDBIDs sample = DBIDUtil.newArray(ids);
        DBIDArrayMIter i = sample.iter();
        DBIDArrayMIter j = sample.iter();
        int range = sample.size();
        LABInitialMeans.shuffle(sample, ssize, range, rand);
        double best = Double.POSITIVE_INFINITY;
        int bestoff = -1;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Choosing initial mean", ssize, LOG) : null;
        i.seek(0);
        while (i.getOffset() < ssize) {
            double sum = 0.0;
            tempd.clear();
            j.seek(0);
            while (j.getOffset() < ssize) {
                double d = distQ.distance((DBIDRef)i, (DBIDRef)j);
                sum += d;
                tempd.putDouble(j, d);
                j.advance();
            }
            if (sum < best) {
                best = sum;
                bestoff = i.getOffset();
                WritableDoubleDataStore temp = mindist;
                mindist = tempd;
                tempd = temp;
            }
            LOG.incrementProcessed(prog);
            i.advance();
        }
        LOG.ensureCompleted(prog);
        medids.add(i.seek(bestoff));
        sample.swap(bestoff, --range);
        FiniteProgress prog2 = LOG.isVerbose() ? new FiniteProgress("Choosing initial medoids", k, LOG) : null;
        LOG.incrementProcessed(prog2);
        while (medids.size() < k) {
            ssize = range < ssize ? range : ssize;
            LABInitialMeans.shuffle(sample, ssize, range, rand);
            double best2 = Double.POSITIVE_INFINITY;
            int bestoff2 = -1;
            i.seek(0);
            while (i.getOffset() < ssize) {
                if (!medids.contains(i)) {
                    double sum = 0.0;
                    tempd.clear();
                    j.seek(0);
                    while (j.getOffset() < ssize) {
                        double prev = LABInitialMeans.getMinDist(j, distQ, mi, mindist);
                        if (prev != 0.0) {
                            double v = MathUtil.min(distQ.distance((DBIDRef)i, (DBIDRef)j), prev);
                            sum += v;
                            tempd.put((DBIDRef)j, v);
                        }
                        j.advance();
                    }
                    if (sum < best2) {
                        best2 = sum;
                        bestoff2 = i.getOffset();
                        WritableDoubleDataStore temp = bestd;
                        bestd = tempd;
                        tempd = temp;
                    }
                }
                i.advance();
            }
            if (bestoff2 < 0) {
                throw new AbortException("No medoid found that improves the criterion function?!? Too many infinite distances.");
            }
            medids.add(i.seek(bestoff2));
            sample.swap(bestoff2, --range);
            WritableDoubleDataStore temp = bestd;
            bestd = mindist;
            mindist = temp;
            LOG.incrementProcessed(prog2);
        }
        LOG.ensureCompleted(prog2);
        mindist.destroy();
        bestd.destroy();
        tempd.destroy();
        return medids;
    }

    protected static double getMinDist(DBIDArrayIter j, DistanceQuery<?> distQ, DBIDArrayIter mi, WritableDoubleDataStore mindist) {
        double prev = mindist.doubleValue(j);
        if (Double.isNaN(prev)) {
            prev = Double.POSITIVE_INFINITY;
            mi.seek(0);
            while (mi.valid()) {
                double d = distQ.distance((DBIDRef)j, (DBIDRef)mi);
                prev = d < prev ? d : prev;
                mi.advance();
            }
            mindist.putDouble(j, prev);
        }
        return prev;
    }

    private static void shuffle(ArrayModifiableDBIDs ids, int ssize, int end, Random random) {
        ssize = ssize < end ? ssize : end;
        for (int i = 1; i < ssize; ++i) {
            ids.swap(i - 1, i + random.nextInt(end - i));
        }
    }

    public static class Parameterizer<V>
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected LABInitialMeans<V> makeInstance() {
            return new LABInitialMeans(this.rnd);
        }
    }
}

