/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansPlusPlusInitialMeans;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Random;

@References(value={@Reference(authors="R. Ostrovsky, Y. Rabani, L. J. Schulman, C. Swamy", title="The effectiveness of Lloyd-type methods for the k-means problem", booktitle="Symposium on Foundations of Computer Science (FOCS)", url="https://doi.org/10.1109/FOCS.2006.75", bibkey="DBLP:conf/focs/OstrovskyRSS062"), @Reference(authors="R. Ostrovsky, Y. Rabani, L. J. Schulman, C. Swamy", title="The effectiveness of lloyd-type methods for the k-means problem", booktitle="Journal of the ACM 59(6)", url="https://doi.org/10.1145/2395116.2395117", bibkey="DBLP:journals/jacm/OstrovskyRSS12")})
public class OstrovskyInitialMeans<O>
extends AbstractKMeansInitialization {
    public OstrovskyInitialMeans(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        if (!(distanceFunction instanceof SquaredEuclideanDistanceFunction)) {
            throw new IllegalArgumentException("This initialization works ONLY with squared Euclidean distances for correctness.");
        }
        DBIDs ids = relation.getDBIDs();
        DistanceQuery<NumberVector> distQ = database.getDistanceQuery(relation, distanceFunction, new Object[0]);
        Random random = this.rnd.getSingleThreadedRandom();
        int dim = RelationUtil.dimensionality(relation);
        MeanVariance[] mv = MeanVariance.newArray(dim);
        DBIDIter it = ids.iter();
        while (it.valid()) {
            NumberVector vec = relation.get(it);
            for (int d = 0; d < dim; ++d) {
                mv[d].put(vec.doubleValue(d));
            }
            it.advance();
        }
        double[] center = new double[dim];
        double total = 0.0;
        for (int d = 0; d < dim; ++d) {
            center[d] = mv[d].getMean();
            total += mv[d].getSumOfSquares();
        }
        double bias = total / (double)ids.size();
        DoubleVector cnv = DoubleVector.wrap(center);
        NumberVector firstvec = null;
        NumberVector secondvec = null;
        double firstdist = 0.0;
        double r = random.nextDouble() * total * 2.0;
        DBIDIter it2 = ids.iter();
        while (it2.valid()) {
            double d;
            firstvec = relation.get(it2);
            firstdist = distQ.distance((NumberVector)cnv, firstvec);
            r -= bias + firstdist;
            if (d <= 0.0) break;
            it2.advance();
        }
        double r2 = random.nextDouble() * (total + (double)relation.size() * firstdist);
        DBIDIter it3 = ids.iter();
        while (it3.valid()) {
            double d;
            secondvec = relation.get(it3);
            double seconddist = distQ.distance(firstvec, secondvec);
            r2 -= seconddist;
            if (d <= 0.0) break;
            it3.advance();
        }
        ArrayList<NumberVector> means = new ArrayList<NumberVector>(k);
        means.add(firstvec);
        means.add(secondvec);
        WritableDoubleDataStore weights = DataStoreUtil.makeDoubleStorage(ids, 3, 0.0);
        double weightsum = OstrovskyInitialMeans.initialWeights(weights, relation, ids, firstvec, secondvec, distQ);
        KMeansPlusPlusInitialMeans.chooseRemaining(relation, ids, distQ, k, means, weights, weightsum, random);
        weights.destroy();
        return OstrovskyInitialMeans.unboxVectors(means);
    }

    protected static <T> double initialWeights(WritableDoubleDataStore weights, Relation<? extends T> relation, DBIDs ids, T first, T second, DistanceQuery<? super T> distQ) {
        double weightsum = 0.0;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            T v = relation.get(it);
            double weight = Math.min(distQ.distance(first, v), distQ.distance(second, v));
            weights.putDouble(it, weight);
            weightsum += weight;
            it.advance();
        }
        return weightsum;
    }

    public static class Parameterizer<V>
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected OstrovskyInitialMeans<V> makeInstance() {
            return new OstrovskyInitialMeans(this.rnd);
        }
    }
}

