/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@References(value={@Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Clustering by means of Medoids", booktitle="Statistical Data Analysis Based on the L1-Norm and Related Methods", bibkey="books/misc/KauRou87"), @Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Partitioning Around Medoids (Program PAM)", booktitle="Finding Groups in Data: An Introduction to Cluster Analysis", url="https://doi.org/10.1002/9780470316801.ch2", bibkey="doi:10.1002/9780470316801.ch2")})
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.PAMInitialMeans"})
public class PAMInitialMeans<O>
implements KMeansInitialization,
KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(PAMInitialMeans.class);

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        if (relation.size() < k) {
            throw new AbortException("Database has less than k objects.");
        }
        Relation<? extends NumberVector> rel = relation;
        NumberVectorDistanceFunction<?> distF = distanceFunction;
        DistanceQuery<? extends NumberVector> distQ = database.getDistanceQuery(rel, distF, new Object[0]);
        DBIDs medids = this.chooseInitialMedoids(k, rel.getDBIDs(), (DistanceQuery<? super O>)distQ);
        double[][] medoids = new double[k][];
        DBIDIter iter = medids.iter();
        for (int i = 0; i < k; ++i) {
            medoids[i] = relation.get(iter).toArray();
            iter.advance();
        }
        return medoids;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        ArrayModifiableDBIDs medids = DBIDUtil.newArray(k);
        DBIDVar bestid = DBIDUtil.newVar();
        WritableDoubleDataStore mindist = DataStoreUtil.makeDoubleStorage(ids, 3);
        WritableDoubleDataStore bestd = DataStoreUtil.makeDoubleStorage(ids, 3);
        WritableDoubleDataStore tempd = DataStoreUtil.makeDoubleStorage(ids, 3);
        double best = Double.POSITIVE_INFINITY;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Choosing initial mean", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double sum = 0.0;
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                double d = distQ.distance((DBIDRef)iter, (DBIDRef)iter2);
                sum += d;
                tempd.putDouble(iter2, d);
                iter2.advance();
            }
            if (sum < best) {
                best = sum;
                bestid.set(iter);
                WritableDoubleDataStore temp = mindist;
                mindist = tempd;
                tempd = temp;
            }
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        medids.add(bestid);
        FiniteProgress prog2 = LOG.isVerbose() ? new FiniteProgress("Choosing initial centers", k, LOG) : null;
        LOG.incrementProcessed(prog2);
        for (int i = 1; i < k; ++i) {
            double best2 = Double.POSITIVE_INFINITY;
            bestid.unset();
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                if (!medids.contains(iter2)) {
                    double sum = 0.0;
                    DBIDIter iter22 = ids.iter();
                    while (iter22.valid()) {
                        double v = MathUtil.min(distQ.distance((DBIDRef)iter2, (DBIDRef)iter22), mindist.doubleValue(iter22));
                        sum += v;
                        tempd.put((DBIDRef)iter22, v);
                        iter22.advance();
                    }
                    if (sum < best2) {
                        best2 = sum;
                        bestid.set(iter2);
                        WritableDoubleDataStore temp = bestd;
                        bestd = tempd;
                        tempd = temp;
                    }
                }
                iter2.advance();
            }
            if (!bestid.isSet()) {
                throw new AbortException("No medoid found that improves the criterion function?!? Too many infinite distances.");
            }
            medids.add(bestid);
            WritableDoubleDataStore temp = bestd;
            bestd = mindist;
            mindist = temp;
            LOG.incrementProcessed(prog2);
        }
        LOG.ensureCompleted(prog2);
        mindist.destroy();
        bestd.destroy();
        tempd.destroy();
        return medids;
    }

    public static class Parameterizer<V>
    extends AbstractParameterizer {
        @Override
        protected PAMInitialMeans<V> makeInstance() {
            return new PAMInitialMeans();
        }
    }
}

