/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Priority(value=-100)
@Reference(authors="H.-S. Park, C.-H. Jun", title="A simple and fast algorithm for K-medoids clustering", booktitle="Expert Systems with Applications 36(2)", url="https://doi.org/10.1016/j.eswa.2008.01.039", bibkey="DBLP:journals/eswa/ParkJ09")
public class ParkInitialMeans<O>
implements KMeansInitialization,
KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(ParkInitialMeans.class);

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        if (relation.size() < k) {
            throw new AbortException("Database has less than k objects.");
        }
        Relation<? extends NumberVector> rel = relation;
        NumberVectorDistanceFunction<?> distF = distanceFunction;
        DistanceQuery<? extends NumberVector> distQ = database.getDistanceQuery(rel, distF, new Object[0]);
        DBIDs medids = this.chooseInitialMedoids(k, rel.getDBIDs(), (DistanceQuery<? super O>)distQ);
        double[][] medoids = new double[k][];
        DBIDIter iter = medids.iter();
        for (int i = 0; i < k; ++i) {
            medoids[i] = relation.get(iter).toArray();
            iter.advance();
        }
        return medoids;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        WritableDoubleDataStore distsum = DataStoreUtil.makeDoubleStorage(ids, 3);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing distance sums", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double sum = 0.0;
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                sum += distQ.distance((DBIDRef)iter, (DBIDRef)iter2);
                iter2.advance();
            }
            distsum.putDouble(iter, sum);
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        KNNHeap knn = DBIDUtil.newHeap(k);
        prog = LOG.isVerbose() ? new FiniteProgress("Computing element scores", ids.size(), LOG) : null;
        DBIDIter iter2 = ids.iter();
        while (iter2.valid()) {
            double sum = 0.0;
            DBIDIter iter22 = ids.iter();
            while (iter22.valid()) {
                sum += distQ.distance((DBIDRef)iter2, (DBIDRef)iter22) / distsum.doubleValue(iter22);
                iter22.advance();
            }
            knn.insert(sum, iter2);
            LOG.incrementProcessed(prog);
            iter2.advance();
        }
        LOG.ensureCompleted(prog);
        distsum.destroy();
        ArrayModifiableDBIDs medids = DBIDUtil.newArray(knn.toKNNList().subList(k));
        return medids;
    }

    public static class Parameterizer<V>
    extends AbstractParameterizer {
        @Override
        protected ParkInitialMeans<V> makeInstance() {
            return new ParkInitialMeans();
        }
    }
}

