/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleArrayListParameter;
import java.util.List;

public class PredefinedInitialMeans
extends AbstractKMeansInitialization {
    double[][] initialMeans;

    public PredefinedInitialMeans(double[][] initialMeans) {
        super(null);
        this.initialMeans = initialMeans;
    }

    public void setInitialMeans(List<double[]> initialMeans) {
        this.setInitialMeans(initialMeans);
    }

    public void setInitialClusters(List<? extends Cluster<? extends MeanModel>> initialMeans) {
        double[][] vecs = new double[initialMeans.size()][];
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = initialMeans.get(i).getModel().getMean();
        }
        this.initialMeans = vecs;
    }

    public void setInitialMeans(double[][] initialMeans) {
        double[][] vecs = (double[][])initialMeans.clone();
        this.initialMeans = vecs;
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        if (k != this.initialMeans.length) {
            throw new AbortException("Predefined initial means contained " + this.initialMeans.length + " means, algorithm requested " + k + " means instead.");
        }
        return this.initialMeans;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID INITIAL_MEANS = new OptionID("kmeans.means", "Initial means for k-means.");
        protected double[][] initialMeans;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleArrayListParameter meansP = new DoubleArrayListParameter(INITIAL_MEANS);
            if (config.grab(meansP)) {
                this.initialMeans = (double[][])((List)meansP.getValue()).toArray((T[])new double[0][]);
            }
        }

        @Override
        protected PredefinedInitialMeans makeInstance() {
            return new PredefinedInitialMeans(this.initialMeans);
        }
    }
}

