/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Priority(value=-101)
@Reference(authors="R. C. Jancey", title="Multidimensional group analysis", booktitle="Australian Journal of Botany 14(1)", url="https://doi.org/10.1071/BT9660127", bibkey="doi:10.1071/BT9660127")
public class RandomNormalGeneratedInitialMeans
extends AbstractKMeansInitialization {
    public RandomNormalGeneratedInitialMeans(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        int dim = RelationUtil.dimensionality(relation);
        MeanVariance[] mvs = MeanVariance.newArray(dim);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            NumberVector v = relation.get(it);
            for (int i = 0; i < dim; ++i) {
                mvs[i].put(v.doubleValue(i));
            }
            it.advance();
        }
        double[] min = new double[dim];
        double[] scale = new double[dim];
        for (int d = 0; d < dim; ++d) {
            double sigma = mvs[d].getSampleStddev();
            min[d] = mvs[d].getMean();
            scale[d] = sigma;
        }
        double[][] means = new double[k][];
        Random random = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < k; ++i) {
            double[] r = new double[dim];
            for (int d = 0; d < dim; ++d) {
                r[d] = min[d] + scale[d] * random.nextGaussian();
            }
            means[i] = r;
        }
        return means;
    }

    public static class Parameterizer
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected RandomNormalGeneratedInitialMeans makeInstance() {
            return new RandomNormalGeneratedInitialMeans(this.rnd);
        }
    }
}

