/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Priority(value=-101)
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.RandomlyGeneratedInitialMeans", "de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.RandomlyGeneratedInitialMeans"})
@Reference(authors="R. C. Jancey", title="Multidimensional group analysis", booktitle="Australian Journal of Botany 14(1)", url="https://doi.org/10.1071/BT9660127", bibkey="doi:10.1071/BT9660127")
public class RandomUniformGeneratedInitialMeans
extends AbstractKMeansInitialization {
    public RandomUniformGeneratedInitialMeans(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        double[][] minmax = RelationUtil.computeMinMax(relation);
        int dim = minmax[0].length;
        double[] min = minmax[0];
        double[] scale = minmax[1];
        for (int d = 0; d < dim; ++d) {
            scale[d] = scale[d] - min[d];
        }
        double[][] means = new double[k][];
        Random random = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < k; ++i) {
            double[] r = new double[dim];
            for (int d = 0; d < dim; ++d) {
                r[d] = min[d] + scale[d] * random.nextDouble();
            }
            means[i] = r;
        }
        return means;
    }

    public static class Parameterizer
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected RandomUniformGeneratedInitialMeans makeInstance() {
            return new RandomUniformGeneratedInitialMeans(this.rnd);
        }
    }
}

