/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@References(value={@Reference(authors="D. J. McRae", title="MIKCA: A FORTRAN IV Iterative K-Means Cluster Analysis Program", booktitle="Behavioral Science 16(4)", bibkey="journals/misc/McRae71"), @Reference(authors="E. W. Forgy", title="Cluster analysis of multivariate data: efficiency versus interpretability of classifications", booktitle="Biometrics 21(3)", bibkey="journals/biometrics/Forgy65"), @Reference(authors="M. R. Anderberg", title="Nonhierarchical Clustering Methods", booktitle="Cluster Analysis for Applications", bibkey="books/academic/Anderberg73/Ch7")})
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.RandomlyChosenInitialMeans"})
public class RandomlyChosenInitialMeans<O>
extends AbstractKMeansInitialization
implements KMedoidsInitialization<O> {
    public RandomlyChosenInitialMeans(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Database database, Relation<? extends NumberVector> relation, int k, NumberVectorDistanceFunction<?> distanceFunction) {
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        ModifiableDBIDs ids = DBIDUtil.randomSample(relation.getDBIDs(), k, this.rnd);
        double[][] means = new double[k][];
        DBIDIter iter = ids.iter();
        for (int i = 0; i < k; ++i) {
            means[i] = relation.get(iter).toArray();
            iter.advance();
        }
        return means;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distanceFunction) {
        return DBIDUtil.randomSample(ids, k, this.rnd);
    }

    public static class Parameterizer<V>
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected RandomlyChosenInitialMeans<V> makeInstance() {
            return new RandomlyChosenInitialMeans(this.rnd);
        }
    }
}

