/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.parallel;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import java.util.Arrays;

public class KMeansProcessor<V extends NumberVector>
implements Processor {
    Relation<V> relation;
    NumberVectorDistanceFunction<? super V> distance;
    WritableIntegerDataStore assignment;
    double[][] means;
    double[][] centroids;
    int[] sizes;
    double[] varsum;
    boolean changed = false;

    public KMeansProcessor(Relation<V> relation, NumberVectorDistanceFunction<? super V> distance, WritableIntegerDataStore assignment, double[] varsum) {
        this.distance = distance;
        this.relation = relation;
        this.assignment = assignment;
        this.varsum = varsum;
    }

    public boolean changed() {
        return this.changed;
    }

    public void nextIteration(double[][] means) {
        this.means = means;
        this.changed = false;
        int k = means.length;
        int dim = means[0].length;
        this.centroids = new double[k][dim];
        this.sizes = new int[k];
        Arrays.fill(this.varsum, 0.0);
    }

    @Override
    public Instance<V> instantiate(Executor exectutor) {
        return new Instance<V>(this.relation, this.distance, this.assignment, this.means);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup(Processor.Instance inst) {
        Instance instance = (Instance)inst;
        KMeansProcessor kMeansProcessor = this;
        synchronized (kMeansProcessor) {
            this.changed |= instance.changed;
            for (int i = 0; i < this.centroids.length; ++i) {
                int sizeb = instance.sizes[i];
                if (sizeb == 0) continue;
                int sizea = this.sizes[i];
                double sum = sizea + sizeb;
                double[] cent = this.centroids[i];
                if (sizea > 0) {
                    VMath.timesEquals(cent, (double)sizea / sum);
                }
                VMath.plusTimesEquals(cent, instance.centroids[i], 1.0 / sum);
                int n = i;
                this.sizes[n] = this.sizes[n] + sizeb;
                VMath.plusEquals(this.varsum, instance.varsum);
            }
        }
    }

    public double[][] getMeans() {
        double[][] newmeans = new double[this.centroids.length][];
        for (int i = 0; i < this.centroids.length; ++i) {
            newmeans[i] = this.sizes[i] == 0 ? this.means[i] : this.centroids[i];
        }
        return newmeans;
    }

    public static class Instance<V extends NumberVector>
    implements Processor.Instance {
        private Relation<V> relation;
        private NumberVectorDistanceFunction<? super V> distance;
        private WritableIntegerDataStore assignment;
        private double[][] means;
        private double[][] centroids;
        private int[] sizes;
        private double[] varsum;
        private boolean changed = false;

        public Instance(Relation<V> relation, NumberVectorDistanceFunction<? super V> distance, WritableIntegerDataStore assignment, double[][] means) {
            this.relation = relation;
            this.distance = distance;
            this.assignment = assignment;
            int k = means.length;
            this.means = new double[k][];
            for (int i = 0; i < k; ++i) {
                this.means[i] = (double[])means[i].clone();
            }
            int dim = this.means[0].length;
            this.centroids = new double[k][dim];
            this.sizes = new int[k];
            this.varsum = new double[k];
        }

        @Override
        public void map(DBIDRef id) {
            NumberVector fv = (NumberVector)this.relation.get(id);
            double mindist = Double.POSITIVE_INFINITY;
            int minIndex = 0;
            for (int i = 0; i < this.means.length; ++i) {
                double dist = this.distance.distance(fv, DoubleVector.wrap(this.means[i]));
                if (!(dist < mindist)) continue;
                minIndex = i;
                mindist = dist;
            }
            int n = minIndex;
            this.varsum[n] = this.varsum[n] + mindist;
            int prev = this.assignment.putInt(id, minIndex);
            this.changed |= prev != minIndex;
            AbstractKMeans.plusEquals(this.centroids[minIndex], fv);
            int n2 = minIndex;
            this.sizes[n2] = this.sizes[n2] + 1;
        }
    }
}

