/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.parallel;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithmUtil;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.parallel.KMeansProcessor;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.parallel.ParallelExecutor;

public class ParallelLloydKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(ParallelLloydKMeans.class);

    public ParallelLloydKMeans(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer) {
        super(distanceFunction, k, maxiter, initializer);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        DBIDs ids = relation.getDBIDs();
        double[][] means = this.initialMeans(database, relation);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage(ids, 3, -1);
        double[] varsum = new double[this.k];
        KMeansProcessor<V> kmm = new KMeansProcessor<V>(relation, this.distanceFunction, assignment, varsum);
        IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("K-Means iteration", LOG) : null;
        for (int iteration = 0; this.maxiter <= 0 || iteration < this.maxiter; ++iteration) {
            LOG.incrementProcessed(prog);
            kmm.nextIteration(means);
            ParallelExecutor.run(ids, kmm);
            if (!kmm.changed()) break;
            means = kmm.getMeans();
        }
        LOG.setCompleted(prog);
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, assignment, this.k);
        Clustering<KMeansModel> result = new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        for (int i = 0; i < clusters.length; ++i) {
            ArrayModifiableDBIDs cids = clusters[i];
            if (cids.size() == 0) continue;
            result.addToplevelCluster(new Cluster<KMeansModel>((DBIDs)cids, new KMeansModel(means[i], varsum[i])));
        }
        return result;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected ParallelLloydKMeans<V> makeInstance() {
            return new ParallelLloydKMeans(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }
}

