/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.KMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Iterator;
import java.util.List;
import net.jafama.FastMath;

public abstract class AbstractKMeansQualityMeasure<O extends NumberVector>
implements KMeansQualityMeasure<O> {
    public static int numPoints(Clustering<? extends MeanModel> clustering) {
        int n = 0;
        for (Cluster<? extends MeanModel> aCluster : clustering.getAllClusters()) {
            n += aCluster.size();
        }
        return n;
    }

    public static <V extends NumberVector> double varianceOfCluster(Cluster<? extends MeanModel> cluster, NumberVectorDistanceFunction<? super V> distanceFunction, Relation<V> relation) {
        MeanModel model = cluster.getModel();
        if (model instanceof KMeansModel) {
            return ((KMeansModel)model).getVarianceContribution();
        }
        DBIDs ids = cluster.getIDs();
        DoubleVector mean = DoubleVector.wrap(model.getMean());
        boolean squared = distanceFunction.isSquared();
        double variance = 0.0;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double dist = distanceFunction.distance((NumberVector)relation.get(iter), mean);
            variance += squared ? dist : dist * dist;
            iter.advance();
        }
        return variance;
    }

    @Reference(authors="D. Pelleg, A. Moore", title="X-means: Extending K-means with Efficient Estimation on the Number of Clusters", booktitle="Proc. 17th Int. Conf. on Machine Learning (ICML 2000)", url="http://www.pelleg.org/shared/hp/download/xmeans.ps", bibkey="DBLP:conf/icml/PellegM00")
    public static <V extends NumberVector> double logLikelihood(Relation<V> relation, Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> distanceFunction) {
        List<Cluster<? extends MeanModel>> clusters = clustering.getAllClusters();
        int m = clusters.size();
        int n = 0;
        int[] n_i = new int[m];
        double d = 0.0;
        double[] d_i = new double[m];
        Iterator<Cluster<? extends MeanModel>> it = clusters.iterator();
        int i = 0;
        while (it.hasNext()) {
            Cluster<? extends MeanModel> cluster = it.next();
            n_i[i] = cluster.size();
            n += n_i[i];
            d_i[i] = AbstractKMeansQualityMeasure.varianceOfCluster(cluster, distanceFunction, relation);
            d += d_i[i];
            ++i;
        }
        if (n <= m) {
            return Double.NEGATIVE_INFINITY;
        }
        double logv = FastMath.log(d / (double)(n - m));
        int dim = RelationUtil.dimensionality(relation);
        double logLikelihood = 0.0;
        for (int i2 = 0; i2 < m; ++i2) {
            logLikelihood += (double)n_i[i2] * FastMath.log(n_i[i2]) - (double)n_i[i2] * 0.5 * MathUtil.LOGTWOPI - (double)(n_i[i2] * dim) * 0.5 * logv - (d_i[i2] - (double)m) * 0.5;
        }
        return logLikelihood -= (double)n * FastMath.log(n);
    }

    public static int numberOfFreeParameters(Relation<? extends NumberVector> relation, Clustering<? extends MeanModel> clustering) {
        int m = clustering.getAllClusters().size();
        int dim = RelationUtil.dimensionality(relation);
        return m - 1 + m * dim + m;
    }
}

