/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.AbstractKMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Iterator;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="Q. Zhao, M. Xu, P. Fr\u00e4nti", title="Knee Point Detection on Bayesian Information Criterion", booktitle="20th IEEE International Conference on Tools with Artificial Intelligence", url="https://doi.org/10.1109/ICTAI.2008.154", bibkey="DBLP:conf/ictai/ZhaoXF08")
public class BayesianInformationCriterionZhao
extends AbstractKMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> distanceFunction, Relation<V> relation) {
        return BayesianInformationCriterionZhao.logLikelihoodZhao(relation, clustering, distanceFunction) - 0.5 * (double)clustering.getAllClusters().size() * FastMath.log(BayesianInformationCriterionZhao.numPoints(clustering));
    }

    public static <V extends NumberVector> double logLikelihoodZhao(Relation<V> relation, Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> distanceFunction) {
        List<Cluster<? extends MeanModel>> clusters = clustering.getAllClusters();
        int m = clusters.size();
        int n = 0;
        int[] n_i = new int[m];
        double[] d_i = new double[m];
        Iterator<Cluster<? extends MeanModel>> it = clusters.iterator();
        int i = 0;
        while (it.hasNext()) {
            Cluster<? extends MeanModel> cluster = it.next();
            n_i[i] = cluster.size();
            n += n_i[i];
            d_i[i] = BayesianInformationCriterionZhao.varianceOfCluster(cluster, distanceFunction, relation) / (double)n_i[i];
            ++i;
        }
        int dim = RelationUtil.dimensionality(relation);
        double logLikelihood = 0.0;
        for (int i2 = 0; i2 < m; ++i2) {
            logLikelihood += (double)n_i[i2] * FastMath.log((double)n_i[i2] / (double)n) - (double)(n_i[i2] * dim) * 0.5 * MathUtil.LOGTWOPI - (double)n_i[i2] * 0.5 * FastMath.log(d_i[i2]) - (double)(n_i[i2] - m) * 0.5;
        }
        return logLikelihood;
    }

    @Override
    public boolean isBetter(double currentCost, double bestCost) {
        return !(currentCost <= bestCost);
    }
}

