/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.KMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;

public class WithinClusterMeanDistanceQualityMeasure
implements KMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> distanceFunction, Relation<V> relation) {
        double clusterDistanceSum = 0.0;
        for (Cluster<? extends MeanModel> cluster : clustering.getAllClusters()) {
            DBIDs ids = cluster.getIDs();
            double clusterPairwiseDistanceSum = 0.0;
            DBIDIter iter1 = ids.iter();
            while (iter1.valid()) {
                NumberVector obj1 = (NumberVector)relation.get(iter1);
                DBIDIter iter2 = ids.iter();
                while (iter2.valid()) {
                    clusterPairwiseDistanceSum += distanceFunction.distance(obj1, (NumberVector)relation.get(iter2));
                    iter2.advance();
                }
                iter1.advance();
            }
            clusterDistanceSum += clusterPairwiseDistanceSum / (double)(ids.size() * ids.size());
        }
        return clusterDistanceSum / (double)clustering.getAllClusters().size();
    }

    @Override
    public boolean isBetter(double currentCost, double bestCost) {
        return !(currentCost >= bestCost);
    }
}

