/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.io.Tokenizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

@Description(value="Load clustering results from an external file. Each line is expected to consists of one clustering, one integer per point and an (optional) non-numeric label.")
public class ExternalClustering
extends AbstractAlgorithm<Clustering<? extends Model>>
implements ClusteringAlgorithm<Clustering<? extends Model>> {
    private static final Logging LOG = Logging.getLogger(ExternalClustering.class);
    public static final String COMMENT = "#";
    private File file;

    public ExternalClustering(File file) {
        this.file = file;
    }

    @Override
    public Clustering<? extends Model> run(Database database) {
        Clustering<? extends Model> m = null;
        try (FileInputStream fis = new FileInputStream(this.file);
             InputStream in = FileUtil.tryGzipInput(fis);
             TokenizedReader reader = CSVReaderFormat.DEFAULT_FORMAT.makeReader();){
            Tokenizer tokenizer = reader.getTokenizer();
            reader.reset(in);
            IntArrayList assignment = new IntArrayList(database.getRelation(TypeUtil.DBID, new Object[0]).size());
            ArrayList<String> name = new ArrayList<String>();
            block31: while (reader.nextLineExceptComments()) {
                while (tokenizer.valid()) {
                    try {
                        assignment.add(tokenizer.getIntBase10());
                    }
                    catch (NumberFormatException e) {
                        name.add(tokenizer.getSubstring());
                    }
                    tokenizer.advance();
                }
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest("Read " + assignment.size() + " assignments and " + name.size() + " labels.");
                }
                for (Relation<?> r : database.getRelations()) {
                    if (r.size() != assignment.size()) continue;
                    this.attachToRelation(database, r, assignment, name);
                    assignment.clear();
                    name.clear();
                    continue block31;
                }
                throw new AbortException("No relation found to match with clustering of size " + assignment.size());
            }
        }
        catch (IOException e) {
            throw new AbortException("Could not load outlier scores: " + e.getMessage() + " when loading " + this.file, e);
        }
        return m;
    }

    private void attachToRelation(Database database, Relation<?> r, IntArrayList assignment, ArrayList<String> name) {
        DBIDs ids = r.getDBIDs();
        if (!(ids instanceof ArrayDBIDs)) {
            throw new AbortException("External clusterings can only be used with static DBIDs.");
        }
        Int2IntOpenHashMap sizes = new Int2IntOpenHashMap();
        IntListIterator it = assignment.iterator();
        while (it.hasNext()) {
            sizes.addTo(it.nextInt(), 1);
        }
        Int2ObjectOpenHashMap<ArrayModifiableDBIDs> cids = new Int2ObjectOpenHashMap<ArrayModifiableDBIDs>(sizes.size());
        Object it2 = sizes.int2IntEntrySet().fastIterator();
        while (it2.hasNext()) {
            Int2IntMap.Entry entry = (Int2IntMap.Entry)it2.next();
            cids.put(entry.getIntKey(), DBIDUtil.newArray(entry.getIntValue()));
        }
        it2 = ((ArrayDBIDs)ids).iter();
        for (int i = 0; i < assignment.size(); ++i) {
            ((ArrayModifiableDBIDs)cids.get(assignment.getInt(i))).add(it2.seek(i));
        }
        String nam = FormatUtil.format(name, " ");
        String snam = nam.toLowerCase().replace(' ', '-');
        Clustering<ClusterModel> result = new Clustering<ClusterModel>(nam, snam);
        ObjectIterator it3 = cids.int2ObjectEntrySet().fastIterator();
        while (it3.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)it3.next();
            boolean noise = entry.getIntKey() < 0;
            result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)entry.getValue(), noise, ClusterModel.CLUSTER));
        }
        database.getHierarchy().add(r, result);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.ANY);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILE_ID = new OptionID("externalcluster.file", "The file name containing the (external) cluster vector.");
        private File file;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            FileParameter fileP = new FileParameter(FILE_ID, FileParameter.FileType.INPUT_FILE);
            if (config.grab(fileP)) {
                this.file = (File)fileP.getValue();
            }
        }

        @Override
        protected ExternalClustering makeInstance() {
            return new ExternalClustering(this.file);
        }
    }
}

