/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.onedimensional;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class KNNKernelDensityMinimaClustering<V extends NumberVector>
extends AbstractAlgorithm<Clustering<ClusterModel>>
implements ClusteringAlgorithm<Clustering<ClusterModel>> {
    private static final Logging LOG = Logging.getLogger(KNNKernelDensityMinimaClustering.class);
    protected int dim;
    protected KernelDensityFunction kernel;
    protected Mode mode;
    protected int k;
    protected int minwindow;

    public KNNKernelDensityMinimaClustering(int dim, KernelDensityFunction kernel, Mode mode, int k, int minwindow) {
        this.dim = dim;
        this.kernel = kernel;
        this.mode = mode;
        this.k = k;
        this.minwindow = minwindow;
    }

    public Clustering<ClusterModel> run(Relation<V> relation) {
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(relation.getDBIDs());
        int size = ids.size();
        ids.sort(new VectorUtil.SortDBIDsBySingleDimension(relation, this.dim));
        WritableDoubleDataStore density = DataStoreUtil.makeDoubleStorage(ids, 3, 0.0);
        DBIDArrayMIter iter = ids.iter();
        DBIDArrayMIter iter2 = ids.iter();
        StepProgress sprog = LOG.isVerbose() ? new StepProgress("Clustering steps", 2) : null;
        LOG.beginStep(sprog, 1, "Kernel density estimation.");
        double[] scratch = new double[2 * this.k];
        iter.seek(0);
        for (int i = 0; i < size; ++i) {
            int j;
            double curv = ((NumberVector)relation.get(iter)).doubleValue(this.dim);
            int pre = Math.max(i - this.k, 0);
            int prek = i - pre;
            int pos = Math.min(i + this.k, size - 1);
            int posk = pos - i;
            iter2.seek(pre);
            for (j = 0; j < prek; ++j) {
                scratch[j] = curv - ((NumberVector)relation.get(iter2)).doubleValue(this.dim);
                iter2.advance();
            }
            assert (iter2.getOffset() == i);
            iter2.advance();
            for (j = 0; j < posk; ++j) {
                scratch[prek + j] = ((NumberVector)relation.get(iter2)).doubleValue(this.dim) - curv;
                iter2.advance();
            }
            assert (prek + posk >= this.k);
            double kdist = QuickSelect.quickSelect(scratch, 0, prek + posk, this.k);
            switch (this.mode) {
                case BALLOON: {
                    double dens = 0.0;
                    if (kdist > 0.0) {
                        for (int j2 = 0; j2 < prek + posk; ++j2) {
                            dens += this.kernel.density(scratch[j2] / kdist);
                        }
                    } else {
                        dens = Double.POSITIVE_INFINITY;
                    }
                    assert (iter.getOffset() == i);
                    density.putDouble(iter, dens);
                    break;
                }
                case SAMPLE: {
                    double delta;
                    if (kdist > 0.0) {
                        int j3;
                        iter2.seek(pre);
                        for (j3 = 0; j3 < prek; ++j3) {
                            delta = curv - ((NumberVector)relation.get(iter2)).doubleValue(this.dim);
                            density.putDouble(iter2, density.doubleValue(iter2) + this.kernel.density(delta / kdist));
                            iter2.advance();
                        }
                        assert (iter2.getOffset() == i);
                        iter2.advance();
                        for (j3 = 0; j3 < posk; ++j3) {
                            delta = ((NumberVector)relation.get(iter2)).doubleValue(this.dim) - curv;
                            density.putDouble(iter2, density.doubleValue(iter2) + this.kernel.density(delta / kdist));
                            iter2.advance();
                        }
                    } else {
                        int j4;
                        iter2.seek(pre);
                        for (j4 = 0; j4 < prek; ++j4) {
                            delta = curv - ((NumberVector)relation.get(iter2)).doubleValue(this.dim);
                            if (!(delta > 0.0)) {
                                density.putDouble(iter2, Double.POSITIVE_INFINITY);
                            }
                            iter2.advance();
                        }
                        assert (iter2.getOffset() == i);
                        iter2.advance();
                        for (j4 = 0; j4 < posk; ++j4) {
                            delta = ((NumberVector)relation.get(iter2)).doubleValue(this.dim) - curv;
                            if (!(delta > 0.0)) {
                                density.putDouble(iter2, Double.POSITIVE_INFINITY);
                            }
                            iter2.advance();
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown mode specified.");
                }
            }
            iter.advance();
        }
        LOG.beginStep(sprog, 2, "Local minima detection.");
        Clustering<ClusterModel> clustering = new Clustering<ClusterModel>("onedimensional-kde-clustering", "One-Dimensional clustering using kernel density estimation.");
        double[] scratch2 = new double[2 * this.minwindow + 1];
        int begin = 0;
        int halfw = this.minwindow + 1 >> 1;
        iter.seek(0);
        for (int i = 0; i < size; ++i) {
            int m = i % scratch2.length;
            int t = (i - this.minwindow - 1) % scratch2.length;
            scratch2[m] = density.doubleValue(iter);
            if (i > scratch2.length) {
                double min = Double.POSITIVE_INFINITY;
                for (int j = 0; j < scratch2.length; ++j) {
                    if (j == t || !(scratch2[j] < min)) continue;
                    min = scratch2[j];
                }
                if (scratch2[t] < min) {
                    int end = i - this.minwindow + 1;
                    iter2.seek(end);
                    double curv = ((NumberVector)relation.get(iter2)).doubleValue(this.dim);
                    iter2.seek(end - halfw);
                    double left = ((NumberVector)relation.get(iter2)).doubleValue(this.dim) - curv;
                    iter2.seek(end + halfw);
                    double right = curv - ((NumberVector)relation.get(iter2)).doubleValue(this.dim);
                    if (left < right) {
                        ++end;
                    }
                    iter2.seek(begin);
                    ArrayModifiableDBIDs cids = DBIDUtil.newArray(end - begin);
                    for (int j = 0; j < end - begin; ++j) {
                        cids.add(iter2);
                        iter2.advance();
                    }
                    clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)cids, ClusterModel.CLUSTER));
                    begin = end;
                }
            }
            iter.advance();
        }
        int end = size;
        iter2.seek(begin);
        ArrayModifiableDBIDs cids = DBIDUtil.newArray(end - begin);
        for (int j = 0; j < end - begin; ++j) {
            cids.add(iter2);
            iter2.advance();
        }
        clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)cids, ClusterModel.CLUSTER));
        LOG.ensureCompleted(sprog);
        return clustering;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(VectorFieldTypeInformation.typeRequest(NumberVector.class, this.dim + 1, Integer.MAX_VALUE));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("kernelcluster.dim", "Dimension to use for clustering. For one-dimensional data, use 0.");
        public static final OptionID KERNEL_ID = new OptionID("kernelcluster.kernel", "Kernel function for density estimation.");
        public static final OptionID MODE_ID = new OptionID("kernelcluster.mode", "Kernel density estimation mode (baloon estimator vs. sample point estimator).");
        public static final OptionID K_ID = new OptionID("kernelcluster.knn", "Number of nearest neighbors to use for bandwidth estimation.");
        public static final OptionID WINDOW_ID = new OptionID("kernelcluster.window", "Half width of sliding window to find local minima.");
        protected int dim;
        protected KernelDensityFunction kernel;
        protected Mode mode;
        protected int k;
        protected int minwindow;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter windowP;
            IntParameter kP;
            EnumParameter<Mode> modeP;
            ObjectParameter kernelP;
            super.makeOptions(config);
            IntParameter dimP = (IntParameter)new IntParameter(DIM_ID, 0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(dimP)) {
                this.dim = dimP.intValue();
            }
            if (config.grab(kernelP = new ObjectParameter(KERNEL_ID, (Class<?>)KernelDensityFunction.class, EpanechnikovKernelDensityFunction.class))) {
                this.kernel = (KernelDensityFunction)kernelP.instantiateClass(config);
            }
            if (config.grab(modeP = new EnumParameter<Mode>(MODE_ID, Mode.class, Mode.BALLOON))) {
                this.mode = (Mode)((Object)modeP.getValue());
            }
            if (config.grab(kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.k = kP.intValue();
            }
            if (config.grab(windowP = (IntParameter)new IntParameter(WINDOW_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minwindow = windowP.intValue();
            }
        }

        @Override
        protected KNNKernelDensityMinimaClustering<V> makeInstance() {
            return new KNNKernelDensityMinimaClustering(this.dim, this.kernel, this.mode, this.k, this.minwindow);
        }
    }

    public static enum Mode {
        BALLOON,
        SAMPLE;

    }
}

