/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, J\u00f6rg Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304187", bibkey="DBLP:conf/sigmod/AnkerstBKS99")
@Alias(value={"OPTICS", "de.lmu.ifi.dbs.elki.algorithm.clustering.OPTICS"})
public abstract class AbstractOPTICS<O>
extends AbstractDistanceBasedAlgorithm<O, ClusterOrder>
implements OPTICSTypeAlgorithm {
    protected double epsilon;
    protected int minpts;

    public AbstractOPTICS(DistanceFunction<? super O> distanceFunction, double epsilon, int minpts) {
        super(distanceFunction);
        this.epsilon = epsilon;
        this.minpts = minpts;
    }

    public abstract ClusterOrder run(Database var1, Relation<O> var2);

    @Override
    public int getMinPts() {
        return this.minpts;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public static abstract class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID EPSILON_ID = new OptionID("optics.epsilon", "The maximum radius of the neighborhood to be considered.");
        public static final OptionID MINPTS_ID = new OptionID("optics.minpts", "Threshold for minimum number of points in the epsilon-neighborhood of a point.");
        protected double epsilon = Double.POSITIVE_INFINITY;
        protected int minpts = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter minptsP;
            super.makeOptions(config);
            DoubleParameter epsilonP = (DoubleParameter)new DoubleParameter(EPSILON_ID).setOptional(true);
            if (config.grab(epsilonP)) {
                this.epsilon = (Double)epsilonP.getValue();
            }
            if (config.grab(minptsP = (IntParameter)new IntParameter(MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minpts = minptsP.intValue();
            }
        }
    }
}

