/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;

public class ClusterOrder
extends BasicResult
implements OrderingResult {
    ArrayModifiableDBIDs ids;
    WritableDoubleDataStore reachability;
    WritableDBIDDataStore predecessor;

    public ClusterOrder(DBIDs ids, String name, String shortname) {
        super(name, shortname);
        this.ids = DBIDUtil.newArray(ids.size());
        this.reachability = DataStoreUtil.makeDoubleStorage(ids, 30, Double.POSITIVE_INFINITY);
        this.predecessor = DataStoreUtil.makeDBIDStorage(ids, 2);
        this.addChildResult(new MaterializedDoubleRelation("Reachability distance", "reachdist", this.reachability, ids));
        this.addChildResult(new MaterializedRelation<DBID>("OPTICS predecessor", "predecessor", TypeUtil.DBID, this.predecessor, ids));
    }

    public ClusterOrder(String name, String shortname, ArrayModifiableDBIDs ids, WritableDoubleDataStore reachability, WritableDBIDDataStore predecessor) {
        super(name, shortname);
        this.ids = ids;
        this.reachability = reachability;
        this.predecessor = predecessor;
        this.addChildResult(new MaterializedDoubleRelation("Reachability distance", "reachdist", reachability, ids));
        if (predecessor != null) {
            this.addChildResult(new MaterializedRelation<DBID>("OPTICS predecessor", "predecessor", TypeUtil.DBID, predecessor, ids));
        }
    }

    public void add(DBIDRef id, double reach, DBIDRef pre) {
        this.ids.add(id);
        this.reachability.putDouble(id, reach);
        if (pre == null || pre instanceof DBIDVar && !((DBIDVar)pre).isSet()) {
            return;
        }
        this.predecessor.putDBID(id, pre);
    }

    @Override
    public ArrayDBIDs getDBIDs() {
        return this.ids;
    }

    public DBIDArrayIter iter() {
        return this.ids.iter();
    }

    @Override
    public ArrayModifiableDBIDs order(DBIDs ids) {
        ArrayModifiableDBIDs res = DBIDUtil.newArray(ids.size());
        DBIDArrayMIter it = this.ids.iter();
        while (it.valid()) {
            if (ids.contains(it)) {
                res.add(it);
            }
            it.advance();
        }
        return res;
    }

    public int size() {
        return this.ids.size();
    }

    public double getReachability(DBIDRef id) {
        return this.reachability.doubleValue(id);
    }

    public void getPredecessor(DBIDRef id, DBIDVar out) {
        if (this.predecessor == null) {
            out.unset();
            return;
        }
        this.predecessor.assignVar(id, out);
    }
}

