/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.KNNJoin;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.tree.IndexTree;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluTreeFactory;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluTreeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;

@Title(value="DeliClu: Density-Based Hierarchical Clustering")
@Description(value="Hierachical algorithm to find density-connected sets in a database based on the parameter 'minpts'.")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Peer Kr\u00f6ger", title="DeLiClu: Boosting Robustness, Completeness, Usability, and Efficiency of Hierarchical Clustering by a Closest Pair Ranking", booktitle="Proc. 10th Pacific-Asia Conf. on Knowledge Discovery and Data Mining (PAKDD 2006)", url="https://doi.org/10.1007/11731139_16", bibkey="DBLP:conf/pakdd/AchtertBK06")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.DeLiClu"})
public class DeLiClu<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, ClusterOrder>
implements OPTICSTypeAlgorithm {
    private static final Logging LOG = Logging.getLogger(DeLiClu.class);
    private UpdatableHeap<SpatialObjectPair> heap;
    private int minpts;
    protected DeLiCluTreeFactory<? super V> indexer;

    public DeLiClu(DeLiCluTreeFactory<? super V> indexer, DistanceFunction<? super V> distanceFunction, int minpts) {
        super(distanceFunction);
        this.indexer = indexer;
        this.minpts = minpts;
    }

    public ClusterOrder run(Database database, Relation<V> relation) {
        if (!(this.getDistanceFunction() instanceof SpatialPrimitiveDistanceFunction)) {
            throw new IllegalArgumentException("Distance Function must be an instance of " + SpatialPrimitiveDistanceFunction.class.getName());
        }
        SpatialPrimitiveDistanceFunction distFunction = (SpatialPrimitiveDistanceFunction)this.getDistanceFunction();
        if (LOG.isVerbose()) {
            LOG.verbose("Building DeLiClu index");
        }
        Index index = this.indexer.instantiate((Relation)relation);
        ((DeLiCluTreeIndex)index).initialize();
        if (LOG.isVerbose()) {
            LOG.verbose("Performing kNN join");
        }
        WritableDataStore<KNNList> knns = new KNNJoin(distFunction, this.minpts).run(index, relation.getDBIDs());
        DBIDs ids = relation.getDBIDs();
        int size = ids.size();
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("DeLiClu", size, LOG) : null;
        ClusterOrder clusterOrder = new ClusterOrder(ids, "DeLiClu Clustering", "deliclu-clustering");
        this.heap = new UpdatableHeap();
        DBID startID = DBIDUtil.deref(ids.iter());
        clusterOrder.add(startID, Double.POSITIVE_INFINITY, null);
        int numHandled = 1;
        ((DeLiCluTreeIndex)index).setHandled(startID, (NumberVector)relation.get(startID));
        SpatialDirectoryEntry rootEntry = (SpatialDirectoryEntry)((IndexTree)index).getRootEntry();
        SpatialObjectPair spatialObjectPair = new SpatialObjectPair(0.0, rootEntry, rootEntry, true);
        this.heap.add(spatialObjectPair);
        while (numHandled < size) {
            if (this.heap.isEmpty()) {
                throw new AbortException("DeLiClu heap was empty when it shouldn't have been.");
            }
            SpatialObjectPair dataPair = this.heap.poll();
            if (dataPair.isExpandable) {
                this.expandNodes((DeLiCluTree)index, distFunction, dataPair, knns);
                continue;
            }
            LeafEntry e1 = (LeafEntry)((Object)dataPair.entry1);
            LeafEntry e2 = (LeafEntry)((Object)dataPair.entry2);
            DBID e1id = e1.getDBID();
            IndexTreePath<DeLiCluEntry> path = ((DeLiCluTreeIndex)index).setHandled(e1id, (NumberVector)relation.get(e1id));
            if (path == null) {
                throw new RuntimeException("snh: parent(" + e1id + ") = null!!!");
            }
            clusterOrder.add(e1id, dataPair.distance, e2.getDBID());
            ++numHandled;
            this.reinsertExpanded(distFunction, (DeLiCluTree)index, path, knns);
            if (progress == null) continue;
            progress.setProcessed(numHandled, LOG);
        }
        LOG.ensureCompleted(progress);
        return clusterOrder;
    }

    private void expandNodes(DeLiCluTree index, SpatialPrimitiveDistanceFunction<V> distFunction, SpatialObjectPair nodePair, DataStore<KNNList> knns) {
        DeLiCluNode node1 = (DeLiCluNode)index.getNode(((SpatialDirectoryEntry)nodePair.entry1).getPageID());
        DeLiCluNode node2 = (DeLiCluNode)index.getNode(((SpatialDirectoryEntry)nodePair.entry2).getPageID());
        if (node1.isLeaf()) {
            this.expandLeafNodes(distFunction, node1, node2, knns);
        } else {
            this.expandDirNodes(distFunction, node1, node2);
        }
        index.setExpanded(nodePair.entry2, nodePair.entry1);
    }

    private void expandDirNodes(SpatialPrimitiveDistanceFunction<V> distFunction, DeLiCluNode node1, DeLiCluNode node2) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("ExpandDirNodes: " + node1.getPageID() + " + " + node2.getPageID());
        }
        int numEntries_1 = node1.getNumEntries();
        int numEntries_2 = node2.getNumEntries();
        for (int i = 0; i < numEntries_1; ++i) {
            DeLiCluEntry entry1 = (DeLiCluEntry)node1.getEntry(i);
            if (!entry1.hasUnhandled()) continue;
            for (int j = 0; j < numEntries_2; ++j) {
                DeLiCluEntry entry2 = (DeLiCluEntry)node2.getEntry(j);
                if (!entry2.hasHandled()) continue;
                double distance = distFunction.minDist(entry1, entry2);
                this.heap.add(new SpatialObjectPair(distance, entry1, entry2, true));
            }
        }
    }

    private void expandLeafNodes(SpatialPrimitiveDistanceFunction<V> distFunction, DeLiCluNode node1, DeLiCluNode node2, DataStore<KNNList> knns) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("ExpandLeafNodes: " + node1.getPageID() + " + " + node2.getPageID());
        }
        int numEntries_1 = node1.getNumEntries();
        int numEntries_2 = node2.getNumEntries();
        for (int i = 0; i < numEntries_1; ++i) {
            DeLiCluEntry entry1 = (DeLiCluEntry)node1.getEntry(i);
            if (!entry1.hasUnhandled()) continue;
            for (int j = 0; j < numEntries_2; ++j) {
                DeLiCluEntry entry2 = (DeLiCluEntry)node2.getEntry(j);
                if (!entry2.hasHandled()) continue;
                double distance = distFunction.minDist(entry1, entry2);
                double reach = MathUtil.max(distance, knns.get(((LeafEntry)((Object)entry2)).getDBID()).getKNNDistance());
                this.heap.add(new SpatialObjectPair(reach, entry1, entry2, false));
            }
        }
    }

    private void reinsertExpanded(SpatialPrimitiveDistanceFunction<V> distFunction, DeLiCluTree index, IndexTreePath<DeLiCluEntry> path, DataStore<KNNList> knns) {
        int l = 0;
        for (IndexTreePath<DeLiCluEntry> it = path; it != null; it = it.getParentPath()) {
            ++l;
        }
        ArrayList<IndexTreePath<DeLiCluEntry>> p = new ArrayList<IndexTreePath<DeLiCluEntry>>(l - 1);
        IndexTreePath<DeLiCluEntry> it = path;
        while (it.getParentPath() != null) {
            p.add(it);
            it = it.getParentPath();
        }
        assert (p.size() == l - 1);
        DeLiCluEntry rootEntry = it.getEntry();
        this.reinsertExpanded(distFunction, index, p, l - 2, rootEntry, knns);
    }

    private void reinsertExpanded(SpatialPrimitiveDistanceFunction<V> distFunction, DeLiCluTree index, List<IndexTreePath<DeLiCluEntry>> path, int pos, DeLiCluEntry parentEntry, DataStore<KNNList> knns) {
        DeLiCluNode parentNode = (DeLiCluNode)index.getNode(parentEntry);
        SpatialEntry entry2 = path.get(pos).getEntry();
        if (entry2 instanceof LeafEntry) {
            assert (pos == 0);
            for (int i = 0; i < parentNode.getNumEntries(); ++i) {
                DeLiCluEntry entry1 = (DeLiCluEntry)parentNode.getEntry(i);
                if (entry1.hasHandled()) continue;
                double distance = distFunction.minDist(entry1, entry2);
                double reach = MathUtil.max(distance, knns.get(((LeafEntry)((Object)entry2)).getDBID()).getKNNDistance());
                this.heap.add(new SpatialObjectPair(reach, entry1, entry2, false));
            }
            return;
        }
        IntSet expanded = index.getExpanded(entry2);
        for (int i = 0; i < parentNode.getNumEntries(); ++i) {
            DeLiCluDirectoryEntry entry1 = (DeLiCluDirectoryEntry)parentNode.getEntry(i);
            if (!expanded.contains(entry1.getPageID())) {
                double distance = distFunction.minDist(entry1, entry2);
                this.heap.add(new SpatialObjectPair(distance, entry1, entry2, true));
                continue;
            }
            this.reinsertExpanded(distFunction, index, path, pos - 1, entry1, knns);
        }
    }

    @Override
    public int getMinPts() {
        return this.minpts;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID MINPTS_ID = new OptionID("deliclu.minpts", "Threshold for minimum number of points within a cluster.");
        protected int minpts = 0;
        protected DeLiCluTreeFactory<? super V> indexer;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter minptsP = (IntParameter)new IntParameter(MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(minptsP)) {
                this.minpts = (Integer)minptsP.getValue();
            }
            Class clz = ClassGenericsUtil.uglyCastIntoSubclass(DeLiCluTreeFactory.class);
            this.indexer = (DeLiCluTreeFactory)config.tryInstantiate(clz);
        }

        @Override
        protected DeLiClu<V> makeInstance() {
            return new DeLiClu<V>(this.indexer, this.distanceFunction, this.minpts);
        }
    }

    public static class SpatialObjectPair
    implements Comparable<SpatialObjectPair> {
        SpatialEntry entry1;
        SpatialEntry entry2;
        boolean isExpandable;
        double distance;

        public SpatialObjectPair(double distance, SpatialEntry entry1, SpatialEntry entry2, boolean isExpandable) {
            this.distance = distance;
            this.entry1 = entry1;
            this.entry2 = entry2;
            this.isExpandable = isExpandable;
        }

        @Override
        public int compareTo(SpatialObjectPair other) {
            return Double.compare(this.distance, other.distance);
        }

        public String toString() {
            return !this.isExpandable ? this.entry1 + " - " + this.entry2 : "n_" + this.entry1 + " - n_" + this.entry2;
        }

        public boolean equals(Object obj) {
            if (!SpatialObjectPair.class.isInstance(obj)) {
                return false;
            }
            SpatialObjectPair other = (SpatialObjectPair)obj;
            return this.entry1.equals(other.entry1) && (!this.isExpandable || this.entry2.equals(other.entry2));
        }

        public int hashCode() {
            return !this.isExpandable ? this.entry1.hashCode() : (int)(2654435761L * (long)this.entry1.hashCode() + (long)this.entry2.hashCode());
        }
    }
}

