/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.AbstractOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSHeapEntry;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.fastoptics.RandomProjectedNeighborsAndDensities;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. Schneider, M. Vlachos", title="Fast parameterless density-based clustering via random projections", booktitle="Proc. 22nd ACM Int. Conf. on Information & Knowledge Management (CIKM 2013)", url="https://doi.org/10.1145/2505515.2505590", bibkey="DBLP:conf/cikm/SchneiderV13")
public class FastOPTICS<V extends NumberVector>
extends AbstractAlgorithm<ClusterOrder>
implements OPTICSTypeAlgorithm {
    private static final Logging LOG = Logging.getLogger(FastOPTICS.class);
    public static final double UNDEFINED_DISTANCE = (double)-0.1f;
    ClusterOrder order;
    WritableDoubleDataStore reachDist;
    ModifiableDBIDs processed;
    DataStore<? extends DBIDs> neighs;
    DoubleDataStore inverseDensities;
    int minPts;
    RandomProjectedNeighborsAndDensities<V> index;

    public FastOPTICS(int minpts, RandomProjectedNeighborsAndDensities<V> index) {
        this.minPts = minpts;
        this.index = index;
    }

    public ClusterOrder run(Database db, Relation<V> rel) {
        DBIDs ids = rel.getDBIDs();
        DistanceQuery<NumberVector> dq = db.getDistanceQuery(rel, EuclideanDistanceFunction.STATIC, new Object[0]);
        this.reachDist = DataStoreUtil.makeDoubleStorage(ids, 3, -0.1f);
        this.index.computeSetsBounds(rel, this.minPts, ids);
        this.inverseDensities = this.index.computeAverageDistInSet();
        this.neighs = this.index.getNeighs();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("FastOPTICS clustering", ids.size(), LOG) : null;
        this.processed = DBIDUtil.newHashSet(ids.size());
        this.order = new ClusterOrder(ids, "FastOPTICS Cluster Order", "fast-optics");
        DBIDIter it = ids.iter();
        while (it.valid()) {
            if (!this.processed.contains(it)) {
                this.expandClusterOrder(DBIDUtil.deref(it), this.order, dq, prog);
            }
            it.advance();
        }
        this.index.logStatistics();
        LOG.ensureCompleted(prog);
        return this.order;
    }

    protected void expandClusterOrder(DBID ipt, ClusterOrder order, DistanceQuery<V> dq, FiniteProgress prog) {
        UpdatableHeap<OPTICSHeapEntry> heap = new UpdatableHeap<OPTICSHeapEntry>();
        heap.add(new OPTICSHeapEntry(ipt, null, Double.POSITIVE_INFINITY));
        while (!heap.isEmpty()) {
            OPTICSHeapEntry current = (OPTICSHeapEntry)heap.poll();
            DBID currPt = current.objectID;
            order.add(currPt, current.reachability, current.predecessorID);
            this.processed.add(currPt);
            double coredist = this.inverseDensities.doubleValue(currPt);
            DBIDIter it = this.neighs.get(currPt).iter();
            while (it.valid()) {
                if (!this.processed.contains(it)) {
                    double nrdist = dq.distance((DBIDRef)currPt, (DBIDRef)it);
                    if (coredist > nrdist) {
                        nrdist = coredist;
                    }
                    if (this.reachDist.doubleValue(it) == (double)-0.1f) {
                        this.reachDist.put((DBIDRef)it, nrdist);
                    } else if (nrdist < this.reachDist.doubleValue(it)) {
                        this.reachDist.put((DBIDRef)it, nrdist);
                    }
                    heap.add(new OPTICSHeapEntry(DBIDUtil.deref(it), currPt, nrdist));
                }
                it.advance();
            }
            LOG.incrementProcessed(prog);
        }
    }

    @Override
    public int getMinPts() {
        return this.minPts;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(EuclideanDistanceFunction.STATIC.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        int minpts;
        RandomProjectedNeighborsAndDensities<V> index;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter minptsP = (IntParameter)new IntParameter(AbstractOPTICS.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(minptsP)) {
                this.minpts = minptsP.intValue();
            }
            Class clz = ClassGenericsUtil.uglyCastIntoSubclass(RandomProjectedNeighborsAndDensities.class);
            this.index = (RandomProjectedNeighborsAndDensities)config.tryInstantiate(clz);
        }

        @Override
        protected FastOPTICS<V> makeInstance() {
            return new FastOPTICS<V>(this.minpts, this.index);
        }
    }
}

