/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.QuickSelectDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import java.util.Comparator;

public abstract class GeneralizedOPTICS<O, R extends ClusterOrder>
extends AbstractAlgorithm<R>
implements OPTICSTypeAlgorithm {
    public abstract ClusterOrder run(Database var1, Relation<O> var2);

    public static abstract class Instance<O, R>
    implements Comparator<DBIDRef> {
        protected ModifiableDBIDs processedIDs;
        protected ArrayModifiableDBIDs candidates;
        protected WritableDBIDDataStore predecessor;
        protected WritableDoubleDataStore reachability;
        DBIDs ids;
        FiniteProgress progress;

        public Instance(Database db, Relation<O> relation) {
            this.ids = relation.getDBIDs();
            this.processedIDs = DBIDUtil.newHashSet(this.ids.size());
            this.candidates = DBIDUtil.newArray();
            this.predecessor = DataStoreUtil.makeDBIDStorage(this.ids, 2);
            this.reachability = DataStoreUtil.makeDoubleStorage(this.ids, 30, Double.POSITIVE_INFINITY);
            this.progress = this.getLogger().isVerbose() ? new FiniteProgress("OPTICS", this.ids.size(), this.getLogger()) : null;
        }

        @Override
        public int compare(DBIDRef o1, DBIDRef o2) {
            return Double.compare(this.reachability.doubleValue(o2), this.reachability.doubleValue(o1));
        }

        public R run() {
            Logging LOG = this.getLogger();
            DBIDVar cur = DBIDUtil.newVar();
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                if (!this.processedIDs.contains(iditer)) {
                    this.initialDBID(iditer);
                    this.processedIDs.add(iditer);
                    this.expandDBID(iditer);
                    LOG.incrementProcessed(this.progress);
                    while (!this.candidates.isEmpty()) {
                        int last = this.candidates.size() - 1;
                        QuickSelectDBIDs.quickSelect(this.candidates, this, last);
                        this.candidates.assignVar(last, cur);
                        this.candidates.remove(last);
                        this.processedIDs.add(cur);
                        this.expandDBID(cur);
                        LOG.incrementProcessed(this.progress);
                    }
                }
                iditer.advance();
            }
            LOG.ensureCompleted(this.progress);
            return this.buildResult();
        }

        protected abstract void initialDBID(DBIDRef var1);

        protected abstract void expandDBID(DBIDRef var1);

        protected abstract R buildResult();

        protected abstract Logging getLogger();
    }
}

