/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.AbstractOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSHeapEntry;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="OPTICS: Density-Based Hierarchical Clustering (implementation using a heap)")
@Reference(authors="Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, J\u00f6rg Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304187", bibkey="DBLP:conf/sigmod/AnkerstBKS99")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.OPTICS"})
public class OPTICSHeap<O>
extends AbstractOPTICS<O> {
    private static final Logging LOG = Logging.getLogger(OPTICSHeap.class);

    public OPTICSHeap(DistanceFunction<? super O> distanceFunction, double epsilon, int minpts) {
        super(distanceFunction, epsilon, minpts);
    }

    @Override
    public ClusterOrder run(Database db, Relation<O> relation) {
        return new Instance(db, relation).run();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractOPTICS.Parameterizer<O> {
        @Override
        protected OPTICSHeap<O> makeInstance() {
            return new OPTICSHeap(this.distanceFunction, this.epsilon, this.minpts);
        }
    }

    private class Instance {
        private ModifiableDBIDs processedIDs;
        UpdatableHeap<OPTICSHeapEntry> heap;
        ClusterOrder clusterOrder;
        private DBIDs ids;
        FiniteProgress progress;
        RangeQuery<O> rangeQuery;

        public Instance(Database db, Relation<O> relation) {
            this.ids = relation.getDBIDs();
            this.processedIDs = DBIDUtil.newHashSet(this.ids.size());
            this.clusterOrder = new ClusterOrder(this.ids, "OPTICS Clusterorder", "optics-clusterorder");
            this.progress = LOG.isVerbose() ? new FiniteProgress("OPTICS", this.ids.size(), LOG) : null;
            DistanceQuery dq = db.getDistanceQuery(relation, OPTICSHeap.this.getDistanceFunction(), new Object[0]);
            this.rangeQuery = db.getRangeQuery(dq, OPTICSHeap.this.epsilon);
            this.heap = new UpdatableHeap();
        }

        public ClusterOrder run() {
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                if (!this.processedIDs.contains(iditer)) {
                    assert (this.heap.isEmpty());
                    this.expandClusterOrder(iditer);
                }
                iditer.advance();
            }
            LOG.ensureCompleted(this.progress);
            return this.clusterOrder;
        }

        protected void expandClusterOrder(DBIDRef objectID) {
            ModifiableDoubleDBIDList neighbors = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter neighbor = neighbors.iter();
            this.heap.add(new OPTICSHeapEntry(DBIDUtil.deref(objectID), null, Double.POSITIVE_INFINITY));
            while (!this.heap.isEmpty()) {
                OPTICSHeapEntry current = this.heap.poll();
                this.clusterOrder.add(current.objectID, current.reachability, current.predecessorID);
                this.processedIDs.add(current.objectID);
                neighbors.clear();
                this.rangeQuery.getRangeForDBID(current.objectID, OPTICSHeap.this.epsilon, neighbors);
                if (neighbors.size() >= OPTICSHeap.this.minpts) {
                    neighbors.sort();
                    double coreDistance = neighbor.seek(OPTICSHeap.this.minpts - 1).doubleValue();
                    neighbor.seek(0);
                    while (neighbor.valid()) {
                        if (!this.processedIDs.contains(neighbor)) {
                            double reachability = MathUtil.max(neighbor.doubleValue(), coreDistance);
                            this.heap.add(new OPTICSHeapEntry(DBIDUtil.deref(neighbor), current.objectID, reachability));
                        }
                        neighbor.advance();
                    }
                }
                LOG.incrementProcessed(this.progress);
            }
        }
    }
}

