/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.AbstractOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="OPTICS: Density-Based Hierarchical Clustering (implementation using a list)")
@Reference(authors="Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, J\u00f6rg Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304187", bibkey="DBLP:conf/sigmod/AnkerstBKS99")
public class OPTICSList<O>
extends AbstractOPTICS<O> {
    private static final Logging LOG = Logging.getLogger(OPTICSList.class);

    public OPTICSList(DistanceFunction<? super O> distanceFunction, double epsilon, int minpts) {
        super(distanceFunction, epsilon, minpts);
    }

    @Override
    public ClusterOrder run(Database db, Relation<O> relation) {
        return new Instance(db, relation).run();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractOPTICS.Parameterizer<O> {
        @Override
        protected OPTICSList<O> makeInstance() {
            return new OPTICSList(this.distanceFunction, this.epsilon, this.minpts);
        }
    }

    private class Instance {
        ModifiableDBIDs processedIDs;
        ArrayModifiableDBIDs candidates;
        WritableDBIDDataStore predecessor;
        WritableDoubleDataStore reachability;
        ClusterOrder clusterOrder;
        DBIDs ids;
        FiniteProgress progress;
        RangeQuery<O> rangeQuery;

        public Instance(Database db, Relation<O> relation) {
            this.ids = relation.getDBIDs();
            this.processedIDs = DBIDUtil.newHashSet(this.ids.size());
            this.candidates = DBIDUtil.newArray();
            this.predecessor = DataStoreUtil.makeDBIDStorage(this.ids, 2);
            this.reachability = DataStoreUtil.makeDoubleStorage(this.ids, 30, Double.POSITIVE_INFINITY);
            this.clusterOrder = new ClusterOrder(this.ids, "OPTICS Clusterorder", "optics-clusterorder");
            this.progress = LOG.isVerbose() ? new FiniteProgress("OPTICS", this.ids.size(), LOG) : null;
            DistanceQuery dq = db.getDistanceQuery(relation, OPTICSList.this.getDistanceFunction(), new Object[0]);
            this.rangeQuery = db.getRangeQuery(dq, OPTICSList.this.epsilon);
        }

        public ClusterOrder run() {
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                if (!this.processedIDs.contains(iditer)) {
                    this.expandClusterOrder(iditer);
                }
                iditer.advance();
            }
            LOG.ensureCompleted(this.progress);
            return this.clusterOrder;
        }

        protected void expandClusterOrder(DBIDRef objectID) {
            ModifiableDoubleDBIDList neighbors = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter neighbor = neighbors.iter();
            this.candidates.add(objectID);
            this.predecessor.putDBID(objectID, objectID);
            this.reachability.put(objectID, Double.POSITIVE_INFINITY);
            DBIDArrayMIter it = this.candidates.iter();
            DBIDVar cur = DBIDUtil.newVar();
            DBIDVar prev = DBIDUtil.newVar();
            while (!this.candidates.isEmpty()) {
                this.findBest(this.candidates, it, cur);
                this.processedIDs.add(cur);
                this.clusterOrder.add(cur, this.reachability.doubleValue(cur), this.predecessor.assignVar(cur, prev));
                LOG.incrementProcessed(this.progress);
                neighbors.clear();
                this.rangeQuery.getRangeForDBID(cur, OPTICSList.this.epsilon, neighbors);
                if (neighbors.size() < OPTICSList.this.minpts) continue;
                neighbors.sort();
                double coreDistance = neighbor.seek(OPTICSList.this.minpts - 1).doubleValue();
                neighbor.seek(0);
                while (neighbor.valid()) {
                    double prevreach;
                    double reach;
                    if (!this.processedIDs.contains(neighbor) && (reach = MathUtil.max(neighbor.doubleValue(), coreDistance)) < (prevreach = this.reachability.doubleValue(neighbor))) {
                        this.reachability.put((DBIDRef)neighbor, reach);
                        this.predecessor.putDBID(neighbor, cur);
                        if (prevreach == Double.POSITIVE_INFINITY) {
                            this.candidates.add(neighbor);
                        }
                    }
                    neighbor.advance();
                }
            }
        }

        public void findBest(ArrayModifiableDBIDs candidates, DBIDArrayMIter it, DBIDVar out) {
            assert (candidates.size() > 0);
            int bestidx = 0;
            double min = this.reachability.doubleValue(out.set(it.seek(0)));
            it.advance();
            while (it.valid()) {
                double reach = this.reachability.doubleValue(it);
                if (reach < min || reach == min && DBIDUtil.compare(it, out) < 0) {
                    min = reach;
                    out.set(it);
                    bestidx = it.getOffset();
                }
                it.advance();
            }
            it.seek(bestidx).remove();
        }
    }
}

