/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSHeap;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.OPTICSModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.IterableResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@Title(value="OPTICS Xi Cluster Extraction")
@References(value={@Reference(authors="Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, J\u00f6rg Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304187", bibkey="DBLP:conf/sigmod/AnkerstBKS99"), @Reference(authors="Erich Schubert, Michael Gertz", title="Improving the Cluster Structure Extracted from OPTICS Plots", booktitle="Proc. Lernen, Wissen, Daten, Analysen (LWDA 2018)", url="http://ceur-ws.org/Vol-2191/paper37.pdf", bibkey="DBLP:conf/lwa/SchubertG18")})
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.OPTICSXi"})
@Priority(value=200)
public class OPTICSXi
extends AbstractAlgorithm<Clustering<OPTICSModel>>
implements ClusteringAlgorithm<Clustering<OPTICSModel>> {
    private static final Logging LOG = Logging.getLogger(OPTICSXi.class);
    OPTICSTypeAlgorithm optics;
    double xi;
    boolean nocorrect;
    boolean keepsteep;

    public OPTICSXi(OPTICSTypeAlgorithm optics, double xi, boolean nocorrect, boolean keepsteep) {
        this.optics = optics;
        this.xi = xi;
        this.nocorrect = nocorrect;
        this.keepsteep = keepsteep;
    }

    public OPTICSXi(OPTICSTypeAlgorithm optics, double xi) {
        this(optics, xi, false, false);
    }

    public Clustering<OPTICSModel> run(Database database, Relation<?> relation) {
        ClusterOrder opticsresult = this.optics.run(database);
        if (LOG.isVerbose()) {
            LOG.verbose("Extracting clusters with Xi: " + this.xi);
        }
        return this.extractClusters(opticsresult, relation, 1.0 - this.xi, this.optics.getMinPts());
    }

    /*
     * Could not resolve type clashes
     */
    private Clustering<OPTICSModel> extractClusters(ClusterOrder clusterOrderResult, Relation<?> relation, double ixi, int minpts) {
        ArrayModifiableDBIDs clusterOrder = clusterOrderResult.ids;
        WritableDoubleDataStore reach = clusterOrderResult.reachability;
        DBIDArrayIter tmp = clusterOrder.iter();
        DBIDVar tmp2 = DBIDUtil.newVar();
        double mib = 0.0;
        ArrayList<SteepArea> salist = this.keepsteep ? new ArrayList<SteepArea>() : null;
        ArrayList<SteepDownArea> sdaset = new ArrayList<SteepDownArea>();
        Clustering<OPTICSModel> clustering = new Clustering<OPTICSModel>("OPTICS Xi-Clusters", "optics");
        HashSet<Cluster<OPTICSModel>> curclusters = new HashSet<Cluster<OPTICSModel>>();
        HashSetModifiableDBIDs unclaimedids = DBIDUtil.newHashSet(relation.getDBIDs());
        FiniteProgress scanprog = LOG.isVerbose() ? new FiniteProgress("OPTICS Xi cluster extraction", clusterOrder.size(), LOG) : null;
        SteepScanPosition scan = new SteepScanPosition(clusterOrderResult);
        while (scan.hasNext()) {
            if (scanprog != null) {
                scanprog.setProcessed(scan.index, LOG);
            }
            mib = MathUtil.max(mib, scan.getReachability());
            if (!scan.next.valid()) break;
            if (scan.steepDown(ixi)) {
                OPTICSXi.updateFilterSDASet(mib, sdaset, ixi);
                double startval = scan.getReachability();
                mib = 0.0;
                int startsteep = scan.index;
                int endsteep = scan.index;
                scan.next();
                while (scan.hasNext()) {
                    if (scan.steepDown(ixi)) {
                        endsteep = scan.index;
                    } else if (!scan.steepDown(1.0) || scan.index - endsteep > minpts) break;
                    scan.next();
                }
                SteepDownArea sda = new SteepDownArea(startsteep, endsteep, startval, 0.0);
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest("New steep down area: " + sda.toString());
                }
                sdaset.add(sda);
                if (salist == null) continue;
                salist.add(sda);
                continue;
            }
            if (scan.steepUp(ixi)) {
                OPTICSXi.updateFilterSDASet(mib, sdaset, ixi);
                int startsteep = scan.index;
                int endsteep = scan.index;
                mib = scan.getReachability();
                double esuccr = scan.getNextReachability();
                while (!Double.isInfinite(esuccr) && scan.hasNext()) {
                    scan.next();
                    if (scan.steepUp(ixi)) {
                        endsteep = scan.index;
                        mib = scan.getReachability();
                        esuccr = scan.getNextReachability();
                        continue;
                    }
                    if (scan.steepUp(1.0) && scan.index - endsteep <= minpts) continue;
                }
                if (Double.isInfinite(esuccr)) {
                    scan.next();
                }
                SteepUpArea sua = new SteepUpArea(startsteep, endsteep, esuccr);
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest("New steep up area: " + sua.toString());
                }
                if (salist != null) {
                    salist.add(sua);
                }
                ListIterator sdaiter = sdaset.listIterator(sdaset.size());
                while (sdaiter.hasPrevious()) {
                    int cend;
                    int cstart;
                    SteepDownArea sda = (SteepDownArea)sdaiter.previous();
                    if (LOG.isDebuggingFinest()) {
                        LOG.debugFinest("Comparing: eU=" + mib + " SDA: " + sda.toString());
                    }
                    if (mib * ixi < sda.getMib()) {
                        if (!LOG.isDebuggingFinest()) continue;
                        LOG.debugFinest("mib * ixi = " + mib * ixi + " >= sda.getMib() = " + sda.getMib());
                        continue;
                    }
                    if (sda.getMaximum() * ixi >= sua.getMaximum()) {
                        for (cstart = sda.getStartIndex(); cstart < cend && reach.doubleValue(tmp.seek(cstart + 1)) > sua.getMaximum(); ++cstart) {
                        }
                    } else if (sua.getMaximum() * ixi >= sda.getMaximum()) {
                        for (cend = MathUtil.min(sua.getEndIndex(), clusterOrder.size() - 1); cend > cstart && reach.doubleValue(tmp.seek(cend - 1)) > sda.getMaximum(); --cend) {
                        }
                    }
                    if (!this.nocorrect) {
                        double startval = clusterOrderResult.reachability.doubleValue(tmp.seek(cstart));
                        block6: while (cend > cstart) {
                            tmp.seek(cend);
                            if (clusterOrderResult.reachability.doubleValue(tmp) < startval) break;
                            clusterOrderResult.predecessor.assignVar(tmp, tmp2);
                            for (int i = cstart; i < cend; ++i) {
                                if (DBIDUtil.equal(tmp2, tmp.seek(i))) break block6;
                            }
                            if (LOG.isDebuggingFinest()) {
                                LOG.debugFinest("Pruned one point by predecessor rule.");
                            }
                            --cend;
                        }
                    }
                    if (cend - cstart + 1 < minpts) {
                        if (!LOG.isDebuggingFinest()) continue;
                        LOG.debugFinest("MinPts not satisfied.");
                        continue;
                    }
                    ArrayModifiableDBIDs dbids = DBIDUtil.newArray();
                    for (int idx = cstart; idx <= cend; ++idx) {
                        tmp.seek(idx);
                        if (!unclaimedids.remove(tmp)) continue;
                        dbids.add(tmp);
                    }
                    if (LOG.isDebuggingFine()) {
                        LOG.debugFine("Found cluster with " + dbids.size() + " new objects, length " + (cend - cstart + 1));
                    }
                    OPTICSModel model = new OPTICSModel(cstart, cend);
                    Cluster<OPTICSModel> cluster = new Cluster<OPTICSModel>("Cluster_" + cstart + "_" + cend, (DBIDs)dbids, model);
                    Iterator iter = curclusters.iterator();
                    while (iter.hasNext()) {
                        Cluster clus = (Cluster)iter.next();
                        OPTICSModel omodel = (OPTICSModel)clus.getModel();
                        if (model.getStartIndex() > omodel.getStartIndex() || omodel.getEndIndex() > model.getEndIndex()) continue;
                        clustering.addChildCluster(cluster, clus);
                        iter.remove();
                    }
                    curclusters.add(cluster);
                }
                continue;
            }
            scan.next();
        }
        if (scanprog != null) {
            scanprog.setProcessed(clusterOrder.size(), LOG);
        }
        if (!unclaimedids.isEmpty()) {
            boolean noise = reach.doubleValue(tmp.seek(clusterOrder.size() - 1)) >= Double.POSITIVE_INFINITY;
            Cluster<OPTICSModel> allcluster = new Cluster<OPTICSModel>(noise ? "Noise" : "Cluster", unclaimedids, noise, new OPTICSModel(0, clusterOrder.size() - 1));
            for (Cluster cluster : curclusters) {
                clustering.addChildCluster(allcluster, cluster);
            }
            clustering.addToplevelCluster(allcluster);
        } else {
            for (Cluster cluster : curclusters) {
                clustering.addToplevelCluster(cluster);
            }
        }
        clustering.addChildResult(clusterOrderResult);
        if (salist != null) {
            clusterOrderResult.addChildResult(new SteepAreaResult(salist));
        }
        return clustering;
    }

    private static void updateFilterSDASet(double mib, List<SteepDownArea> sdaset, double ixi) {
        Iterator<SteepDownArea> iter = sdaset.iterator();
        while (iter.hasNext()) {
            SteepDownArea sda = iter.next();
            if (sda.getMaximum() * ixi <= mib) {
                iter.remove();
                continue;
            }
            if (!(mib > sda.getMib())) continue;
            sda.setMib(mib);
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.optics.getInputTypeRestriction();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID XIALG_ID = new OptionID("opticsxi.algorithm", "The actual OPTICS-type algorithm to use.");
        public static final OptionID XI_ID = new OptionID("opticsxi.xi", "Threshold for the steepness requirement.");
        public static final OptionID NOCORRECT_ID = new OptionID("opticsxi.nocorrect", "Disable the predecessor correction.");
        public static final OptionID KEEPSTEEP_ID = new OptionID("opticsxi.keepsteep", "Keep the steep up/down areas of the plot.");
        protected OPTICSTypeAlgorithm optics;
        protected double xi = 0.0;
        protected boolean nocorrect = false;
        protected boolean keepsteep = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag keepsteepF;
            Flag nocorrectF;
            ClassParameter opticsP;
            super.makeOptions(config);
            DoubleParameter xiP = (DoubleParameter)((DoubleParameter)new DoubleParameter(XI_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (config.grab(xiP)) {
                this.xi = xiP.doubleValue();
            }
            if (config.grab(opticsP = new ClassParameter(XIALG_ID, OPTICSTypeAlgorithm.class, OPTICSHeap.class))) {
                this.optics = (OPTICSTypeAlgorithm)opticsP.instantiateClass(config);
            }
            if (config.grab(nocorrectF = new Flag(NOCORRECT_ID))) {
                this.nocorrect = nocorrectF.isTrue();
            }
            if (config.grab(keepsteepF = new Flag(KEEPSTEEP_ID))) {
                this.keepsteep = keepsteepF.isTrue();
            }
        }

        @Override
        protected OPTICSXi makeInstance() {
            return new OPTICSXi(this.optics, this.xi, this.nocorrect, this.keepsteep);
        }
    }

    public static class SteepAreaResult
    implements IterableResult<SteepArea> {
        Collection<SteepArea> areas;

        public SteepAreaResult(Collection<SteepArea> areas) {
            this.areas = areas;
        }

        @Override
        public String getLongName() {
            return "Xi-Steep areas";
        }

        @Override
        public String getShortName() {
            return "xi-steep-areas";
        }

        @Override
        public Iterator<SteepArea> iterator() {
            return this.areas.iterator();
        }
    }

    public static class SteepUpArea
    extends SteepArea {
        public SteepUpArea(int startindex, int endindex, double endDouble) {
            super(startindex, endindex, endDouble);
        }

        public String toString() {
            return "SteepUpArea(" + this.getStartIndex() + " - " + this.getEndIndex() + ", max=" + this.getMaximum() + ")";
        }
    }

    public static class SteepDownArea
    extends SteepArea {
        private double mib;

        public SteepDownArea(int startindex, int endindex, double startDouble, double mib) {
            super(startindex, endindex, startDouble);
            this.mib = mib;
        }

        public double getMib() {
            return this.mib;
        }

        public void setMib(double mib) {
            this.mib = mib;
        }

        public String toString() {
            return "SteepDownArea(" + this.getStartIndex() + " - " + this.getEndIndex() + ", max=" + this.getMaximum() + ", mib=" + this.mib + ")";
        }
    }

    public static abstract class SteepArea {
        private int startindex;
        private int endindex;
        private double maximum;

        public SteepArea(int startindex, int endindex, double maximum) {
            this.startindex = startindex;
            this.endindex = endindex;
            this.maximum = maximum;
        }

        public int getStartIndex() {
            return this.startindex;
        }

        public int getEndIndex() {
            return this.endindex;
        }

        public double getMaximum() {
            return this.maximum;
        }
    }

    private static class SteepScanPosition {
        ClusterOrder co;
        int index;
        private DBIDArrayIter cur;
        private DBIDArrayIter next;

        public SteepScanPosition(ClusterOrder co) {
            this.co = co;
            this.index = 0;
            this.cur = co.ids.iter();
            this.next = co.ids.iter();
            if (this.next.valid()) {
                this.next.advance();
            }
        }

        public void next() {
            ++this.index;
            this.cur.advance();
            this.next.advance();
        }

        public boolean hasNext() {
            return this.index < this.co.size();
        }

        public boolean steepUp(double ixi) {
            if (this.co.reachability.doubleValue(this.cur) >= Double.POSITIVE_INFINITY) {
                return false;
            }
            if (!this.next.valid()) {
                return true;
            }
            return this.co.reachability.doubleValue(this.cur) <= this.co.reachability.doubleValue(this.next) * ixi;
        }

        public boolean steepDown(double ixi) {
            if (!this.next.valid()) {
                return false;
            }
            if (this.co.reachability.doubleValue(this.next) >= Double.POSITIVE_INFINITY) {
                return false;
            }
            return this.co.reachability.doubleValue(this.cur) * ixi >= this.co.reachability.doubleValue(this.next);
        }

        public double getReachability() {
            return this.co.reachability.doubleValue(this.cur);
        }

        public double getNextReachability() {
            return this.next.valid() ? this.co.reachability.doubleValue(this.next) : Double.POSITIVE_INFINITY;
        }
    }
}

