/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique.CLIQUESubspace;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique.CLIQUEUnit;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jafama.FastMath;

@Title(value="CLIQUE: Automatic Subspace Clustering of High Dimensional Data for Data Mining Applications")
@Description(value="Grid-based algorithm to identify dense clusters in subspaces of maximum dimensionality.")
@Reference(authors="R. Agrawal, J. Gehrke, D. Gunopulos, P. Raghavan", title="Automatic Subspace Clustering of High Dimensional Data for Data Mining Applications", booktitle="Proc. SIGMOD Conference, Seattle, WA, 1998", url="https://doi.org/10.1145/276304.276314", bibkey="DBLP:conf/sigmod/AgrawalGGR98")
public class CLIQUE
extends AbstractAlgorithm<Clustering<SubspaceModel>>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(CLIQUE.class);
    protected int xsi;
    protected double tau;
    protected boolean prune;

    public CLIQUE(int xsi, double tau, boolean prune) {
        this.xsi = xsi;
        this.tau = tau;
        this.prune = prune;
    }

    /*
     * WARNING - void declaration
     */
    public Clustering<SubspaceModel> run(Relation<? extends NumberVector> relation) {
        void var7_13;
        int dimensionality = RelationUtil.dimensionality(relation);
        StepProgress step = new StepProgress(2);
        step.beginStep(1, "Identification of subspaces that contain clusters", LOG);
        ArrayList<List<CLIQUESubspace>> dimensionToDenseSubspaces = new ArrayList<List<CLIQUESubspace>>(dimensionality);
        List<CLIQUESubspace> denseSubspaces = this.findOneDimensionalDenseSubspaces(relation);
        dimensionToDenseSubspaces.add(denseSubspaces);
        if (LOG.isVerbose()) {
            LOG.verbose("1-dimensional dense subspaces: " + denseSubspaces.size());
        }
        if (LOG.isDebugging()) {
            for (CLIQUESubspace cLIQUESubspace : denseSubspaces) {
                LOG.debug(cLIQUESubspace.toString());
            }
        }
        for (int k = 2; k <= dimensionality && !denseSubspaces.isEmpty(); ++k) {
            denseSubspaces = this.findDenseSubspaces(relation, denseSubspaces);
            assert (dimensionToDenseSubspaces.size() == k - 1);
            dimensionToDenseSubspaces.add(denseSubspaces);
            if (LOG.isVerbose()) {
                LOG.verbose(k + "-dimensional dense subspaces: " + denseSubspaces.size());
            }
            if (!LOG.isDebugging()) continue;
            for (CLIQUESubspace s : denseSubspaces) {
                LOG.debug(s.toString());
            }
        }
        step.beginStep(2, "Identification of clusters", LOG);
        Clustering<SubspaceModel> result = new Clustering<SubspaceModel>("CLIQUE clustering", "clique-clustering");
        boolean bl = false;
        while (var7_13 < dimensionToDenseSubspaces.size()) {
            List subspaces = (List)dimensionToDenseSubspaces.get((int)var7_13);
            List<Pair<Subspace, ModifiableDBIDs>> modelsAndClusters = this.determineClusters(subspaces);
            if (LOG.isVerbose()) {
                LOG.verbose((int)(var7_13 + true) + "-dimensional clusters: " + modelsAndClusters.size());
            }
            for (Pair<Subspace, ModifiableDBIDs> modelAndCluster : modelsAndClusters) {
                Cluster<SubspaceModel> newCluster = new Cluster<SubspaceModel>((DBIDs)modelAndCluster.second);
                newCluster.setModel(new SubspaceModel((Subspace)modelAndCluster.first, Centroid.make(relation, (DBIDs)modelAndCluster.second).getArrayRef()));
                result.addToplevelCluster(newCluster);
            }
            ++var7_13;
        }
        return result;
    }

    private List<Pair<Subspace, ModifiableDBIDs>> determineClusters(List<CLIQUESubspace> denseSubspaces) {
        ArrayList<Pair<Subspace, ModifiableDBIDs>> clusters = new ArrayList<Pair<Subspace, ModifiableDBIDs>>();
        for (CLIQUESubspace subspace : denseSubspaces) {
            List<Pair<Subspace, ModifiableDBIDs>> clustersInSubspace = subspace.determineClusters();
            if (LOG.isDebugging()) {
                LOG.debugFine("Subspace " + subspace + " clusters " + clustersInSubspace.size());
            }
            clusters.addAll(clustersInSubspace);
        }
        return clusters;
    }

    private List<CLIQUESubspace> findOneDimensionalDenseSubspaces(Relation<? extends NumberVector> database) {
        List<CLIQUESubspace> denseSubspaceCandidates = this.findOneDimensionalDenseSubspaceCandidates(database);
        return this.prune ? this.pruneDenseSubspaces(denseSubspaceCandidates) : denseSubspaceCandidates;
    }

    private List<CLIQUESubspace> findDenseSubspaces(Relation<? extends NumberVector> database, List<CLIQUESubspace> denseSubspaces) {
        List<CLIQUESubspace> denseSubspaceCandidates = this.findDenseSubspaceCandidates(database, denseSubspaces);
        return this.prune ? this.pruneDenseSubspaces(denseSubspaceCandidates) : denseSubspaceCandidates;
    }

    private Collection<CLIQUEUnit> initOneDimensionalUnits(Relation<? extends NumberVector> database) {
        StringBuilder buf = LOG.isDebuggingFiner() ? new StringBuilder(1000) : null;
        int dimensionality = RelationUtil.dimensionality(database);
        double[] minima = new double[dimensionality];
        double[] maxima = new double[dimensionality];
        Arrays.fill(minima, Double.MAX_VALUE);
        Arrays.fill(maxima, -1.7976931348623157E308);
        DBIDIter it = database.iterDBIDs();
        while (it.valid()) {
            this.updateMinMax(database.get(it), minima, maxima);
            it.advance();
        }
        int i = 0;
        while (i < maxima.length) {
            int n = i++;
            maxima[n] = maxima[n] + 1.0E-4;
        }
        double[] unit_lengths = new double[dimensionality];
        for (int d = 0; d < dimensionality; ++d) {
            unit_lengths[d] = (maxima[d] - minima[d]) / (double)this.xsi;
        }
        if (buf != null) {
            FormatUtil.formatTo(buf.append("   minima: "), minima, ", ", FormatUtil.NF2);
            FormatUtil.formatTo(buf.append("\n   maxima: "), maxima, ", ", FormatUtil.NF2);
            FormatUtil.formatTo(buf.append("\n   unit lengths: "), unit_lengths, ", ", FormatUtil.NF2);
        }
        double[][] unit_bounds = new double[this.xsi + 1][dimensionality];
        for (int x = 0; x <= this.xsi; ++x) {
            for (int d = 0; d < dimensionality; ++d) {
                unit_bounds[x][d] = x < this.xsi ? minima[d] + (double)x * unit_lengths[d] : maxima[d];
            }
        }
        if (buf != null) {
            FormatUtil.formatTo(buf.append("   unit bounds "), unit_bounds, "    [", "]\n", ", ", FormatUtil.NF2);
        }
        ArrayList<CLIQUEUnit> units = new ArrayList<CLIQUEUnit>(this.xsi * dimensionality);
        for (int x = 0; x < this.xsi; ++x) {
            for (int d = 0; d < dimensionality; ++d) {
                units.add(new CLIQUEUnit(d, unit_bounds[x][d], unit_bounds[x + 1][d]));
            }
        }
        if (buf != null) {
            LOG.debugFiner(buf.append("   total number of 1-dim units: ").append(units.size()).toString());
        }
        return units;
    }

    private void updateMinMax(NumberVector featureVector, double[] minima, double[] maxima) {
        assert (minima.length == featureVector.getDimensionality());
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            double v = featureVector.doubleValue(d);
            if (v != v) continue;
            maxima[d] = MathUtil.max(v, maxima[d]);
            minima[d] = MathUtil.min(v, minima[d]);
        }
    }

    private List<CLIQUESubspace> findOneDimensionalDenseSubspaceCandidates(Relation<? extends NumberVector> database) {
        Collection<CLIQUEUnit> units = this.initOneDimensionalUnits(database);
        double total = database.size();
        DBIDIter it = database.iterDBIDs();
        while (it.valid()) {
            NumberVector featureVector = database.get(it);
            for (CLIQUEUnit cLIQUEUnit : units) {
                cLIQUEUnit.addFeatureVector(it, featureVector);
            }
            it.advance();
        }
        int dimensionality = RelationUtil.dimensionality(database);
        ArrayList<CLIQUEUnit> denseUnits = new ArrayList<CLIQUEUnit>();
        CLIQUESubspace[] denseSubspaces = new CLIQUESubspace[dimensionality];
        for (CLIQUEUnit unit : units) {
            if (!(unit.selectivity(total) >= this.tau)) continue;
            denseUnits.add(unit);
            int dim = unit.getDimension(0);
            CLIQUESubspace subspace_d = denseSubspaces[dim];
            if (subspace_d == null) {
                denseSubspaces[dim] = subspace_d = new CLIQUESubspace(dim);
            }
            subspace_d.addDenseUnit(unit);
        }
        ArrayList<CLIQUESubspace> arrayList = new ArrayList<CLIQUESubspace>(dimensionality);
        for (CLIQUESubspace s : denseSubspaces) {
            if (s == null) continue;
            arrayList.add(s);
        }
        Collections.sort(arrayList, CLIQUESubspace.BY_COVERAGE);
        if (LOG.isDebugging()) {
            LOG.debugFine("   number of 1-dim dense units: " + denseUnits.size() + "\n   number of 1-dim dense subspace candidates: " + arrayList.size());
        }
        return arrayList;
    }

    private List<CLIQUESubspace> findDenseSubspaceCandidates(Relation<? extends NumberVector> database, List<CLIQUESubspace> denseSubspaces) {
        ArrayList<CLIQUESubspace> denseSubspacesByDimensions = new ArrayList<CLIQUESubspace>(denseSubspaces);
        Collections.sort(denseSubspacesByDimensions, Subspace.DIMENSION_COMPARATOR);
        double all = database.size();
        ArrayList<CLIQUESubspace> denseSubspaceCandidates = new ArrayList<CLIQUESubspace>();
        while (!denseSubspacesByDimensions.isEmpty()) {
            CLIQUESubspace s1 = (CLIQUESubspace)denseSubspacesByDimensions.remove(0);
            for (CLIQUESubspace s2 : denseSubspacesByDimensions) {
                CLIQUESubspace s = s1.join(s2, all, this.tau);
                if (s == null) continue;
                denseSubspaceCandidates.add(s);
            }
        }
        Collections.sort(denseSubspaceCandidates, CLIQUESubspace.BY_COVERAGE);
        return denseSubspaceCandidates;
    }

    private List<CLIQUESubspace> pruneDenseSubspaces(List<CLIQUESubspace> denseSubspaces) {
        int[][] means = this.computeMeans(denseSubspaces);
        double[][] diffs = this.computeDiffs(denseSubspaces, means[0], means[1]);
        double[] codeLength = new double[denseSubspaces.size()];
        double minCL = Double.MAX_VALUE;
        int min_i = -1;
        for (int i = 0; i < denseSubspaces.size(); ++i) {
            int mi = means[0][i];
            int mp = means[1][i];
            codeLength[i] = CLIQUE.log2OrZero(mi) + diffs[0][i] + CLIQUE.log2OrZero(mp) + diffs[1][i];
            double cl = codeLength[i];
            if (!(cl <= minCL)) continue;
            minCL = cl;
            min_i = i;
        }
        return denseSubspaces.subList(0, min_i + 1);
    }

    private int[][] computeMeans(List<CLIQUESubspace> denseSubspaces) {
        int n = denseSubspaces.size() - 1;
        int[] mi = new int[n + 1];
        int[] mp = new int[n + 1];
        double resultMI = 0.0;
        double resultMP = 0.0;
        for (int i = 0; i < denseSubspaces.size(); ++i) {
            resultMP += (double)denseSubspaces.get(n - i).getCoverage();
            mi[i] = (int)FastMath.ceil((resultMI += (double)denseSubspaces.get(i).getCoverage()) / (double)(i + 1));
            if (i == n) continue;
            mp[n - 1 - i] = (int)FastMath.ceil(resultMP / (double)(i + 1));
        }
        return new int[][]{mi, mp};
    }

    private double[][] computeDiffs(List<CLIQUESubspace> denseSubspaces, int[] mi, int[] mp) {
        int n = denseSubspaces.size() - 1;
        double[] diff_mi = new double[n + 1];
        double[] diff_mp = new double[n + 1];
        double resultMI = 0.0;
        double resultMP = 0.0;
        for (int i = 0; i < denseSubspaces.size(); ++i) {
            double diffMI = Math.abs(denseSubspaces.get(i).getCoverage() - mi[i]);
            double diffMP = i != n ? (double)Math.abs(denseSubspaces.get(n - i).getCoverage() - mp[n - 1 - i]) : 0.0;
            resultMP += CLIQUE.log2OrZero(diffMP);
            diff_mi[i] = resultMI += CLIQUE.log2OrZero(diffMI);
            if (i == n) continue;
            diff_mp[n - 1 - i] = resultMP;
        }
        return new double[][]{diff_mi, diff_mp};
    }

    private static double log2OrZero(double x) {
        return x > 0.0 ? MathUtil.log2(x) : 0.0;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID XSI_ID = new OptionID("clique.xsi", "The number of intervals (units) in each dimension.");
        public static final OptionID TAU_ID = new OptionID("clique.tau", "The density threshold for the selectivity of a unit, where the selectivity is the fraction of total feature vectors contained in this unit.");
        public static final OptionID PRUNE_ID = new OptionID("clique.prune", "Flag to indicate that only subspaces with large coverage (i.e. the fraction of the database that is covered by the dense units) are selected, the rest will be pruned.");
        protected int xsi;
        protected double tau;
        protected boolean prune;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag pruneF;
            DoubleParameter tauP;
            super.makeOptions(config);
            IntParameter xsiP = (IntParameter)new IntParameter(XSI_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(xsiP)) {
                this.xsi = xsiP.intValue();
            }
            if (config.grab(tauP = (DoubleParameter)((DoubleParameter)new DoubleParameter(TAU_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE))) {
                this.tau = tauP.doubleValue();
            }
            if (config.grab(pruneF = new Flag(PRUNE_ID))) {
                this.prune = pruneF.isTrue();
            }
        }

        @Override
        protected CLIQUE makeInstance() {
            return new CLIQUE(this.xsi, this.tau, this.prune);
        }
    }
}

