/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.CorrelationClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.GeneralizedOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.DiSHPreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.ProjectedCentroid;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.jafama.FastMath;

@Title(value="DiSH: Detecting Subspace cluster Hierarchies")
@Description(value="Algorithm to find hierarchical correlation clusters in subspaces.")
@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, I. M\u00fcller-Gorman, A. Zimek", title="Detection and Visualization of Subspace Cluster Hierarchies", booktitle="Proc. 12th Int. Conf. on Database Systems for Advanced Applications (DASFAA)", url="https://doi.org/10.1007/978-3-540-71703-4_15", bibkey="DBLP:conf/dasfaa/AchtertBKKMZ07")
public class DiSH<V extends NumberVector>
extends AbstractAlgorithm<Clustering<SubspaceModel>>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(DiSH.class);
    private double epsilon;
    private DiSHPreferenceVectorIndex.Factory<V> dishPreprocessor;
    private int mu;

    public DiSH(double epsilon, int mu, DiSHPreferenceVectorIndex.Factory<V> dishPreprocessor) {
        this.epsilon = epsilon;
        this.mu = mu;
        this.dishPreprocessor = dishPreprocessor;
    }

    public Clustering<SubspaceModel> run(Database db, Relation<V> relation) {
        if (this.mu >= relation.size()) {
            throw new AbortException("Parameter mu is chosen unreasonably large. This won't yield meaningful results.");
        }
        DiSHClusterOrder opticsResult = new Instance(db, relation).run();
        if (LOG.isVerbose()) {
            LOG.verbose("Compute Clusters.");
        }
        return this.computeClusters(relation, opticsResult);
    }

    private Clustering<SubspaceModel> computeClusters(Relation<V> database, DiSHClusterOrder clusterOrder) {
        int dimensionality = RelationUtil.dimensionality(database);
        Object2ObjectOpenCustomHashMap<long[], List<ArrayModifiableDBIDs>> clustersMap = this.extractClusters(database, clusterOrder);
        this.logClusterSizes("Step 1: extract clusters", dimensionality, clustersMap);
        this.checkClusters(database, clustersMap);
        this.logClusterSizes("Step 2: check clusters", dimensionality, clustersMap);
        List<Cluster<SubspaceModel>> clusters = this.sortClusters(database, clustersMap);
        if (LOG.isVerbose()) {
            StringBuilder msg = new StringBuilder("Step 3: sort clusters");
            for (Cluster<SubspaceModel> c : clusters) {
                msg.append('\n').append(BitsUtil.toStringLow(c.getModel().getSubspace().getDimensions(), dimensionality)).append(" ids ").append(c.size());
            }
            LOG.verbose(msg.toString());
        }
        Clustering<SubspaceModel> clustering = new Clustering<SubspaceModel>("DiSH clustering", "dish-clustering");
        this.buildHierarchy(database, clustering, clusters, dimensionality);
        if (LOG.isVerbose()) {
            StringBuilder msg = new StringBuilder("Step 4: build hierarchy");
            for (Cluster cluster : clusters) {
                msg.append('\n').append(BitsUtil.toStringLow(((SubspaceModel)cluster.getModel()).getSubspace().getDimensions(), dimensionality)).append(" ids ").append(cluster.size());
                It<Cluster<SubspaceModel>> iter = clustering.getClusterHierarchy().iterParents(cluster);
                while (iter.valid()) {
                    msg.append("\n   parent ").append(iter.get());
                    iter.advance();
                }
                iter = clustering.getClusterHierarchy().iterChildren(cluster);
                while (iter.valid()) {
                    msg.append("\n   child ").append(iter.get());
                    iter.advance();
                }
            }
            LOG.verbose(msg.toString());
        }
        for (Cluster<SubspaceModel> c : clusters) {
            if (clustering.getClusterHierarchy().numParents(c) != 0) continue;
            clustering.addToplevelCluster(c);
        }
        return clustering;
    }

    private void logClusterSizes(String m, int dimensionality, Object2ObjectOpenCustomHashMap<long[], List<ArrayModifiableDBIDs>> clustersMap) {
        if (LOG.isVerbose()) {
            StringBuilder msg = new StringBuilder(1000).append(m).append('\n');
            ObjectIterator iter = clustersMap.object2ObjectEntrySet().fastIterator();
            while (iter.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iter.next();
                msg.append(BitsUtil.toStringLow((long[])entry.getKey(), dimensionality)).append(" sizes:");
                for (ArrayModifiableDBIDs c : (List)entry.getValue()) {
                    msg.append(' ').append(c.size());
                }
                msg.append('\n');
            }
            LOG.verbose(msg.toString());
        }
    }

    private Object2ObjectOpenCustomHashMap<long[], List<ArrayModifiableDBIDs>> extractClusters(Relation<V> relation, DiSHClusterOrder clusterOrder) {
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Extract Clusters", relation.size(), LOG) : null;
        Object2ObjectOpenCustomHashMap<long[], List<ArrayModifiableDBIDs>> clustersMap = new Object2ObjectOpenCustomHashMap<long[], List<ArrayModifiableDBIDs>>(BitsUtil.FASTUTIL_HASH_STRATEGY);
        WritableDataStore<Pair> entryToClusterMap = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, Pair.class);
        DBIDArrayIter iter = clusterOrder.iter();
        while (iter.valid()) {
            NumberVector object = (NumberVector)relation.get(iter);
            long[] preferenceVector = clusterOrder.getCommonPreferenceVector(iter);
            ArrayList<ArrayModifiableDBIDs> parallelClusters = (ArrayList<ArrayModifiableDBIDs>)clustersMap.get(preferenceVector);
            if (parallelClusters == null) {
                parallelClusters = new ArrayList<ArrayModifiableDBIDs>();
                clustersMap.put(preferenceVector, parallelClusters);
            }
            Object cluster = null;
            for (ArrayModifiableDBIDs c : parallelClusters) {
                double d;
                long[] commonPreferenceVector;
                ProjectedCentroid c_centroid = ProjectedCentroid.make(preferenceVector, relation, c);
                int subspaceDim = this.subspaceDimensionality(object, c_centroid, preferenceVector, preferenceVector, commonPreferenceVector = BitsUtil.andCMin(preferenceVector, preferenceVector));
                if (subspaceDim != clusterOrder.getCorrelationValue(iter) || !((d = DiSH.weightedDistance(object, c_centroid, commonPreferenceVector)) <= 2.0 * this.epsilon)) continue;
                cluster = c;
                break;
            }
            if (cluster == null) {
                cluster = DBIDUtil.newArray();
                parallelClusters.add((ArrayModifiableDBIDs)cluster);
            }
            cluster.add(iter);
            entryToClusterMap.put(iter, new Pair<long[], Object>(preferenceVector, cluster));
            LOG.incrementProcessed(progress);
            iter.advance();
        }
        LOG.ensureCompleted(progress);
        if (LOG.isDebuggingFiner()) {
            int dim = RelationUtil.dimensionality(relation);
            StringBuilder msg = new StringBuilder("Step 0");
            for (Map.Entry clusterList : clustersMap.entrySet()) {
                for (ArrayModifiableDBIDs c : (List)clusterList.getValue()) {
                    msg.append('\n').append(BitsUtil.toStringLow((long[])clusterList.getKey(), dim)).append(" ids ").append(c.size());
                }
            }
            LOG.debugFiner(msg.toString());
        }
        DBIDVar cur = DBIDUtil.newVar();
        DBIDVar pre = DBIDUtil.newVar();
        for (long[] pv : clustersMap.keySet()) {
            List<ArrayModifiableDBIDs> parallelClusters = clustersMap.get(pv);
            for (ArrayModifiableDBIDs cluster : parallelClusters) {
                if (cluster.isEmpty()) continue;
                cluster.assignVar(0, cur);
                clusterOrder.getPredecessor(cur, pre);
                if (!pre.isSet() || DBIDUtil.equal(pre, cur) || BitsUtil.equal(clusterOrder.getCommonPreferenceVector(pre), clusterOrder.getCommonPreferenceVector(cur)) || clusterOrder.getCorrelationValue(pre) < clusterOrder.getCorrelationValue(cur) || clusterOrder.getReachability(pre) < clusterOrder.getReachability(cur)) continue;
                Pair oldCluster = (Pair)entryToClusterMap.get(pre);
                ((ArrayModifiableDBIDs)oldCluster.second).remove(pre);
                cluster.add(pre);
                entryToClusterMap.put(pre, new Pair<long[], ArrayModifiableDBIDs>(pv, cluster));
            }
        }
        return clustersMap;
    }

    private List<Cluster<SubspaceModel>> sortClusters(Relation<V> relation, Object2ObjectMap<long[], List<ArrayModifiableDBIDs>> clustersMap) {
        int db_dim = RelationUtil.dimensionality(relation);
        ArrayList<Cluster<SubspaceModel>> clusters = new ArrayList<Cluster<SubspaceModel>>();
        for (long[] pv : clustersMap.keySet()) {
            List parallelClusters = (List)clustersMap.get(pv);
            for (int i = 0; i < parallelClusters.size(); ++i) {
                ArrayModifiableDBIDs c = (ArrayModifiableDBIDs)parallelClusters.get(i);
                Cluster<SubspaceModel> cluster = new Cluster<SubspaceModel>(c);
                cluster.setModel(new SubspaceModel(new Subspace(pv), Centroid.make(relation, c).getArrayRef()));
                String subspace = BitsUtil.toStringLow(((SubspaceModel)cluster.getModel()).getSubspace().getDimensions(), db_dim);
                cluster.setName(parallelClusters.size() > 1 ? "Cluster_" + subspace + "_" + i : "Cluster_" + subspace);
                clusters.add(cluster);
            }
        }
        Comparator<Cluster<SubspaceModel>> comparator = new Comparator<Cluster<SubspaceModel>>(){

            @Override
            public int compare(Cluster<SubspaceModel> c1, Cluster<SubspaceModel> c2) {
                return c2.getModel().getSubspace().dimensionality() - c1.getModel().getSubspace().dimensionality();
            }
        };
        Collections.sort(clusters, comparator);
        return clusters;
    }

    private void checkClusters(Relation<V> relation, Object2ObjectMap<long[], List<ArrayModifiableDBIDs>> clustersMap) {
        int dimensionality = RelationUtil.dimensionality(relation);
        ArrayList<Pair<long[], ArrayModifiableDBIDs>> notAssigned = new ArrayList<Pair<long[], ArrayModifiableDBIDs>>();
        Object2ObjectOpenCustomHashMap newClustersMap = new Object2ObjectOpenCustomHashMap(BitsUtil.FASTUTIL_HASH_STRATEGY);
        Pair<long[], ArrayModifiableDBIDs> noise = new Pair<long[], ArrayModifiableDBIDs>(BitsUtil.zero(dimensionality), DBIDUtil.newArray());
        for (long[] lArray : clustersMap.keySet()) {
            List parallelClusters;
            if (BitsUtil.cardinality(lArray) == 0) {
                parallelClusters = (List)clustersMap.get(lArray);
                for (ArrayModifiableDBIDs c : parallelClusters) {
                    ((ArrayModifiableDBIDs)noise.second).addDBIDs(c);
                }
                continue;
            }
            parallelClusters = (List)clustersMap.get(lArray);
            ArrayList<ArrayModifiableDBIDs> newParallelClusters = new ArrayList<ArrayModifiableDBIDs>(parallelClusters.size());
            for (ArrayModifiableDBIDs c : parallelClusters) {
                if (!BitsUtil.isZero(lArray) && c.size() < this.mu) {
                    notAssigned.add(new Pair<long[], ArrayModifiableDBIDs>(lArray, c));
                    continue;
                }
                newParallelClusters.add(c);
            }
            newClustersMap.put(lArray, newParallelClusters);
        }
        clustersMap.clear();
        clustersMap.putAll(newClustersMap);
        for (Pair pair : notAssigned) {
            Pair<long[], ArrayModifiableDBIDs> parent;
            if (((ArrayModifiableDBIDs)pair.second).isEmpty()) continue;
            ((ArrayModifiableDBIDs)((parent = this.findParent(relation, (Pair<long[], ArrayModifiableDBIDs>)pair, clustersMap)) != null ? parent : noise).second).addDBIDs((DBIDs)pair.second);
        }
        ArrayList noiseList = new ArrayList(1);
        noiseList.add(noise.second);
        clustersMap.put((long[])noise.first, noiseList);
    }

    private Pair<long[], ArrayModifiableDBIDs> findParent(Relation<V> relation, Pair<long[], ArrayModifiableDBIDs> child, Object2ObjectMap<long[], List<ArrayModifiableDBIDs>> clustersMap) {
        ProjectedCentroid child_centroid = ProjectedCentroid.make((long[])child.first, relation, (DBIDs)child.second);
        Pair<long[], ArrayModifiableDBIDs> result = null;
        int resultCardinality = -1;
        long[] childPV = (long[])child.first;
        int childCardinality = BitsUtil.cardinality(childPV);
        block0: for (long[] parentPV : clustersMap.keySet()) {
            long[] pv;
            int parentCardinality = BitsUtil.cardinality(parentPV);
            if (parentCardinality >= childCardinality || resultCardinality != -1 && parentCardinality <= resultCardinality || !BitsUtil.equal(pv = BitsUtil.andCMin(childPV, parentPV), parentPV)) continue;
            List parentList = (List)clustersMap.get(parentPV);
            for (ArrayModifiableDBIDs parent : parentList) {
                ProjectedCentroid parent_centroid = ProjectedCentroid.make(parentPV, relation, parent);
                double d = DiSH.weightedDistance(child_centroid, parent_centroid, parentPV);
                if (!(d <= 2.0 * this.epsilon)) continue;
                result = new Pair<long[], ArrayModifiableDBIDs>(parentPV, parent);
                resultCardinality = parentCardinality;
                continue block0;
            }
        }
        return result;
    }

    private void buildHierarchy(Relation<V> database, Clustering<SubspaceModel> clustering, List<Cluster<SubspaceModel>> clusters, int dimensionality) {
        StringBuilder msg = LOG.isDebugging() ? new StringBuilder() : null;
        int db_dim = RelationUtil.dimensionality(database);
        Hierarchy<Cluster<SubspaceModel>> hier = clustering.getClusterHierarchy();
        for (int i = 0; i < clusters.size() - 1; ++i) {
            Cluster<SubspaceModel> c_i = clusters.get(i);
            Subspace s_i = c_i.getModel().getSubspace();
            int subspaceDim_i = dimensionality - s_i.dimensionality();
            ProjectedCentroid ci_centroid = ProjectedCentroid.make(s_i.getDimensions(), database, c_i.getIDs());
            long[] pv1 = s_i.getDimensions();
            for (int j = i + 1; j < clusters.size(); ++j) {
                Cluster<SubspaceModel> c_j = clusters.get(j);
                Subspace s_j = c_j.getModel().getSubspace();
                int subspaceDim_j = dimensionality - s_j.dimensionality();
                if (subspaceDim_i >= subspaceDim_j) continue;
                if (msg != null) {
                    msg.append("\n l_i=").append(subspaceDim_i).append(" pv_i=[").append(BitsUtil.toStringLow(s_i.getDimensions(), db_dim)).append(']').append("\n l_j=").append(subspaceDim_j).append(" pv_j=[").append(BitsUtil.toStringLow(s_j.getDimensions(), db_dim)).append(']');
                }
                if (s_j.dimensionality() == 0) {
                    if (hier.numParents(c_i) != 0) continue;
                    clustering.addChildCluster(c_j, c_i);
                    if (msg == null) continue;
                    msg.append("\n [").append(BitsUtil.toStringLow(s_j.getDimensions(), db_dim)).append("] is parent of [").append(BitsUtil.toStringLow(s_i.getDimensions(), db_dim)).append(']');
                    continue;
                }
                ProjectedCentroid cj_centroid = ProjectedCentroid.make(c_j.getModel().getDimensions(), database, c_j.getIDs());
                long[] pv2 = s_j.getDimensions();
                long[] commonPreferenceVector = BitsUtil.andCMin(pv1, pv2);
                int subspaceDim = this.subspaceDimensionality(ci_centroid, cj_centroid, pv1, pv2, commonPreferenceVector);
                double d = DiSH.weightedDistance(ci_centroid, cj_centroid, commonPreferenceVector);
                if (msg != null) {
                    msg.append("\n dist = ").append(subspaceDim);
                }
                if (subspaceDim != subspaceDim_j) continue;
                if (msg != null) {
                    msg.append("\n d = ").append(d);
                }
                if (d <= 2.0 * this.epsilon) {
                    if (hier.numParents(c_i) != 0 && this.isParent(database, c_j, hier.iterParents(c_i), db_dim)) continue;
                    clustering.addChildCluster(c_j, c_i);
                    if (msg == null) continue;
                    msg.append("\n [").append(BitsUtil.toStringLow(s_j.getDimensions(), db_dim)).append("] is parent of [").append(BitsUtil.toStringLow(s_i.getDimensions(), db_dim)).append(']');
                    continue;
                }
                throw new RuntimeException("Should never happen: d = " + d);
            }
        }
        if (msg != null) {
            LOG.debug(msg.toString());
        }
    }

    private boolean isParent(Relation<V> relation, Cluster<SubspaceModel> parent, It<Cluster<SubspaceModel>> iter, int db_dim) {
        Subspace s_p = parent.getModel().getSubspace();
        ProjectedCentroid parent_centroid = ProjectedCentroid.make(s_p.getDimensions(), relation, parent.getIDs());
        int subspaceDim_parent = db_dim - s_p.dimensionality();
        while (iter.valid()) {
            Cluster<SubspaceModel> child = iter.get();
            Subspace s_c = child.getModel().getSubspace();
            ProjectedCentroid child_centroid = ProjectedCentroid.make(s_c.getDimensions(), relation, child.getIDs());
            long[] commonPreferenceVector = BitsUtil.andCMin(s_p.getDimensions(), s_c.getDimensions());
            int subspaceDim = this.subspaceDimensionality(parent_centroid, child_centroid, s_p.getDimensions(), s_c.getDimensions(), commonPreferenceVector);
            if (subspaceDim == subspaceDim_parent) {
                return true;
            }
            iter.advance();
        }
        return false;
    }

    private int subspaceDimensionality(NumberVector v1, NumberVector v2, long[] pv1, long[] pv2, long[] commonPreferenceVector) {
        double d;
        int subspaceDim = v1.getDimensionality() - BitsUtil.cardinality(commonPreferenceVector);
        if ((BitsUtil.equal(commonPreferenceVector, pv1) || BitsUtil.equal(commonPreferenceVector, pv2)) && (d = DiSH.weightedDistance(v1, v2, commonPreferenceVector)) > 2.0 * this.epsilon) {
            ++subspaceDim;
        }
        return subspaceDim;
    }

    protected static double weightedDistance(NumberVector v1, NumberVector v2, long[] weightVector) {
        double sqrDist = 0.0;
        int i = BitsUtil.nextSetBit(weightVector, 0);
        while (i >= 0) {
            double manhattanI = v1.doubleValue(i) - v2.doubleValue(i);
            sqrDist += manhattanI * manhattanI;
            i = BitsUtil.nextSetBit(weightVector, i + 1);
        }
        return FastMath.sqrt(sqrDist);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID EPSILON_ID = new OptionID("dish.epsilon", "The maximum radius of the neighborhood to be considered in each  dimension for determination of the preference vector.");
        public static final OptionID MU_ID = new OptionID("dish.mu", "The minimum number of points as a smoothing factor to avoid the single-link-effekt.");
        protected double epsilon = 0.0;
        protected int mu = 1;
        protected DiSHPreferenceVectorIndex.Factory<V> dishPreprocessor;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter muP;
            super.makeOptions(config);
            DoubleParameter epsilonP = (DoubleParameter)new DoubleParameter(EPSILON_ID, 0.001).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(epsilonP)) {
                this.epsilon = epsilonP.doubleValue();
            }
            if (config.grab(muP = (IntParameter)new IntParameter(MU_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.mu = muP.intValue();
            }
            this.configDiSHPreprocessor(config, this.epsilon, this.mu);
        }

        public void configDiSHPreprocessor(Parameterization config, double epsilon, int minpts) {
            ListParameterization dishParameters = new ListParameterization();
            dishParameters.addParameter(DiSHPreferenceVectorIndex.Factory.EPSILON_ID, (Object)epsilon);
            dishParameters.addParameter(DiSHPreferenceVectorIndex.Factory.MINPTS_ID, (Object)minpts);
            ChainedParameterization dishchain = new ChainedParameterization(dishParameters, config);
            dishchain.errorsTo(config);
            Class cls = ClassGenericsUtil.uglyCastIntoSubclass(DiSHPreferenceVectorIndex.Factory.class);
            this.dishPreprocessor = (DiSHPreferenceVectorIndex.Factory)dishchain.tryInstantiate(cls);
        }

        @Override
        protected DiSH<V> makeInstance() {
            return new DiSH<V>(this.epsilon, this.mu, this.dishPreprocessor);
        }
    }

    public static class DiSHClusterOrder
    extends CorrelationClusterOrder {
        private WritableDataStore<long[]> commonPreferenceVectors;

        public DiSHClusterOrder(String name, String shortname, ArrayModifiableDBIDs ids, WritableDoubleDataStore reachability, WritableDBIDDataStore predecessor, WritableIntegerDataStore corrdim, WritableDataStore<long[]> commonPreferenceVectors) {
            super(name, shortname, ids, reachability, predecessor, corrdim);
            this.commonPreferenceVectors = commonPreferenceVectors;
        }

        public long[] getCommonPreferenceVector(DBIDRef id) {
            return (long[])this.commonPreferenceVectors.get(id);
        }
    }

    private class Instance
    extends GeneralizedOPTICS.Instance<V, DiSHClusterOrder> {
        private Relation<V> relation;
        private ArrayModifiableDBIDs clusterOrder;
        private WritableIntegerDataStore correlationValue;
        private WritableDataStore<long[]> commonPreferenceVectors;
        private ArrayModifiableDBIDs tmpIds;
        private WritableIntegerDataStore tmpCorrelation;
        private WritableDoubleDataStore tmpDistance;
        Comparator<DBIDRef> tmpcomp;
        private DiSHPreferenceVectorIndex<V> index;
        private WritableDataStore<long[]> tmpPreferenceVectors;

        public Instance(Database db, Relation<V> relation) {
            super(db, relation);
            this.tmpcomp = new Sorter();
            DBIDs ids = relation.getDBIDs();
            this.clusterOrder = DBIDUtil.newArray(ids.size());
            this.relation = relation;
            this.correlationValue = DataStoreUtil.makeIntegerStorage(ids, 30, Integer.MAX_VALUE);
            this.commonPreferenceVectors = DataStoreUtil.makeStorage(ids, 3, long[].class);
            this.tmpIds = DBIDUtil.newArray(ids);
            this.tmpCorrelation = DataStoreUtil.makeIntegerStorage(ids, 3);
            this.tmpDistance = DataStoreUtil.makeDoubleStorage(ids, 3);
            this.tmpPreferenceVectors = DataStoreUtil.makeStorage(ids, 3, long[].class);
        }

        @Override
        public DiSHClusterOrder run() {
            this.index = DiSH.this.dishPreprocessor.instantiate(this.relation);
            return (DiSHClusterOrder)super.run();
        }

        @Override
        protected DiSHClusterOrder buildResult() {
            return new DiSHClusterOrder("DiSH Cluster Order", "dish-cluster-order", this.clusterOrder, this.reachability, this.predecessor, this.correlationValue, this.commonPreferenceVectors);
        }

        @Override
        protected void initialDBID(DBIDRef id) {
            this.correlationValue.put(id, Integer.MAX_VALUE);
            this.commonPreferenceVectors.put(id, new long[0]);
        }

        @Override
        protected void expandDBID(DBIDRef id) {
            this.clusterOrder.add(id);
            long[] pv1 = this.index.getPreferenceVector(id);
            NumberVector dv1 = (NumberVector)this.relation.get(id);
            int dim = dv1.getDimensionality();
            long[] ones = BitsUtil.ones(dim);
            long[] inverseCommonPreferenceVector = BitsUtil.ones(dim);
            DBIDArrayMIter iter = this.tmpIds.iter();
            while (iter.valid()) {
                double d;
                long[] pv2 = this.index.getPreferenceVector(iter);
                NumberVector dv2 = (NumberVector)this.relation.get(iter);
                long[] commonPreferenceVector = BitsUtil.andCMin(pv1, pv2);
                int subspaceDim = dim - BitsUtil.cardinality(commonPreferenceVector);
                if ((BitsUtil.equal(commonPreferenceVector, pv1) || BitsUtil.equal(commonPreferenceVector, pv2)) && (d = DiSH.weightedDistance(dv1, dv2, commonPreferenceVector)) > 2.0 * DiSH.this.epsilon) {
                    ++subspaceDim;
                }
                System.arraycopy(ones, 0, inverseCommonPreferenceVector, 0, ones.length);
                BitsUtil.xorI(inverseCommonPreferenceVector, commonPreferenceVector);
                double orthogonalDistance = DiSH.weightedDistance(dv1, dv2, inverseCommonPreferenceVector);
                this.tmpCorrelation.put((DBIDRef)iter, subspaceDim);
                this.tmpDistance.put((DBIDRef)iter, orthogonalDistance);
                this.tmpPreferenceVectors.put(iter, commonPreferenceVector);
                iter.advance();
            }
            this.tmpIds.sort(this.tmpcomp);
            double coredist = this.tmpDistance.doubleValue(iter.seek(DiSH.this.mu - 1));
            iter.seek(0);
            while (iter.valid()) {
                int curcorr;
                int prevcorr;
                if (!this.processedIDs.contains(iter) && (prevcorr = this.correlationValue.intValue(iter)) >= (curcorr = this.tmpCorrelation.intValue(iter))) {
                    double prevdist;
                    double currdist = MathUtil.max(this.tmpDistance.doubleValue(iter), coredist);
                    if (prevcorr != curcorr || !((prevdist = this.reachability.doubleValue(iter)) <= currdist)) {
                        this.correlationValue.putInt(iter, curcorr);
                        this.reachability.putDouble(iter, currdist);
                        this.predecessor.putDBID(iter, id);
                        this.commonPreferenceVectors.put(iter, (long[])this.tmpPreferenceVectors.get(iter));
                        if (prevcorr == Integer.MAX_VALUE) {
                            this.candidates.add(iter);
                        }
                    }
                }
                iter.advance();
            }
        }

        @Override
        public int compare(DBIDRef o1, DBIDRef o2) {
            int c2;
            int c1 = this.correlationValue.intValue(o1);
            return c1 < (c2 = this.correlationValue.intValue(o2)) ? -1 : (c1 > c2 ? 1 : super.compare(o1, o2));
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        private final class Sorter
        implements Comparator<DBIDRef> {
            private Sorter() {
            }

            @Override
            public int compare(DBIDRef o1, DBIDRef o2) {
                int c2;
                int c1 = Instance.this.tmpCorrelation.intValue(o1);
                return c1 < (c2 = Instance.this.tmpCorrelation.intValue(o2)) ? -1 : (c1 > c2 ? 1 : Double.compare(Instance.this.tmpDistance.doubleValue(o1), Instance.this.tmpDistance.doubleValue(o2)));
            }
        }
    }
}

