/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.DOC;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Title(value="FastDOC: Density-based Optimal projective Clustering")
@Reference(authors="C. M. Procopiuc, M. Jones, P. K. Agarwal, T. M. Murali", title="A Monte Carlo algorithm for fast projective clustering", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '02)", url="https://doi.org/10.1145/564691.564739", bibkey="DBLP:conf/sigmod/ProcopiucJAM02")
public class FastDOC<V extends NumberVector>
extends DOC<V> {
    private static final Logging LOG = Logging.getLogger(FastDOC.class);
    private int d_zero;

    public FastDOC(double alpha, double beta, double w, int d_zero, RandomFactory random) {
        super(alpha, beta, w, random);
        this.d_zero = d_zero;
    }

    @Override
    protected Cluster<SubspaceModel> runDOC(Database database, Relation<V> relation, ArrayModifiableDBIDs S, int d, int n, int m, int r, int minClusterSize) {
        long[] D = null;
        DBIDVar dV = DBIDUtil.newVar();
        FiniteProgress iprogress = LOG.isVerbose() ? new FiniteProgress("Iteration progress for current cluster", m * n, LOG) : null;
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDArrayMIter iter = S.iter();
        block0: for (int i = 0; i < n; ++i) {
            iter.seek(random.nextInt(S.size()));
            for (int j = 0; j < m; ++j) {
                ModifiableDBIDs randomSet = DBIDUtil.randomSample((DBIDs)S, r, random);
                long[] nD = BitsUtil.zero(d);
                for (int k = 0; k < d; ++k) {
                    if (!this.dimensionIsRelevant(k, relation, randomSet)) continue;
                    BitsUtil.setI(nD, k);
                }
                if (D == null || BitsUtil.cardinality(nD) > BitsUtil.cardinality(D)) {
                    D = nD;
                    dV.set(iter);
                    if (BitsUtil.cardinality(D) >= this.d_zero) {
                        if (iprogress == null) break block0;
                        iprogress.setProcessed(iprogress.getTotal(), LOG);
                        break block0;
                    }
                }
                LOG.incrementProcessed(iprogress);
            }
        }
        LOG.ensureCompleted(iprogress);
        if (D == null || BitsUtil.cardinality(D) == 0) {
            return null;
        }
        DBIDs C = this.findNeighbors(dV, D, S, relation);
        return C.size() >= minClusterSize ? this.makeCluster(relation, C, D) : null;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends DOC.Parameterizer<V> {
        public static final OptionID D_ZERO_ID = new OptionID("fastdoc.d0", "Parameter for FastDOC, setting the number of relevant attributes which, when found for a cluster, are deemed enough to stop iterating.");
        protected int d_zero;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter param = (IntParameter)new IntParameter(D_ZERO_ID, 5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(param)) {
                this.d_zero = (Integer)param.getValue();
            }
        }

        @Override
        protected FastDOC<V> makeInstance() {
            return new FastDOC(this.alpha, this.beta, this.w, this.d_zero, this.random);
        }
    }
}

