/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.CorrelationClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.GeneralizedOPTICS;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.HiSCPreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import net.jafama.FastMath;

@Title(value="Finding Hierarchies of Subspace Clusters")
@Description(value="Algorithm for detecting hierarchies of subspace clusters.")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Petre Kriegel, Peer Kr\u00f6ger, Ina M\u00fcller-Gorman, Arthur Zimek", title="Finding Hierarchies of Subspace Clusters", booktitle="Proc. 10th Europ. Conf. on Principles and Practice of Knowledge Discovery in Databases (PKDD'06)", url="https://doi.org/10.1007/11871637_42", bibkey="DBLP:conf/pkdd/AchtertBKKMZ06")
public class HiSC<V extends NumberVector>
extends GeneralizedOPTICS<V, CorrelationClusterOrder> {
    private static final Logging LOG = Logging.getLogger(HiSC.class);
    private HiSCPreferenceVectorIndex.Factory<V> indexfactory;
    private double alpha;

    public HiSC(HiSCPreferenceVectorIndex.Factory<V> indexfactory) {
        this.indexfactory = indexfactory;
        this.alpha = indexfactory.getAlpha();
    }

    @Override
    public ClusterOrder run(Database db, Relation<V> relation) {
        return new Instance(db, relation).run();
    }

    public double weightedDistance(V v1, V v2, long[] weightVector) {
        double sqrDist = 0.0;
        int i = BitsUtil.nextSetBit(weightVector, 0);
        while (i >= 0) {
            double manhattanI = v1.doubleValue(i) - v2.doubleValue(i);
            sqrDist += manhattanI * manhattanI;
            i = BitsUtil.nextSetBit(weightVector, i + 1);
        }
        return FastMath.sqrt(sqrDist);
    }

    @Override
    public int getMinPts() {
        return 2;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.indexfactory.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID EPSILON_ID = new OptionID("hisc.epsilon", "The maximum distance between two vectors with equal preference vectors before considering them as parallel.");
        private HiSCPreferenceVectorIndex.Factory<V> indexfactory;
        public static final OptionID ALPHA_ID = new OptionID("hisc.alpha", "The maximum absolute variance along a coordinate axis.");
        public static final double DEFAULT_ALPHA = 0.01;
        public static final OptionID K_ID = new OptionID("hisc.k", "The number of nearest neighbors considered to determine the preference vector. If this value is not defined, k ist set to three times of the dimensionality of the database objects.");

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Class cls = ClassGenericsUtil.uglyCastIntoSubclass(HiSCPreferenceVectorIndex.Factory.class);
            this.indexfactory = (HiSCPreferenceVectorIndex.Factory)config.tryInstantiate(cls);
        }

        @Override
        protected HiSC<V> makeInstance() {
            return new HiSC<V>(this.indexfactory);
        }
    }

    private class Instance
    extends GeneralizedOPTICS.Instance<V, CorrelationClusterOrder> {
        private HiSCPreferenceVectorIndex<V> index;
        private ArrayModifiableDBIDs clusterOrder;
        private Relation<V> relation;
        private WritableIntegerDataStore correlationValue;
        private WritableDataStore<long[]> commonPreferenceVectors;

        public Instance(Database db, Relation<V> relation) {
            super(db, relation);
            DBIDs ids = relation.getDBIDs();
            this.clusterOrder = DBIDUtil.newArray(ids.size());
            this.relation = relation;
            this.correlationValue = DataStoreUtil.makeIntegerStorage(ids, 30, Integer.MAX_VALUE);
            this.commonPreferenceVectors = DataStoreUtil.makeStorage(ids, 1, long[].class);
        }

        @Override
        public CorrelationClusterOrder run() {
            this.index = HiSC.this.indexfactory.instantiate(this.relation);
            return (CorrelationClusterOrder)super.run();
        }

        @Override
        protected CorrelationClusterOrder buildResult() {
            return new CorrelationClusterOrder("HiCO Cluster Order", "hico-cluster-order", this.clusterOrder, this.reachability, this.predecessor, this.correlationValue);
        }

        @Override
        protected void initialDBID(DBIDRef id) {
            this.correlationValue.put(id, Integer.MAX_VALUE);
            this.commonPreferenceVectors.put(id, new long[0]);
        }

        @Override
        protected void expandDBID(DBIDRef id) {
            this.clusterOrder.add(id);
            long[] pv1 = this.index.getPreferenceVector(id);
            NumberVector v1 = (NumberVector)this.relation.get(id);
            int dim = v1.getDimensionality();
            DBIDIter iter = this.relation.iterDBIDs();
            while (iter.valid()) {
                if (!this.processedIDs.contains(iter)) {
                    int prevdim;
                    long[] pv2 = this.index.getPreferenceVector(iter);
                    NumberVector v2 = (NumberVector)this.relation.get(iter);
                    long[] commonPreferenceVector = BitsUtil.andCMin(pv1, pv2);
                    int subspaceDim = dim - BitsUtil.cardinality(commonPreferenceVector);
                    double dist1 = HiSC.this.weightedDistance(v1, v2, pv1);
                    double dist2 = HiSC.this.weightedDistance(v1, v2, pv2);
                    if (dist1 > HiSC.this.alpha || dist2 > HiSC.this.alpha) {
                        ++subspaceDim;
                        if (LOG.isDebugging()) {
                            LOG.debugFine(new StringBuilder(100).append("dist1 ").append(dist1).append("\ndist2 ").append(dist2).append("\nsubspaceDim ").append(subspaceDim).append("\ncommon pv ").append(BitsUtil.toStringLow(commonPreferenceVector, dim)).toString());
                        }
                    }
                    if ((prevdim = this.correlationValue.intValue(iter)) >= subspaceDim) {
                        double prevdist;
                        double orthogonalDistance = HiSC.this.weightedDistance(v1, v2, commonPreferenceVector);
                        if (prevdim != subspaceDim || !((prevdist = this.reachability.doubleValue(iter)) <= orthogonalDistance)) {
                            this.correlationValue.putInt(iter, subspaceDim);
                            this.reachability.putDouble(iter, orthogonalDistance);
                            this.predecessor.putDBID(iter, id);
                            this.commonPreferenceVectors.put(iter, commonPreferenceVector);
                            if (prevdim == Integer.MAX_VALUE) {
                                this.candidates.add(iter);
                            }
                        }
                    }
                }
                iter.advance();
            }
        }

        @Override
        public int compare(DBIDRef o1, DBIDRef o2) {
            int c2;
            int c1 = this.correlationValue.intValue(o1);
            return c1 < (c2 = this.correlationValue.intValue(o2)) ? -1 : (c1 > c2 ? 1 : super.compare(o1, o2));
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

