/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.clustering.AbstractProjectedClustering;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.jafama.FastMath;

@Title(value="PROCLUS: PROjected CLUStering")
@Description(value="Algorithm to find subspace clusters in high dimensional spaces.")
@Reference(authors="C. C. Aggarwal, C. Procopiuc, J. L. Wolf, P. S. Yu, J. S. Park", title="Fast Algorithms for Projected Clustering", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304188", bibkey="doi:10.1145/304181.304188")
public class PROCLUS<V extends NumberVector>
extends AbstractProjectedClustering<Clustering<SubspaceModel>, V>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(PROCLUS.class);
    private int m_i;
    private RandomFactory rnd;

    public PROCLUS(int k, int k_i, int l, int m_i, RandomFactory rnd) {
        super(k, k_i, l);
        this.m_i = m_i;
        this.rnd = rnd;
    }

    public Clustering<SubspaceModel> run(Database database, Relation<V> relation) {
        Object dimensions;
        if (RelationUtil.dimensionality(relation) < this.l) {
            throw new IllegalStateException("Dimensionality of data < parameter l! (" + RelationUtil.dimensionality(relation) + " < " + this.l + ")");
        }
        DistanceQuery<NumberVector> distFunc = database.getDistanceQuery(relation, SquaredEuclideanDistanceFunction.STATIC, new Object[0]);
        RangeQuery<NumberVector> rangeQuery = database.getRangeQuery(distFunc, new Object[0]);
        Random random = this.rnd.getSingleThreadedRandom();
        if (LOG.isVerbose()) {
            LOG.verbose("1. Initialization phase...");
        }
        int sampleSize = Math.min(relation.size(), this.k_i * this.k);
        ModifiableDBIDs sampleSet = DBIDUtil.randomSample(relation.getDBIDs(), sampleSize, random);
        int medoidSize = Math.min(relation.size(), this.m_i * this.k);
        ArrayDBIDs medoids = this.greedy(distFunc, sampleSet, medoidSize, random);
        if (LOG.isDebugging()) {
            LOG.debugFine("sampleSize " + sampleSize + '\n' + "sampleSet " + sampleSet + '\n' + "medoidSize " + medoidSize + '\n' + "m " + medoids);
        }
        if (LOG.isVerbose()) {
            LOG.verbose("2. Iterative phase...");
        }
        double bestObjective = Double.POSITIVE_INFINITY;
        ArrayDBIDs m_best = null;
        DBIDs m_bad = null;
        ArrayDBIDs m_current = this.initialSet(medoids, this.k, random);
        if (LOG.isDebugging()) {
            LOG.debugFine("m_c " + m_current);
        }
        IndefiniteProgress cprogress = LOG.isVerbose() ? new IndefiniteProgress("Current number of clusters:", LOG) : null;
        ArrayList<PROCLUSCluster> clusters = null;
        for (int loops = 0; loops < 10; ++loops) {
            dimensions = this.findDimensions(m_current, relation, distFunc, rangeQuery);
            clusters = this.assignPoints(m_current, (long[][])dimensions, relation);
            double objectiveFunction = this.evaluateClusters(clusters, (long[][])dimensions, relation);
            if (objectiveFunction < bestObjective) {
                loops = 0;
                bestObjective = objectiveFunction;
                m_best = m_current;
                m_bad = this.computeBadMedoids(m_current, clusters, (int)((double)relation.size() * 0.1 / (double)this.k));
            }
            m_current = this.computeM_current(medoids, m_best, m_bad, random);
            if (cprogress == null) continue;
            cprogress.setProcessed(clusters.size(), LOG);
        }
        LOG.setCompleted(cprogress);
        if (LOG.isVerbose()) {
            LOG.verbose("3. Refinement phase...");
        }
        dimensions = this.findDimensions(clusters, relation);
        List<PROCLUSCluster> finalClusters = this.finalAssignment((List<Pair<double[], long[]>>)dimensions, relation);
        int numClusters = 1;
        Clustering<SubspaceModel> result = new Clustering<SubspaceModel>("ProClus clustering", "proclus-clustering");
        for (PROCLUSCluster c : finalClusters) {
            Cluster<SubspaceModel> cluster = new Cluster<SubspaceModel>(c.objectIDs);
            cluster.setModel(new SubspaceModel(new Subspace(c.getDimensions()), c.centroid));
            cluster.setName("cluster_" + numClusters++);
            result.addToplevelCluster(cluster);
        }
        return result;
    }

    private ArrayDBIDs greedy(DistanceQuery<V> distFunc, DBIDs sampleSet, int m, Random random) {
        ArrayModifiableDBIDs medoids = DBIDUtil.newArray(m);
        ArrayModifiableDBIDs s = DBIDUtil.newArray(sampleSet);
        DBIDArrayMIter iter = s.iter();
        DBIDVar m_i = DBIDUtil.newVar();
        int size = s.size();
        s.swap(random.nextInt(size), --size);
        medoids.add(s.pop(m_i));
        if (LOG.isDebugging()) {
            LOG.debugFiner("medoids " + medoids.toString());
        }
        int worst = -1;
        double worstd = Double.NEGATIVE_INFINITY;
        WritableDoubleDataStore distances = DataStoreUtil.makeDoubleStorage(s, 3);
        iter.seek(0);
        while (iter.getOffset() < size) {
            double dist = distFunc.distance((DBIDRef)iter, (DBIDRef)m_i);
            distances.putDouble(iter, dist);
            if (dist > worstd) {
                worstd = dist;
                worst = iter.getOffset();
            }
            iter.advance();
        }
        for (int i = 1; i < m; ++i) {
            s.swap(worst, --size);
            medoids.add(s.pop(m_i));
            worst = -1;
            worstd = Double.NEGATIVE_INFINITY;
            iter.seek(0);
            while (iter.getOffset() < size) {
                double dist_old;
                double dist_new = distFunc.distance((DBIDRef)iter, (DBIDRef)m_i);
                double dist = dist_new < (dist_old = distances.doubleValue(iter)) ? dist_new : dist_old;
                distances.putDouble(iter, dist);
                if (dist > worstd) {
                    worstd = dist;
                    worst = iter.getOffset();
                }
                iter.advance();
            }
            if (!LOG.isDebugging()) continue;
            LOG.debugFiner("medoids " + medoids.toString());
        }
        return medoids;
    }

    private ArrayDBIDs initialSet(DBIDs sampleSet, int k, Random random) {
        return DBIDUtil.ensureArray(DBIDUtil.randomSample(sampleSet, k, random));
    }

    private ArrayDBIDs computeM_current(DBIDs m, DBIDs m_best, DBIDs m_bad, Random random) {
        ArrayModifiableDBIDs m_list = DBIDUtil.newArray(m);
        m_list.removeDBIDs(m_best);
        DBIDArrayMIter it = m_list.iter();
        ArrayModifiableDBIDs m_current = DBIDUtil.newArray();
        DBIDIter iter = m_best.iter();
        while (iter.valid()) {
            if (m_bad.contains(iter)) {
                int currentSize = m_current.size();
                while (m_current.size() == currentSize) {
                    m_current.add(it.seek(random.nextInt(m_list.size())));
                    it.remove();
                }
            } else {
                m_current.add(iter);
            }
            iter.advance();
        }
        return m_current;
    }

    private DataStore<DBIDs> getLocalities(DBIDs medoids, DistanceQuery<V> distFunc, RangeQuery<V> rangeQuery) {
        WritableDataStore<DBIDs> result = DataStoreUtil.makeStorage(medoids, 3, DBIDs.class);
        DBIDIter iter = medoids.iter();
        while (iter.valid()) {
            double minDist = Double.POSITIVE_INFINITY;
            DBIDIter iter2 = medoids.iter();
            while (iter2.valid()) {
                double currentDist;
                if (!DBIDUtil.equal(iter, iter2) && (currentDist = distFunc.distance((DBIDRef)iter, (DBIDRef)iter2)) < minDist) {
                    minDist = currentDist;
                }
                iter2.advance();
            }
            assert (minDist != Double.POSITIVE_INFINITY);
            result.put(iter, rangeQuery.getRangeForDBID(iter, minDist));
            iter.advance();
        }
        return result;
    }

    private long[][] findDimensions(ArrayDBIDs medoids, Relation<V> database, DistanceQuery<V> distFunc, RangeQuery<V> rangeQuery) {
        DataStore<DBIDs> localities = this.getLocalities(medoids, distFunc, rangeQuery);
        int dim = RelationUtil.dimensionality(database);
        int numc = medoids.size();
        double[][] averageDistances = new double[numc][];
        DBIDArrayIter iter = medoids.iter();
        while (iter.valid()) {
            NumberVector medoid_i = (NumberVector)database.get(iter);
            DBIDs l_i = localities.get(iter);
            double[] x_i = new double[dim];
            DBIDIter qr = l_i.iter();
            while (qr.valid()) {
                NumberVector o = (NumberVector)database.get(qr);
                for (int d = 0; d < dim; ++d) {
                    int n = d;
                    x_i[n] = x_i[n] + Math.abs(medoid_i.doubleValue(d) - o.doubleValue(d));
                }
                qr.advance();
            }
            int d = 0;
            while (d < dim) {
                int n = d++;
                x_i[n] = x_i[n] / (double)l_i.size();
            }
            averageDistances[iter.getOffset()] = x_i;
            iter.advance();
        }
        List<DoubleIntInt> z_ijs = this.computeZijs(averageDistances, dim);
        return this.computeDimensionMap(z_ijs, dim, numc);
    }

    private List<Pair<double[], long[]>> findDimensions(ArrayList<PROCLUSCluster> clusters, Relation<V> database) {
        int dim = RelationUtil.dimensionality(database);
        int numc = clusters.size();
        double[][] averageDistances = new double[numc][];
        for (int i = 0; i < numc; ++i) {
            PROCLUSCluster c_i = clusters.get(i);
            double[] x_i = new double[dim];
            DBIDMIter iter = c_i.objectIDs.iter();
            while (iter.valid()) {
                NumberVector o = (NumberVector)database.get(iter);
                for (int d = 0; d < dim; ++d) {
                    int n = d;
                    x_i[n] = x_i[n] + Math.abs(c_i.centroid[d] - o.doubleValue(d));
                }
                iter.advance();
            }
            int d = 0;
            while (d < dim) {
                int n = d++;
                x_i[n] = x_i[n] / (double)c_i.objectIDs.size();
            }
            averageDistances[i] = x_i;
        }
        List<DoubleIntInt> z_ijs = this.computeZijs(averageDistances, dim);
        long[][] dimensionMap = this.computeDimensionMap(z_ijs, dim, numc);
        ArrayList<Pair<double[], long[]>> result = new ArrayList<Pair<double[], long[]>>(numc);
        for (int i = 0; i < numc; ++i) {
            long[] dims_i = dimensionMap[i];
            if (dims_i == null) continue;
            result.add(new Pair<double[], long[]>(clusters.get((int)i).centroid, dims_i));
        }
        return result;
    }

    private List<DoubleIntInt> computeZijs(double[][] averageDistances, int dim) {
        ArrayList<DoubleIntInt> z_ijs = new ArrayList<DoubleIntInt>(averageDistances.length * dim);
        for (int i = 0; i < averageDistances.length; ++i) {
            int j;
            double[] x_i = averageDistances[i];
            double y_i = 0.0;
            for (int j2 = 0; j2 < dim; ++j2) {
                y_i += x_i[j2];
            }
            y_i /= (double)dim;
            double sigma_i = 0.0;
            for (j = 0; j < dim; ++j) {
                double diff = x_i[j] - y_i;
                sigma_i += diff * diff;
            }
            sigma_i /= (double)(dim - 1);
            sigma_i = FastMath.sqrt(sigma_i);
            for (j = 0; j < dim; ++j) {
                z_ijs.add(new DoubleIntInt((x_i[j] - y_i) / sigma_i, i, j));
            }
        }
        Collections.sort(z_ijs);
        return z_ijs;
    }

    private long[][] computeDimensionMap(List<DoubleIntInt> z_ijs, int dim, int numc) {
        long[][] dimensionMap = new long[numc][(dim - 1 >> 6) + 1];
        int max = Math.max(this.k * this.l, 2);
        for (int m = 0; m < max; ++m) {
            DoubleIntInt z_ij = z_ijs.get(m);
            long[] dims_i = dimensionMap[z_ij.dimi];
            BitsUtil.setI(dims_i, z_ij.dimj);
            if (!LOG.isDebugging()) continue;
            LOG.debugFiner("z_ij " + z_ij + '\n' + "D_i " + BitsUtil.toString(dims_i));
        }
        return dimensionMap;
    }

    private ArrayList<PROCLUSCluster> assignPoints(ArrayDBIDs m_current, long[][] dimensions, Relation<V> database) {
        ModifiableDBIDs[] clusterIDs = new ModifiableDBIDs[dimensions.length];
        for (int i = 0; i < m_current.size(); ++i) {
            clusterIDs[i] = DBIDUtil.newHashSet();
        }
        DBIDArrayIter m_i = m_current.iter();
        DBIDIter it = database.iterDBIDs();
        while (it.valid()) {
            NumberVector p = (NumberVector)database.get(it);
            double minDist = Double.NaN;
            int best = -1;
            int i = 0;
            m_i.seek(0);
            while (m_i.valid()) {
                NumberVector m = (NumberVector)database.get(m_i);
                double currentDist = this.manhattanSegmentalDistance(p, m, dimensions[i]);
                if (!(minDist <= currentDist)) {
                    minDist = currentDist;
                    best = i;
                }
                m_i.advance();
                ++i;
            }
            assert (best >= 0);
            clusterIDs[best].add(it);
            it.advance();
        }
        ArrayList<PROCLUSCluster> clusters = new ArrayList<PROCLUSCluster>(m_current.size());
        for (int i = 0; i < dimensions.length; ++i) {
            ModifiableDBIDs objectIDs = clusterIDs[i];
            if (!objectIDs.isEmpty()) {
                long[] clusterDimensions = dimensions[i];
                double[] centroid = Centroid.make(database, objectIDs).getArrayRef();
                clusters.add(new PROCLUSCluster(objectIDs, clusterDimensions, centroid));
                continue;
            }
            clusters.add(null);
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("clusters " + clusters);
        }
        return clusters;
    }

    private List<PROCLUSCluster> finalAssignment(List<Pair<double[], long[]>> dimensions, Relation<V> database) {
        HashMap<Integer, HashSetModifiableDBIDs> clusterIDs = new HashMap<Integer, HashSetModifiableDBIDs>();
        for (int i = 0; i < dimensions.size(); ++i) {
            clusterIDs.put(i, DBIDUtil.newHashSet());
        }
        DBIDIter it = database.iterDBIDs();
        while (it.valid()) {
            NumberVector p = (NumberVector)database.get(it);
            double minDist = Double.POSITIVE_INFINITY;
            int best = -1;
            for (int i = 0; i < dimensions.size(); ++i) {
                Pair<double[], long[]> pair_i = dimensions.get(i);
                double currentDist = this.manhattanSegmentalDistance(p, (double[])pair_i.first, (long[])pair_i.second);
                if (best >= 0 && !(currentDist < minDist)) continue;
                minDist = currentDist;
                best = i;
            }
            assert (minDist >= 0.0);
            ((ModifiableDBIDs)clusterIDs.get(best)).add(it);
            it.advance();
        }
        ArrayList<PROCLUSCluster> clusters = new ArrayList<PROCLUSCluster>();
        for (int i = 0; i < dimensions.size(); ++i) {
            ModifiableDBIDs objectIDs = (ModifiableDBIDs)clusterIDs.get(i);
            if (objectIDs.isEmpty()) continue;
            long[] clusterDimensions = (long[])dimensions.get((int)i).second;
            double[] centroid = Centroid.make(database, objectIDs).getArrayRef();
            clusters.add(new PROCLUSCluster(objectIDs, clusterDimensions, centroid));
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("clusters " + clusters);
        }
        return clusters;
    }

    private double manhattanSegmentalDistance(NumberVector o1, NumberVector o2, long[] dimensions) {
        double result = 0.0;
        int card = 0;
        int d = BitsUtil.nextSetBit(dimensions, 0);
        while (d >= 0) {
            result += Math.abs(o1.doubleValue(d) - o2.doubleValue(d));
            ++card;
            d = BitsUtil.nextSetBit(dimensions, d + 1);
        }
        return result / (double)card;
    }

    private double manhattanSegmentalDistance(NumberVector o1, double[] o2, long[] dimensions) {
        double result = 0.0;
        int card = 0;
        int d = BitsUtil.nextSetBit(dimensions, 0);
        while (d >= 0) {
            result += Math.abs(o1.doubleValue(d) - o2[d]);
            ++card;
            d = BitsUtil.nextSetBit(dimensions, d + 1);
        }
        return result / (double)card;
    }

    private double evaluateClusters(ArrayList<PROCLUSCluster> clusters, long[][] dimensions, Relation<V> database) {
        double result = 0.0;
        for (int i = 0; i < dimensions.length; ++i) {
            PROCLUSCluster c_i = clusters.get(i);
            double[] centroid_i = c_i.centroid;
            long[] dims_i = dimensions[i];
            double w_i = 0.0;
            int d = BitsUtil.nextSetBit(dims_i, 0);
            while (d >= 0) {
                w_i += this.avgDistance(centroid_i, c_i.objectIDs, database, d);
                d = BitsUtil.nextSetBit(dims_i, d + 1);
            }
            result += (double)c_i.objectIDs.size() * (w_i /= (double)dimensions.length);
        }
        return result / (double)database.size();
    }

    private double avgDistance(double[] centroid, DBIDs objectIDs, Relation<V> database, int dimension) {
        Mean avg = new Mean();
        DBIDIter iter = objectIDs.iter();
        while (iter.valid()) {
            NumberVector o = (NumberVector)database.get(iter);
            avg.put(Math.abs(centroid[dimension] - o.doubleValue(dimension)));
            iter.advance();
        }
        return avg.getMean();
    }

    private DBIDs computeBadMedoids(ArrayDBIDs m_current, ArrayList<PROCLUSCluster> clusters, int threshold) {
        HashSetModifiableDBIDs badMedoids = DBIDUtil.newHashSet(m_current.size());
        int i = 0;
        DBIDArrayIter it = m_current.iter();
        while (it.valid()) {
            PROCLUSCluster c_i = clusters.get(i);
            if (c_i == null || c_i.objectIDs.size() < threshold) {
                badMedoids.add(it);
            }
            it.advance();
            ++i;
        }
        return badMedoids;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractProjectedClustering.Parameterizer {
        public static final OptionID M_I_ID = new OptionID("proclus.mi", "The multiplier for the initial number of medoids.");
        public static final OptionID SEED_ID = new OptionID("proclus.seed", "The random number generator seed.");
        protected int m_i = -1;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            IntParameter m_iP;
            IntParameter lP;
            IntParameter k_iP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = (Integer)kP.getValue();
            }
            if (config.grab(k_iP = (IntParameter)new IntParameter(K_I_ID, 30).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.k_i = (Integer)k_iP.getValue();
            }
            if (config.grab(lP = (IntParameter)new IntParameter(L_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.l = (Integer)lP.getValue();
            }
            if (config.grab(m_iP = (IntParameter)new IntParameter(M_I_ID, 10).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.m_i = (Integer)m_iP.getValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected PROCLUS<V> makeInstance() {
            return new PROCLUS(this.k, this.k_i, this.l, this.m_i, this.rnd);
        }
    }

    private static class PROCLUSCluster {
        ModifiableDBIDs objectIDs;
        long[] dimensions;
        double[] centroid;

        public PROCLUSCluster(ModifiableDBIDs objectIDs, long[] dimensions, double[] centroid) {
            this.objectIDs = objectIDs;
            this.dimensions = dimensions;
            this.centroid = centroid;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(500).append("Dimensions: [");
            boolean notFirst = false;
            int d = BitsUtil.nextSetBit(this.dimensions, 0);
            while (d >= 0) {
                if (notFirst) {
                    result.append(',');
                }
                notFirst = true;
                result.append(d);
                d = BitsUtil.nextSetBit(this.dimensions, d + 1);
            }
            return FormatUtil.formatTo(result.append("]\nCentroid: "), this.centroid, ",").toString();
        }

        public long[] getDimensions() {
            return this.dimensions;
        }
    }

    private static class DoubleIntInt
    implements Comparable<DoubleIntInt> {
        protected double first;
        protected int dimi;
        protected int dimj;

        public DoubleIntInt(double first, int second, int third) {
            this.first = first;
            this.dimi = second;
            this.dimj = third;
        }

        @Override
        public int compareTo(DoubleIntInt o) {
            return this.first < o.first ? -1 : (this.first > o.first ? 1 : 0);
        }
    }
}

