/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConNeighborPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="PreDeCon: Subspace Preference weighted Density Connected Clustering")
@Description(value="PreDeCon computes clusters of subspace preference weighted connected points. The algorithm searches for local subgroups of a set of feature vectors having a low variance along one or more (but not all) attributes.")
@Reference(authors="Christian B\u00f6hm, Karin Kailing, Hans-Peter Kriegel, Peer Kr\u00f6ger", title="Density Connected Clustering with Local Subspace Preferences", booktitle="Proc. 4th IEEE Int. Conf. on Data Mining (ICDM'04)", url="https://doi.org/10.1109/ICDM.2004.10087", bibkey="DBLP:conf/icdm/BohmKKK04")
public class PreDeCon<V extends NumberVector>
extends GeneralizedDBSCAN {
    private static final Logging LOG = Logging.getLogger(PreDeCon.class);

    public PreDeCon(Settings settings) {
        super(new PreDeConNeighborPredicate(settings), new PreDeConCorePredicate(settings), false);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            this.settings = config.tryInstantiate(Settings.class);
        }

        @Override
        protected PreDeCon<V> makeInstance() {
            return new PreDeCon(this.settings);
        }
    }

    public static class Settings {
        public double epsilon;
        public double delta;
        public double kappa = 20.0;
        public int minpts;
        public int lambda = Integer.MAX_VALUE;

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final OptionID DELTA_ID = new OptionID("predecon.delta", "A double specifying the variance threshold for small Eigenvalues.");
            public static final OptionID KAPPA_ID = new OptionID("predecon.kappa", "Penalty factor for deviations in preferred (low-variance) dimensions.");
            public static final double KAPPA_DEFAULT = 20.0;
            public static final OptionID LAMBDA_ID = new OptionID("predecon.lambda", "Maximum dimensionality to consider for core points.");
            Settings settings;

            @Override
            public void makeOptions(Parameterization config) {
                this.settings = new Settings();
                this.configEpsilon(config);
                this.configMinPts(config);
                this.configDelta(config);
                this.configKappa(config);
                this.configLambda(config);
            }

            protected void configEpsilon(Parameterization config) {
                DoubleParameter epsilonP = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (config.grab(epsilonP)) {
                    this.settings.epsilon = epsilonP.doubleValue();
                }
            }

            protected void configMinPts(Parameterization config) {
                IntParameter minptsP = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab(minptsP)) {
                    this.settings.minpts = minptsP.intValue();
                }
            }

            protected void configDelta(Parameterization config) {
                DoubleParameter deltaP = (DoubleParameter)new DoubleParameter(DELTA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
                if (config.grab(deltaP)) {
                    this.settings.delta = deltaP.doubleValue();
                }
            }

            protected void configKappa(Parameterization config) {
                DoubleParameter kappaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(KAPPA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_DOUBLE)).setDefaultValue((Object)20.0);
                if (config.grab(kappaP)) {
                    this.settings.kappa = kappaP.doubleValue();
                }
            }

            protected void configLambda(Parameterization config) {
                IntParameter lambdaP = (IntParameter)((IntParameter)new IntParameter(LAMBDA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true);
                if (config.grab(lambdaP)) {
                    this.settings.lambda = lambdaP.intValue();
                }
            }

            @Override
            public Settings makeInstance() {
                return this.settings;
            }
        }
    }
}

