/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import java.util.Arrays;

public class CLIQUEUnit {
    private int[] dims;
    private double[] bounds;
    private ModifiableDBIDs ids;
    private boolean assigned;

    private CLIQUEUnit(CLIQUEUnit prefix, int newdim, double min, double max, ModifiableDBIDs ids) {
        int dimensionality = prefix.dims.length + 1;
        this.dims = Arrays.copyOf(prefix.dims, dimensionality);
        this.dims[dimensionality - 1] = newdim;
        this.bounds = Arrays.copyOf(prefix.bounds, dimensionality << 1);
        this.bounds[dimensionality - 1 << 1] = min;
        this.bounds[(dimensionality << 1) - 1] = max;
        this.ids = ids;
        this.assigned = false;
    }

    public CLIQUEUnit(int dim, double min, double max) {
        this.dims = new int[]{dim};
        this.bounds = new double[]{min, max};
        this.ids = DBIDUtil.newHashSet();
        this.assigned = false;
    }

    public int dimensionality() {
        return this.dims.length;
    }

    public int getDimension(int i) {
        return this.dims[i];
    }

    public boolean contains(NumberVector vector) {
        for (int i = 0; i < this.dims.length; ++i) {
            double value = vector.doubleValue(this.dims[i]);
            if (!(this.bounds[i << 1] > value) && !(value >= this.bounds[(i << 1) + 1])) continue;
            return false;
        }
        return true;
    }

    public boolean addFeatureVector(DBIDRef id, NumberVector vector) {
        if (this.contains(vector)) {
            this.ids.add(id);
            return true;
        }
        return false;
    }

    public int numberOfFeatureVectors() {
        return this.ids.size();
    }

    public double selectivity(double total) {
        return (double)this.ids.size() / total;
    }

    protected boolean containsLeftNeighbor(CLIQUEUnit unit, int d) {
        int e = this.dims.length - 1;
        return this.checkDimensions(unit, e) && this.bounds[(e << 1) + 1] == unit.bounds[e << 1];
    }

    protected boolean containsRightNeighbor(CLIQUEUnit unit, int d) {
        int e = this.dims.length - 1;
        return this.checkDimensions(unit, e) && this.bounds[e << 1] == unit.bounds[(e << 1) + 1];
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    public void markAsAssigned() {
        this.assigned = true;
    }

    public DBIDs getIds() {
        return this.ids;
    }

    protected CLIQUEUnit join(CLIQUEUnit other, double all, double tau) {
        if (other.dimensionality() != this.dimensionality()) {
            return null;
        }
        int e = this.dims.length - 1;
        if (!this.checkDimensions(other, e)) {
            return null;
        }
        if (this.dims[e] >= other.dims[e]) {
            return null;
        }
        HashSetModifiableDBIDs resultIDs = DBIDUtil.newHashSet(this.ids);
        resultIDs.retainAll(other.ids);
        if ((double)resultIDs.size() / all < tau) {
            return null;
        }
        return new CLIQUEUnit(this, other.dims[e], other.bounds[e << 1], other.bounds[(e << 1) + 1], resultIDs);
    }

    private boolean checkDimensions(CLIQUEUnit other, int e) {
        int i = 0;
        int j = 0;
        while (i < e) {
            if (this.dims[i] != other.dims[i] || this.bounds[j] != other.bounds[j] || this.bounds[j + 1] != this.bounds[j + 1]) {
                return false;
            }
            ++i;
            j += 2;
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.dims.length * 100);
        for (int i = 0; i < this.dims.length; ++i) {
            result.append('d').append(this.dims[i]).append(":[").append(FormatUtil.NF4.format(this.bounds[i << 1])).append("; ").append(FormatUtil.NF4.format(this.bounds[(i << 1) + 1])).append(") ");
        }
        if (result.length() > 1) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }
}

