/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Title(value="Hierarchical clustering by label")
@Description(value="Cluster points by a (pre-assigned!) label. For comparing results with a reference clustering.")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.ByLabelHierarchicalClustering"})
@Priority(value=-105)
public class ByLabelHierarchicalClustering
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(ByLabelHierarchicalClustering.class);

    @Override
    public Clustering<Model> run(Database database) {
        try {
            Relation relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            return this.run(relation);
        }
        catch (NoSupportedDataTypeException e) {
            return this.run(database.getRelation(this.getInputTypeRestriction()[0], new Object[0]));
        }
    }

    public Clustering<Model> run(Relation<?> relation) {
        HashMap<String, DBIDs> labelmap = new HashMap<String, DBIDs>();
        ArrayModifiableDBIDs noiseids = DBIDUtil.newArray();
        Clustering<Model> clustering = new Clustering<Model>("By Label Hierarchical Clustering", "bylabel-clustering");
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            Object val = relation.get(iditer);
            if (val == null) {
                noiseids.add(iditer);
            } else {
                String string = val.toString();
                this.assign(labelmap, string, iditer);
            }
            iditer.advance();
        }
        ArrayList<Cluster<ClusterModel>> clusters = new ArrayList<Cluster<ClusterModel>>(labelmap.size());
        for (Map.Entry entry : labelmap.entrySet()) {
            DBIDs ids = (DBIDs)entry.getValue();
            if (ids instanceof DBID) {
                noiseids.add((DBID)ids);
                continue;
            }
            Cluster<ClusterModel> clus = new Cluster<ClusterModel>((String)entry.getKey(), ids, ClusterModel.CLUSTER);
            clusters.add(clus);
        }
        for (Cluster cluster : clusters) {
            boolean isrootcluster = true;
            for (Cluster cluster2 : clusters) {
                if (cluster2 == cluster || !cluster2.getName().startsWith(cluster.getName())) continue;
                clustering.addChildCluster(cluster2, cluster);
                if (LOG.isDebuggingFiner()) {
                    LOG.debugFiner(cluster2.getName() + " is a child of " + cluster.getName());
                }
                isrootcluster = false;
            }
            if (!isrootcluster) continue;
            clustering.addToplevelCluster(cluster);
        }
        if (noiseids.size() > 0) {
            Cluster<ClusterModel> c = new Cluster<ClusterModel>("Noise", (DBIDs)noiseids, ClusterModel.CLUSTER);
            c.setNoise(true);
            clustering.addToplevelCluster(c);
        }
        return clustering;
    }

    private void assign(HashMap<String, DBIDs> labelMap, String label, DBIDRef id) {
        if (labelMap.containsKey(label)) {
            DBIDs exist = labelMap.get(label);
            if (exist instanceof DBID) {
                HashSetModifiableDBIDs n = DBIDUtil.newHashSet();
                n.add((DBID)exist);
                n.add(id);
                labelMap.put(label, n);
            } else {
                assert (exist instanceof HashSetModifiableDBIDs);
                assert (exist.size() > 1);
                ((ModifiableDBIDs)exist).add(id);
            }
        } else {
            labelMap.put(label, DBIDUtil.deref(id));
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.GUESSED_LABEL);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

