/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorInterface;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@Title(value="Clustering by model")
@Description(value="Cluster points by a (pre-assigned!) model. For comparing results with a reference clustering.")
@Priority(value=-105)
public class ByModelClustering
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(ByModelClustering.class);
    private Pattern noisepattern = null;

    public ByModelClustering(Pattern noisepattern) {
        this.noisepattern = noisepattern;
    }

    public ByModelClustering() {
        this(null);
    }

    public Clustering<Model> run(Relation<Model> relation) {
        HashMap<Model, ModifiableDBIDs> modelMap = new HashMap<Model, ModifiableDBIDs>();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            Model model = relation.get(iditer);
            ModifiableDBIDs modelids = (ModifiableDBIDs)modelMap.get(model);
            if (modelids == null) {
                modelids = DBIDUtil.newHashSet();
                modelMap.put(model, modelids);
            }
            modelids.add(iditer);
            iditer.advance();
        }
        Clustering<Model> result = new Clustering<Model>("By Model Clustering", "bymodel-clustering");
        for (Map.Entry entry : modelMap.entrySet()) {
            Model model = (Model)entry.getKey();
            ModifiableDBIDs ids = (ModifiableDBIDs)entry.getValue();
            String name = model instanceof GeneratorInterface ? ((GeneratorInterface)((Object)model)).getName() : model.toString();
            Cluster<Model> c = new Cluster<Model>(name, (DBIDs)ids, model);
            if (this.noisepattern != null && this.noisepattern.matcher(name).find()) {
                c.setNoise(true);
            }
            result.addToplevelCluster(c);
        }
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(Model.TYPE);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NOISE_ID = new OptionID("bymodel.noise", "Pattern to recognize noise models by their label.");
        protected Pattern noisepat;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            PatternParameter noisepatP = (PatternParameter)new PatternParameter(NOISE_ID).setOptional(true);
            if (config.grab(noisepatP)) {
                this.noisepat = (Pattern)noisepatP.getValue();
            }
        }

        @Override
        protected ByModelClustering makeInstance() {
            return new ByModelClustering(this.noisepat);
        }
    }
}

