/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Erich Schubert, Alexander Koos, Tobias Emrich, Andreas Z\u00fcfle, Klaus Arthur Schmid, Arthur Zimek", title="A Framework for Clustering Uncertain Data", booktitle="Proceedings of the VLDB Endowment, 8(12)", url="http://www.vldb.org/pvldb/vol8/p1976-schubert.pdf", bibkey="DBLP:journals/pvldb/SchubertKEZSZ15")
public class CenterOfMassMetaClustering<C extends Clustering<?>>
extends AbstractAlgorithm<C>
implements ClusteringAlgorithm<C> {
    private static final Logging LOG = Logging.getLogger(CenterOfMassMetaClustering.class);
    protected ClusteringAlgorithm<C> inner;

    public CenterOfMassMetaClustering(ClusteringAlgorithm<C> inner) {
        this.inner = inner;
    }

    public C run(Database database, Relation<? extends UncertainObject> relation) {
        int dim = RelationUtil.dimensionality(relation);
        DBIDs ids = relation.getDBIDs();
        WritableDataStore<DoubleVector> store1 = DataStoreUtil.makeStorage(ids, 30, DoubleVector.class);
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            store1.put(iter, relation.get(iter).getCenterOfMass());
            iter.advance();
        }
        return this.runClusteringAlgorithm(database.getHierarchy(), relation, ids, store1, dim, "Uncertain Model: Center of Mass");
    }

    protected C runClusteringAlgorithm(ResultHierarchy hierarchy, Result parent, DBIDs ids, DataStore<DoubleVector> store, int dim, String title) {
        VectorFieldTypeInformation<DoubleVector> t = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, dim);
        MaterializedRelation<DoubleVector> sample = new MaterializedRelation<DoubleVector>(t, ids, title, store);
        ProxyDatabase d = new ProxyDatabase(ids, sample);
        Result clusterResult = this.inner.run(d);
        d.getHierarchy().remove(sample);
        d.getHierarchy().remove(clusterResult);
        hierarchy.add(parent, sample);
        hierarchy.add(sample, clusterResult);
        return (C)clusterResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(UncertainObject.UNCERTAIN_OBJECT_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<C extends Clustering<?>>
    extends AbstractParameterizer {
        protected ClusteringAlgorithm<C> inner;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter palgorithm = new ObjectParameter(AbstractAlgorithm.ALGORITHM_ID, ClusteringAlgorithm.class);
            if (config.grab(palgorithm)) {
                this.inner = (ClusteringAlgorithm)palgorithm.instantiateClass(config);
                if (this.inner != null && this.inner.getInputTypeRestriction().length > 0 && !this.inner.getInputTypeRestriction()[0].isAssignableFromType(TypeUtil.NUMBER_VECTOR_FIELD)) {
                    config.reportError(new WrongParameterValueException(palgorithm, palgorithm.getValueAsString(), "The inner clustering algorithm (as configured) does not accept numerical vectors: " + this.inner.getInputTypeRestriction()[0]));
                }
            }
        }

        @Override
        protected CenterOfMassMetaClustering<C> makeInstance() {
            return new CenterOfMassMetaClustering<C>(this.inner);
        }
    }
}

