/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain.FDBSCANNeighborPredicate;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@Title(value="FDBSCAN: Density-based Clustering of Applications with Noise on fuzzy objects")
@Description(value="Algorithm to find density-connected sets in a database consisting of uncertain/fuzzy objects based on the parameters 'minpts', 'epsilon', 'samplesize', and (if used) 'threshold'")
@Reference(authors="Hans-Peter Kriegel, Martin Pfeifle", title="Density-based clustering of uncertain data", booktitle="Proc. 11th ACM Int. Conf. on Knowledge Discovery and Data Mining (SIGKDD)", url="https://doi.org/10.1145/1081870.1081955", bibkey="DBLP:conf/kdd/KriegelP05")
public class FDBSCAN
extends GeneralizedDBSCAN {
    public FDBSCAN(double epsilon, int sampleSize, double threshold, RandomFactory seed, int minpts) {
        super(new FDBSCANNeighborPredicate(epsilon, sampleSize, threshold, seed), new MinPtsCorePredicate(minpts), false);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double epsilon;
        protected int sampleSize;
        protected double threshold;
        protected RandomFactory seed;
        protected int minPts;

        @Override
        public void makeOptions(Parameterization config) {
            RandomParameter seedp;
            DoubleParameter thresholdp;
            IntParameter sampleSizep;
            IntParameter minPtsP;
            super.makeOptions(config);
            DoubleParameter epsilonP = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(epsilonP)) {
                this.epsilon = epsilonP.doubleValue();
            }
            if (config.grab(minPtsP = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minPts = minPtsP.intValue();
            }
            if (config.grab(sampleSizep = (IntParameter)new IntParameter(FDBSCANNeighborPredicate.Parameterizer.SAMPLE_SIZE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.sampleSize = (Integer)sampleSizep.getValue();
            }
            if (config.grab(thresholdp = (DoubleParameter)((DoubleParameter)new DoubleParameter(FDBSCANNeighborPredicate.Parameterizer.THRESHOLD_ID, 0.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE))) {
                this.threshold = (Double)thresholdp.getValue();
            }
            if (config.grab(seedp = new RandomParameter(FDBSCANNeighborPredicate.Parameterizer.SEED_ID))) {
                this.seed = (RandomFactory)seedp.getValue();
            }
        }

        @Override
        protected FDBSCAN makeInstance() {
            return new FDBSCAN(this.epsilon, this.sampleSize, this.threshold, this.seed, this.minPts);
        }
    }
}

