/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="Hans-Peter Kriegel, Martin Pfeifle", title="Density-based clustering of uncertain data", booktitle="Proc. 11th ACM Int. Conf. on Knowledge Discovery and Data Mining (SIGKDD)", url="https://doi.org/10.1145/1081870.1081955", bibkey="DBLP:conf/kdd/KriegelP05")
public class FDBSCANNeighborPredicate
implements NeighborPredicate<DBIDs> {
    protected double epsilon;
    protected int sampleSize;
    protected double threshold;
    protected RandomFactory rand;

    public FDBSCANNeighborPredicate(double epsilon, int sampleSize, double threshold, RandomFactory seed) {
        this.epsilon = epsilon;
        this.sampleSize = sampleSize;
        this.threshold = threshold;
        this.rand = seed;
    }

    public Instance instantiate(Database database) {
        Relation relation = database.getRelation(UncertainObject.UNCERTAIN_OBJECT_FIELD, new Object[0]);
        return new Instance(this.epsilon, this.sampleSize, this.threshold, relation, this.rand);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return UncertainObject.UNCERTAIN_OBJECT_FIELD;
    }

    @Override
    public SimpleTypeInformation<DBIDs> getOutputType() {
        return TypeUtil.DBIDS;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SAMPLE_SIZE_ID = new OptionID("fdbscan.samplesize", "The number of samples to draw from each uncertain object to determine the epsilon-neighborhood.");
        public static final OptionID THRESHOLD_ID = new OptionID("fdbscan.threshold", "The amount of samples that have to be epsilon-close for two objects to be neighbors.");
        public static final OptionID SEED_ID = new OptionID("fdbscan.seed", "Random generator used to draw samples.");
        protected double epsilon;
        protected int sampleSize;
        protected double threshold;
        protected RandomFactory seed;

        @Override
        public void makeOptions(Parameterization config) {
            RandomParameter seedp;
            DoubleParameter thresholdp;
            IntParameter sampleSizep;
            super.makeOptions(config);
            DoubleParameter epsilonP = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(epsilonP)) {
                this.epsilon = epsilonP.doubleValue();
            }
            if (config.grab(sampleSizep = (IntParameter)new IntParameter(SAMPLE_SIZE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.sampleSize = sampleSizep.intValue();
            }
            if (config.grab(thresholdp = (DoubleParameter)((DoubleParameter)new DoubleParameter(THRESHOLD_ID, 0.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE))) {
                this.threshold = thresholdp.doubleValue();
            }
            if (config.grab(seedp = new RandomParameter(SEED_ID))) {
                this.seed = (RandomFactory)seedp.getValue();
            }
        }

        @Override
        protected FDBSCANNeighborPredicate makeInstance() {
            return new FDBSCANNeighborPredicate(this.epsilon, this.sampleSize, this.threshold, this.seed);
        }
    }

    public static class Instance
    implements NeighborPredicate.Instance<DBIDs> {
        private double epsilon;
        private double epsilonsq;
        private int sampleSize;
        private double threshold;
        private Relation<? extends UncertainObject> relation;
        private Random rand;

        public Instance(double epsilon, int sampleSize, double threshold, Relation<? extends UncertainObject> relation, RandomFactory rand) {
            this.epsilon = epsilon;
            this.epsilonsq = epsilon * epsilon;
            this.sampleSize = sampleSize;
            this.threshold = threshold;
            this.relation = relation;
            this.rand = rand.getRandom();
        }

        @Override
        public DBIDs getNeighbors(DBIDRef reference) {
            UncertainObject referenceObject = this.relation.get(reference);
            ArrayModifiableDBIDs resultList = DBIDUtil.newArray();
            DBIDIter iter = this.relation.iterDBIDs();
            while (iter.valid()) {
                block8: {
                    if (DBIDUtil.equal(reference, iter)) {
                        resultList.add(iter);
                    } else {
                        UncertainObject comparisonObject = this.relation.get(iter);
                        double mindistsq = 0.0;
                        double maxdistsq = 0.0;
                        for (int d = 0; d < referenceObject.getDimensionality(); ++d) {
                            double mindelta;
                            double rmin = referenceObject.getMin(d);
                            double rmax = referenceObject.getMax(d);
                            double cmin = comparisonObject.getMin(d);
                            double cmax = comparisonObject.getMax(d);
                            double d2 = cmin > rmax ? cmin - rmax : (mindelta = rmin > cmax ? rmin - cmax : 0.0);
                            if (!(mindelta > this.epsilon) && !((mindistsq += mindelta * mindelta) > this.epsilonsq)) {
                                double m2;
                                double m1 = Math.abs(rmin - cmax);
                                double maxdelta = m1 > (m2 = Math.abs(cmin - rmax)) ? m1 : m2;
                                maxdistsq += maxdelta * maxdelta;
                                continue;
                            }
                            break block8;
                        }
                        if (maxdistsq <= this.epsilonsq) {
                            resultList.add(iter);
                        } else if (this.checkSamples(referenceObject, comparisonObject)) {
                            resultList.add(iter);
                        }
                    }
                }
                iter.advance();
            }
            return resultList;
        }

        private boolean checkSamples(UncertainObject o1, UncertainObject o2) {
            SquaredEuclideanDistanceFunction distance = SquaredEuclideanDistanceFunction.STATIC;
            if (o1 instanceof DiscreteUncertainObject && o2 instanceof DiscreteUncertainObject) {
                DiscreteUncertainObject d1 = (DiscreteUncertainObject)o1;
                DiscreteUncertainObject d2 = (DiscreteUncertainObject)o2;
                int l1 = d1.getNumberSamples();
                int l2 = d2.getNumberSamples();
                double limit = this.threshold * (double)l1 * (double)l2;
                int count = 0;
                for (int i = 0; i < l1; ++i) {
                    DoubleVector s1 = d1.getSample(i);
                    for (int j = 0; j < l2; ++j) {
                        DoubleVector s2 = d2.getSample(j);
                        if (!(distance.distance(s2, s1) <= this.epsilonsq) || !((double)(++count) >= limit)) continue;
                        return true;
                    }
                }
                return false;
            }
            double limit = this.threshold * (double)this.sampleSize * (double)this.sampleSize;
            int count = 0;
            for (int j = 0; j < this.sampleSize; ++j) {
                DoubleVector s1 = o1.drawSample(this.rand);
                for (int i = 0; i < this.sampleSize; ++i) {
                    DoubleVector s2 = o2.drawSample(this.rand);
                    if (!(distance.distance(s2, s1) <= this.epsilonsq) || !((double)(++count) >= limit)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public DBIDs getIDs() {
            return this.relation.getDBIDs();
        }

        @Override
        public DBIDIter iterDBIDs(DBIDs neighbors) {
            return neighbors.iter();
        }
    }
}

