/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.AbstractFrequentItemsetAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.DenseItemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.OneItemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.SparseItemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.SparseFeatureVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.InconsistentDataException;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jafama.FastMath;

@Title(value="APRIORI: Algorithm for Mining Association Rules")
@Description(value="Searches for frequent itemsets")
@Reference(authors="R. Agrawal, R. Srikant", title="Fast Algorithms for Mining Association Rules", booktitle="Proc. 20th Int. Conf. on Very Large Data Bases (VLDB '94)", url="http://www.vldb.org/conf/1994/P487.PDF", bibkey="DBLP:conf/vldb/AgrawalS94")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.APRIORI"})
public class APRIORI
extends AbstractFrequentItemsetAlgorithm {
    private static final Logging LOG = Logging.getLogger(APRIORI.class);
    private final String STAT = this.getClass().getName() + ".";

    public APRIORI(double minfreq, int minlength, int maxlength) {
        super(minfreq, minlength, maxlength);
    }

    public APRIORI(double minfreq) {
        super(minfreq);
    }

    public FrequentItemsetsResult run(Relation<BitVector> relation) {
        DBIDs ids = relation.getDBIDs();
        ArrayList<Itemset> solution = new ArrayList<Itemset>();
        int size = ids.size();
        int needed = this.getMinimumSupport(size);
        VectorFieldTypeInformation<BitVector> meta = RelationUtil.assumeVectorField(relation);
        if (size > 0) {
            int dim = meta.getDimensionality();
            Duration timeone = LOG.newDuration(this.STAT + "1-items.time").begin();
            List<OneItemset> oneitems = this.buildFrequentOneItemsets(relation, dim, needed);
            LOG.statistics(timeone.end());
            if (LOG.isStatistics()) {
                LOG.statistics(new LongStatistic(this.STAT + "1-items.frequent", oneitems.size()));
                LOG.statistics(new LongStatistic(this.STAT + "1-items.transactions", ids.size()));
            }
            if (LOG.isDebuggingFine()) {
                LOG.debugFine(this.debugDumpCandidates(new StringBuilder(), oneitems, meta));
            }
            if (this.minlength <= 1) {
                solution.addAll(oneitems);
            }
            if (oneitems.size() >= 2 && this.maxlength >= 2) {
                Duration timetwo = LOG.newDuration(this.STAT + "2-items.time").begin();
                ArrayModifiableDBIDs survivors = DBIDUtil.newArray(ids.size());
                List<Itemset> candidates = this.buildFrequentTwoItemsets(oneitems, relation, dim, needed, ids, survivors);
                ids = survivors;
                LOG.statistics(timetwo.end());
                if (LOG.isStatistics()) {
                    LOG.statistics(new LongStatistic(this.STAT + "2-items.frequent", candidates.size()));
                    LOG.statistics(new LongStatistic(this.STAT + "2-items.transactions", ids.size()));
                }
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine(this.debugDumpCandidates(new StringBuilder(), candidates, meta));
                }
                if (this.minlength <= 2) {
                    solution.addAll(candidates);
                }
                for (int length = 3; length <= this.maxlength && candidates.size() >= length; ++length) {
                    Duration timel = LOG.newDuration(this.STAT + length + "-items.time").begin();
                    candidates = this.aprioriGenerate(candidates, length, dim);
                    if (LOG.isDebuggingFinest()) {
                        LOG.debugFinest(this.debugDumpCandidates(new StringBuilder().append("Before pruning: "), candidates, meta));
                    }
                    survivors = DBIDUtil.newArray(ids.size());
                    candidates = this.frequentItemsets(candidates, relation, needed, ids, survivors, length);
                    ids = survivors;
                    LOG.statistics(timel.end());
                    if (LOG.isStatistics()) {
                        LOG.statistics(new LongStatistic(this.STAT + length + "-items.frequent", candidates.size()));
                        LOG.statistics(new LongStatistic(this.STAT + length + "-items.transactions", ids.size()));
                    }
                    if (LOG.isDebuggingFine()) {
                        LOG.debugFine(this.debugDumpCandidates(new StringBuilder(), candidates, meta));
                    }
                    solution.addAll(candidates);
                }
            }
        }
        return new FrequentItemsetsResult("APRIORI", "apriori", solution, meta, size);
    }

    protected List<OneItemset> buildFrequentOneItemsets(Relation<? extends SparseFeatureVector<?>> relation, int dim, int needed) {
        int[] counts = new int[dim];
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            SparseFeatureVector<?> bv = relation.get(iditer);
            int it = bv.iter();
            while (bv.iterValid(it)) {
                int n = bv.iterDim(it);
                counts[n] = counts[n] + 1;
                it = bv.iterAdvance(it);
            }
            iditer.advance();
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.STAT + "1-items.candidates", dim));
        }
        ArrayList<OneItemset> frequent = new ArrayList<OneItemset>(dim);
        for (int i = 0; i < dim; ++i) {
            if (counts[i] < needed) continue;
            frequent.add(new OneItemset(i, counts[i]));
        }
        return frequent;
    }

    protected List<SparseItemset> buildFrequentTwoItemsets(List<OneItemset> oneitems, Relation<BitVector> relation, int dim, int needed, DBIDs ids, ArrayModifiableDBIDs survivors) {
        int f1 = 0;
        long[] mask = BitsUtil.zero(dim);
        for (OneItemset supported : oneitems) {
            BitsUtil.setI(mask, supported.item);
            ++f1;
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.STAT + "2-items.candidates", (long)f1 * (long)(f1 - 1)));
        }
        Long2IntOpenHashMap map = new Long2IntOpenHashMap(f1 * (f1 - 1) >>> 1);
        long[] scratch = BitsUtil.zero(dim);
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            BitsUtil.setI(scratch, mask);
            relation.get(iditer).andOnto(scratch);
            int lives = 0;
            int i = BitsUtil.nextSetBit(scratch, 0);
            while (i >= 0) {
                int j = BitsUtil.nextSetBit(scratch, i + 1);
                while (j >= 0) {
                    long key = (long)i << 32 | (long)j;
                    map.put(key, 1 + map.get(key));
                    ++lives;
                    j = BitsUtil.nextSetBit(scratch, j + 1);
                }
                i = BitsUtil.nextSetBit(scratch, i + 1);
            }
            if (lives > 2) {
                survivors.add(iditer);
            }
            iditer.advance();
        }
        ArrayList<SparseItemset> frequent = new ArrayList<SparseItemset>(f1 * (int)FastMath.sqrt(f1));
        ObjectIterator<Long2IntMap.Entry> iter = map.long2IntEntrySet().fastIterator();
        while (iter.hasNext()) {
            Long2IntMap.Entry entry = (Long2IntMap.Entry)iter.next();
            if (entry.getIntValue() < needed) continue;
            int ii = (int)(entry.getLongKey() >>> 32);
            int ij = (int)(entry.getLongKey() & 0xFFFFFFFFFFFFFFFFL);
            frequent.add(new SparseItemset(new int[]{ii, ij}, entry.getIntValue()));
        }
        Collections.sort(frequent);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.STAT + "2-items.frequent", frequent.size()));
        }
        return frequent;
    }

    protected List<Itemset> aprioriGenerate(List<? extends Itemset> supported, int length, int dim) {
        if (supported.size() < length) {
            return Collections.emptyList();
        }
        long joined = 0L;
        int ssize = supported.size();
        ArrayList<Itemset> candidateList = new ArrayList<Itemset>();
        Itemset ref = supported.get(0);
        if (ref instanceof SparseItemset) {
            SparseItemset scratch = new SparseItemset(new int[length - 1]);
            for (int i = 0; i < ssize; ++i) {
                SparseItemset ij;
                SparseItemset ii = (SparseItemset)supported.get(i);
                block1: for (int j = i + 1; j < ssize && ii.prefixTest(ij = (SparseItemset)supported.get(j)); ++j) {
                    ++joined;
                    System.arraycopy(ii.indices, 1, scratch.indices, 0, length - 2);
                    scratch.indices[length - 2] = ij.indices[length - 2];
                    for (int k = length - 3; k >= 0; --k) {
                        scratch.indices[k] = ii.indices[k + 1];
                        int pos = Collections.binarySearch(supported, scratch);
                        if (pos < 0) continue block1;
                    }
                    int[] items = new int[length];
                    System.arraycopy(ii.indices, 0, items, 0, length - 1);
                    items[length - 1] = ij.indices[length - 2];
                    candidateList.add(new SparseItemset(items));
                }
            }
        } else if (ref instanceof DenseItemset) {
            DenseItemset scratch = new DenseItemset(BitsUtil.zero(dim), length - 1);
            block3: for (int i = 0; i < ssize; ++i) {
                DenseItemset ii = (DenseItemset)supported.get(i);
                block4: for (int j = i + 1; j < ssize; ++j) {
                    DenseItemset ij = (DenseItemset)supported.get(j);
                    System.arraycopy(ii.items, 0, scratch.items, 0, ii.items.length);
                    BitsUtil.xorI(scratch.items, ij.items);
                    if (BitsUtil.cardinality(scratch.items) != 2) continue block3;
                    ++joined;
                    int first = BitsUtil.nextSetBit(scratch.items, 0);
                    if (BitsUtil.nextSetBit(ii.items, first + 1) > -1) continue block3;
                    BitsUtil.orI(scratch.items, ij.items);
                    int b = BitsUtil.nextSetBit(scratch.items, 0);
                    for (int l = length; l > 2; --l) {
                        BitsUtil.clearI(scratch.items, b);
                        int pos = Collections.binarySearch(supported, scratch);
                        if (pos < 0) continue block4;
                        BitsUtil.setI(scratch.items, b);
                        b = BitsUtil.nextSetBit(scratch.items, b + 1);
                    }
                    candidateList.add(new DenseItemset((long[])scratch.items.clone(), length));
                }
            }
        } else {
            throw new InconsistentDataException("Unexpected itemset type " + ref.getClass());
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.STAT + length + "-items.pairwise", (long)ssize * ((long)ssize - 1L)));
            LOG.statistics(new LongStatistic(this.STAT + length + "-items.joined", joined));
            LOG.statistics(new LongStatistic(this.STAT + length + "-items.candidates", candidateList.size()));
        }
        return candidateList;
    }

    protected List<? extends Itemset> frequentItemsets(List<? extends Itemset> candidates, Relation<BitVector> relation, int needed, DBIDs ids, ArrayModifiableDBIDs survivors, int length) {
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        Itemset first = candidates.get(0);
        if (candidates.size() > length * length * length * 100 && first instanceof SparseItemset) {
            List<? extends Itemset> sparsecand = candidates;
            return this.frequentItemsetsSparse(sparsecand, relation, needed, ids, survivors, length);
        }
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            BitVector bv = relation.get(iditer);
            int n = 0;
            for (Itemset itemset : candidates) {
                if (!itemset.containedIn(bv)) continue;
                itemset.increaseSupport();
                ++n;
            }
            if (n > length) {
                survivors.add(iditer);
            }
            iditer.advance();
        }
        ArrayList<Itemset> frequent = new ArrayList<Itemset>(candidates.size());
        for (Itemset itemset : candidates) {
            if (itemset.getSupport() < needed) continue;
            frequent.add(itemset);
        }
        return frequent;
    }

    protected List<SparseItemset> frequentItemsetsSparse(List<SparseItemset> candidates, Relation<BitVector> relation, int needed, DBIDs ids, ArrayModifiableDBIDs survivors, int length) {
        int begin = 0;
        int end = candidates.size();
        int[] scratchi = new int[length];
        int[] iters = new int[length];
        SparseItemset scratch = new SparseItemset(scratchi);
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            BitVector bv = relation.get(iditer);
            if (this.initializeSearchItemset(bv, scratchi, iters)) {
                int lives = 0;
                while (begin < end) {
                    if ((begin = this.binarySearch(candidates, scratch, begin, end)) > 0) {
                        candidates.get(begin).increaseSupport();
                        ++lives;
                    } else {
                        begin = -begin - 1;
                    }
                    if (begin < end && this.nextSearchItemset(bv, scratchi, iters)) continue;
                }
                for (Itemset itemset : candidates) {
                    if (!itemset.containedIn(bv)) continue;
                    itemset.increaseSupport();
                    ++lives;
                }
                if (lives > length) {
                    survivors.add(iditer);
                }
            }
            iditer.advance();
        }
        ArrayList<SparseItemset> frequent = new ArrayList<SparseItemset>(candidates.size());
        for (SparseItemset candidate : candidates) {
            if (candidate.getSupport() < needed) continue;
            frequent.add(candidate);
        }
        return frequent;
    }

    private boolean initializeSearchItemset(BitVector bv, int[] scratchi, int[] iters) {
        for (int i = 0; i < scratchi.length; ++i) {
            int n = iters[i] = i == 0 ? bv.iter() : bv.iterAdvance(iters[i - 1]);
            if (iters[i] < 0) {
                return false;
            }
            scratchi[i] = bv.iterDim(iters[i]);
        }
        return true;
    }

    private boolean nextSearchItemset(BitVector bv, int[] scratchi, int[] iters) {
        int last;
        for (int j = last = scratchi.length - 1; j >= 0; --j) {
            int n = bv.iterAdvance(iters[j]);
            if (n < 0 || j != last && n == iters[j + 1]) continue;
            iters[j] = n;
            scratchi[j] = bv.iterDim(n);
            return true;
        }
        return false;
    }

    private int binarySearch(List<SparseItemset> candidates, SparseItemset scratch, int begin, int end) {
        --end;
        while (begin < end) {
            int mid = begin + end >>> 1;
            SparseItemset midVal = candidates.get(mid);
            int cmp = midVal.compareTo(scratch);
            if (cmp < 0) {
                begin = mid + 1;
                continue;
            }
            if (cmp > 0) {
                end = mid - 1;
                continue;
            }
            return mid;
        }
        return -(begin + 1);
    }

    private StringBuilder debugDumpCandidates(StringBuilder msg, List<? extends Itemset> candidates, VectorFieldTypeInformation<BitVector> meta) {
        msg.append(':');
        for (Itemset itemset : candidates) {
            msg.append(" [");
            itemset.appendTo(msg, meta);
            msg.append(']');
        }
        return msg;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.BIT_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractFrequentItemsetAlgorithm.Parameterizer {
        @Override
        protected APRIORI makeInstance() {
            return new APRIORI(this.minsupp, this.minlength, this.maxlength);
        }
    }
}

