/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public abstract class AbstractFrequentItemsetAlgorithm
extends AbstractAlgorithm<FrequentItemsetsResult> {
    private double minsupp;
    protected int minlength = 0;
    protected int maxlength = Integer.MAX_VALUE;

    public AbstractFrequentItemsetAlgorithm(double minsupp, int minlength, int maxlength) {
        this.minsupp = minsupp;
        this.minlength = minlength;
        this.maxlength = maxlength > 0 ? maxlength : Integer.MAX_VALUE;
    }

    public AbstractFrequentItemsetAlgorithm(double minsupp) {
        this(minsupp, 0, Integer.MAX_VALUE);
    }

    public int getMinimumSupport(int size) {
        return (int)(this.minsupp < 1.0 ? Math.ceil(this.minsupp * (double)size) : this.minsupp);
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MINSUPP_ID = new OptionID("itemsetmining.minsupp", "Threshold for minimum support as minimally required number of transactions (if > 1) or the minimum frequency (if <= 1).");
        public static final OptionID MINLENGTH_ID = new OptionID("itemsetmining.minlength", "Minimum length of frequent itemsets to report. This can help to reduce the output size to only the most interesting patterns.");
        public static final OptionID MAXLENGTH_ID = new OptionID("itemsetmining.maxlength", "Maximum length of frequent itemsets to report. This can help to reduce the output size to only the most interesting patterns.");
        protected double minsupp;
        protected int minlength = 0;
        protected int maxlength = Integer.MAX_VALUE;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter maxlengthP;
            IntParameter minlengthP;
            super.makeOptions(config);
            DoubleParameter minsuppP = (DoubleParameter)new DoubleParameter(MINSUPP_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(minsuppP)) {
                this.minsupp = (Double)minsuppP.getValue();
            }
            if (config.grab(minlengthP = (IntParameter)((IntParameter)new IntParameter(MINLENGTH_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minlength = (Integer)minlengthP.getValue();
            }
            if (config.grab(maxlengthP = (IntParameter)((IntParameter)new IntParameter(MAXLENGTH_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.maxlength = (Integer)maxlengthP.getValue();
            }
        }
    }
}

