/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.APIViolationException;

public class DenseItemset
extends Itemset {
    long[] items;
    int length;

    public DenseItemset(long[] items, int length) {
        this.items = items;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean containedIn(SparseNumberVector bv) {
        if (bv instanceof BitVector) {
            return ((BitVector)bv).contains(this.items);
        }
        return super.containedIn(bv);
    }

    @Override
    public int iter() {
        return BitsUtil.nextSetBit(this.items, 0);
    }

    @Override
    public boolean iterValid(int iter) {
        return iter >= 0;
    }

    @Override
    public int iterAdvance(int iter) {
        return BitsUtil.nextSetBit(this.items, iter + 1);
    }

    @Override
    public int iterDim(int iter) {
        return iter;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof DenseItemset && BitsUtil.equal(this.items, ((DenseItemset)obj).items) || super.equals(obj);
    }

    @Override
    @Deprecated
    public int hashCode() {
        throw new APIViolationException("Itemsets may not be used in hash maps.");
    }

    @Override
    public int compareTo(Itemset o) {
        int l2;
        int l1 = this.length();
        if (l1 < (l2 = o.length())) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        if (o instanceof DenseItemset) {
            DenseItemset other = (DenseItemset)o;
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == other.items[i]) continue;
                return -Long.compare(Long.reverse(this.items[i]), Long.reverse(other.items[i]));
            }
            return 0;
        }
        return Itemset.compareLexicographical(this, o);
    }

    @Override
    public StringBuilder appendItemsTo(StringBuilder buf, VectorFieldTypeInformation<BitVector> meta) {
        int i = BitsUtil.nextSetBit(this.items, 0);
        while (true) {
            String lbl;
            String string = lbl = meta != null ? meta.getLabel(i) : null;
            if (lbl == null) {
                buf.append(i);
            } else {
                buf.append(lbl);
            }
            i = BitsUtil.nextSetBit(this.items, i + 1);
            if (i < 0) break;
            buf.append(", ");
        }
        return buf;
    }
}

