/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.AbstractFrequentItemsetAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.OneItemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.SparseItemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.SparseFeatureVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Reference(authors="M. J. Zaki, S. Parthasarathy, M. Ogihara, W. Li", title="New Algorithms for Fast Discovery of Association Rules", booktitle="Proc. 3rd ACM SIGKDD '97 Int. Conf. on Knowledge Discovery and Data Mining", url="http://www.aaai.org/Library/KDD/1997/kdd97-060.php", bibkey="DBLP:conf/kdd/ZakiPOL97")
public class Eclat
extends AbstractFrequentItemsetAlgorithm {
    private static final Logging LOG = Logging.getLogger(Eclat.class);
    private static final String STAT = Eclat.class.getName() + ".";

    public Eclat(double minsupp, int minlength, int maxlength) {
        super(minsupp, minlength, maxlength);
    }

    public FrequentItemsetsResult run(Database db, Relation<BitVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        VectorFieldTypeInformation<BitVector> meta = RelationUtil.assumeVectorField(relation);
        int minsupp = this.getMinimumSupport(relation.size());
        LOG.verbose("Build 1-dimensional transaction lists.");
        Duration ctime = LOG.newDuration(STAT + "eclat.transposition.time").begin();
        DBIDs[] idx = this.buildIndex(relation, dim, minsupp);
        LOG.statistics(ctime.end());
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Building frequent itemsets", idx.length, LOG) : null;
        Duration etime = LOG.newDuration(STAT + "eclat.extraction.time").begin();
        ArrayList<Itemset> solution = new ArrayList<Itemset>();
        for (int i = 0; i < idx.length; ++i) {
            LOG.incrementProcessed(prog);
            this.extractItemsets(idx, i, minsupp, solution);
        }
        LOG.ensureCompleted(prog);
        Collections.sort(solution);
        LOG.statistics(etime.end());
        LOG.statistics(new LongStatistic(STAT + "frequent-itemsets", solution.size()));
        return new FrequentItemsetsResult("Eclat", "eclat", solution, meta, relation.size());
    }

    private void extractItemsets(DBIDs[] idx, int start, int minsupp, List<Itemset> solution) {
        int[] buf = new int[idx.length];
        DBIDs iset = idx[start];
        if (iset == null || iset.size() < minsupp) {
            return;
        }
        if (this.minlength <= 1) {
            solution.add(new OneItemset(start, iset.size()));
        }
        if (this.maxlength > 1) {
            buf[0] = start;
            this.extractItemsets(iset, idx, buf, 1, start + 1, minsupp, solution);
        }
    }

    private void extractItemsets(DBIDs iset, DBIDs[] idx, int[] buf, int depth, int start, int minsupp, List<Itemset> solution) {
        int depth1 = depth + 1;
        for (int i = start; i < idx.length; ++i) {
            DBIDs ids;
            if (idx[i] == null || (ids = this.mergeJoin(iset, idx[i])).size() < minsupp) continue;
            buf[depth] = i;
            int[] items = Arrays.copyOf(buf, depth1);
            if (depth1 >= this.minlength) {
                solution.add(new SparseItemset(items, ids.size()));
            }
            if (depth1 > this.maxlength) continue;
            this.extractItemsets(ids, idx, buf, depth1, i + 1, minsupp, solution);
        }
    }

    private DBIDs mergeJoin(DBIDs first, DBIDs second) {
        assert (!(first instanceof HashSetDBIDs));
        assert (!(second instanceof HashSetDBIDs));
        ArrayModifiableDBIDs ids = DBIDUtil.newArray();
        DBIDIter i1 = first.iter();
        DBIDIter i2 = second.iter();
        while (i1.valid() && i2.valid()) {
            int c = DBIDUtil.compare(i1, i2);
            if (c < 0) {
                i1.advance();
                continue;
            }
            if (c > 0) {
                i2.advance();
                continue;
            }
            ids.add(i1);
            i1.advance();
            i2.advance();
        }
        return ids;
    }

    private DBIDs[] buildIndex(Relation<BitVector> relation, int dim, int minsupp) {
        DBIDs[] idx = new ArrayModifiableDBIDs[dim];
        for (int i = 0; i < dim; ++i) {
            idx[i] = DBIDUtil.newArray();
        }
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            SparseFeatureVector bv = relation.get(iter);
            int it = bv.iter();
            while (bv.iterValid(it)) {
                idx[bv.iterDim(it)].add(iter);
                it = bv.iterAdvance(it);
            }
            iter.advance();
        }
        for (int i = 0; i < dim; ++i) {
            if (idx[i].size() < minsupp) {
                idx[i] = null;
                continue;
            }
            idx[i].sort();
        }
        return idx;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.BIT_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractFrequentItemsetAlgorithm.Parameterizer {
        @Override
        protected Eclat makeInstance() {
            return new Eclat(this.minsupp, this.minlength, this.maxlength);
        }
    }
}

