/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.APIViolationException;

public abstract class Itemset
implements Comparable<Itemset> {
    int support;

    public int increaseSupport() {
        return ++this.support;
    }

    public int getSupport() {
        return this.support;
    }

    public boolean containedIn(SparseNumberVector bv) {
        int i1 = this.iter();
        int i2 = bv.iter();
        while (this.iterValid(i1)) {
            int d2;
            if (!bv.iterValid(i2)) {
                return false;
            }
            int d1 = this.iterDim(i1);
            if (d1 < (d2 = bv.iterDim(i2))) {
                return false;
            }
            if (d1 == d2) {
                if (bv.iterDoubleValue(i2) == 0.0) {
                    return false;
                }
                i1 = this.iterAdvance(i1);
            }
            i2 = bv.iterAdvance(i2);
        }
        return true;
    }

    public abstract int length();

    public static long[] toBitset(Itemset i, long[] bits) {
        int it = i.iter();
        while (i.iterValid(it)) {
            BitsUtil.setI(bits, i.iterDim(it));
            it = i.iterAdvance(it);
        }
        return bits;
    }

    public abstract int iter();

    public abstract int iterAdvance(int var1);

    public abstract boolean iterValid(int var1);

    public abstract int iterDim(int var1);

    @Override
    public int compareTo(Itemset o) {
        int l2;
        int l1 = this.length();
        return l1 < (l2 = o.length()) ? -1 : (l1 > l2 ? 1 : Itemset.compareLexicographical(this, o));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Itemset)) {
            return false;
        }
        Itemset o = (Itemset)obj;
        int i1 = this.iter();
        int i2 = o.iter();
        while (this.iterValid(i1) && o.iterValid(i2)) {
            int v2;
            int v1 = this.iterDim(i1);
            if (v1 != (v2 = o.iterDim(i2))) {
                return false;
            }
            i1 = this.iterAdvance(i1);
            i2 = o.iterAdvance(i2);
        }
        return this.iterValid(i1) == o.iterValid(i2);
    }

    @Deprecated
    public int hashCode() {
        throw new APIViolationException("Itemsets may not be used in hash maps.");
    }

    protected static int compareLexicographical(Itemset a, Itemset o) {
        int i1 = a.iter();
        int i2 = o.iter();
        while (a.iterValid(i1) && o.iterValid(i2)) {
            int v2;
            int v1 = a.iterDim(i1);
            if (v1 < (v2 = o.iterDim(i2))) {
                return -1;
            }
            if (v2 < v1) {
                return 1;
            }
            i1 = a.iterAdvance(i1);
            i2 = o.iterAdvance(i2);
        }
        return a.iterValid(i1) ? 1 : (o.iterValid(i2) ? -1 : 0);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(), null).toString();
    }

    public final StringBuilder appendTo(StringBuilder buf, VectorFieldTypeInformation<BitVector> meta) {
        this.appendItemsTo(buf, meta);
        return buf.append(": ").append(this.support);
    }

    public StringBuilder appendItemsTo(StringBuilder buf, VectorFieldTypeInformation<BitVector> meta) {
        int it = this.iter();
        if (this.iterValid(it)) {
            while (true) {
                String lbl;
                int v = this.iterDim(it);
                String string = lbl = meta != null ? meta.getLabel(v) : null;
                if (lbl == null) {
                    buf.append(v);
                } else {
                    buf.append(lbl);
                }
                it = this.iterAdvance(it);
                if (!this.iterValid(it)) break;
                buf.append(", ");
            }
        }
        return buf;
    }
}

